/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact;

import edu.cmu.cs.dennisc.awt.event.KeyEventUtilities;
import org.alice.interact.InputState;

public class ModifierMask {
    public static ModifierKey[] NO_MODIFIERS_DOWN = new ModifierKey[]{ModifierKey.NOT_CONTROL, ModifierKey.NOT_ALT, ModifierKey.NOT_SHIFT};
    private ModifierKey[] keys;
    private TestType testType;

    public ModifierMask() {
        this.testType = TestType.ALL_MUST_BE_VALID;
        this.setKeys(new ModifierKey[0]);
    }

    public ModifierMask(ModifierKey[] keys, TestType testType) {
        this.testType = testType;
        this.setKeys(keys);
    }

    public ModifierMask(ModifierKey[] keys) {
        this(keys, TestType.ALL_MUST_BE_VALID);
    }

    public ModifierMask(ModifierKey key) {
        this(key, TestType.ALL_MUST_BE_VALID);
    }

    public ModifierMask(ModifierKey key, TestType testType) {
        ModifierKey[] keyArray = new ModifierKey[]{key};
        this.setKeys(keyArray);
        this.testType = testType;
    }

    public void setKeys(ModifierKey[] keys) {
        this.keys = keys;
    }

    public boolean anyValid(InputState state) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].testKey(state)) continue;
            return true;
        }
        return false;
    }

    public boolean allValid(InputState state) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i].testKey(state)) continue;
            return false;
        }
        return true;
    }

    public boolean test(InputState state) {
        switch (this.testType) {
            case ANY_MAY_BE_VALID: {
                return this.anyValid(state);
            }
            case ALL_MUST_BE_VALID: {
                return this.allValid(state);
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ModifierKey {
        CONTROL(KeyEventUtilities.getQuoteControlUnquoteKey(), false),
        NOT_CONTROL(KeyEventUtilities.getQuoteControlUnquoteKey(), true),
        ALT(KeyEventUtilities.getQuoteAltUnquoteKey(), false),
        NOT_ALT(KeyEventUtilities.getQuoteAltUnquoteKey(), true),
        SHIFT(16, false),
        NOT_SHIFT(16, true);

        private int keyValue;
        private boolean inverted;

        private ModifierKey(int keyValue, boolean inverted) {
            this.keyValue = keyValue;
            this.inverted = inverted;
        }

        public int getKeyValue() {
            return this.keyValue;
        }

        public boolean testKey(InputState state) {
            boolean isDown = state.isKeyDown(this.keyValue);
            if (this.inverted) {
                return !isDown;
            }
            return isDown;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TestType {
        ALL_MUST_BE_VALID,
        ANY_MAY_BE_VALID;

    }
}

