/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact;

import edu.cmu.cs.dennisc.math.Angle;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.scenegraph.AsSeenBy;
import edu.cmu.cs.dennisc.scenegraph.StandIn;
import edu.cmu.cs.dennisc.scenegraph.Transformable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MovementType {
    STOOD_UP(0),
    LOCAL(1),
    ABSOLUTE(2);

    private int index;

    private MovementType(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isIndex(int index) {
        return this.index == index;
    }

    public void applyTranslation(Transformable transformable, Point3 translateAmount) {
        switch (this) {
            case STOOD_UP: {
                StandIn standIn = new StandIn();
                standIn.vehicle.setValue(transformable);
                standIn.setAxesOnlyToStandUp();
                transformable.applyTranslation(translateAmount, standIn);
                break;
            }
            case LOCAL: {
                transformable.applyTranslation(translateAmount, transformable);
                break;
            }
            case ABSOLUTE: {
                transformable.applyTranslation(translateAmount, AsSeenBy.SCENE);
            }
        }
    }

    public void applyRotation(Transformable transformable, Vector3 rotationAxis, Angle rotation) {
        switch (this) {
            case STOOD_UP: {
                StandIn standIn = new StandIn();
                standIn.vehicle.setValue(transformable);
                standIn.setAxesOnlyToStandUp();
                transformable.applyRotationAboutArbitraryAxis(rotationAxis, rotation, standIn);
                break;
            }
            case LOCAL: {
                transformable.applyRotationAboutArbitraryAxis(rotationAxis, rotation, transformable);
                break;
            }
            case ABSOLUTE: {
                transformable.applyRotationAboutArbitraryAxis(rotationAxis, rotation, AsSeenBy.SCENE);
            }
        }
    }

    public static MovementType getMovementTypeForIndex(int index) {
        MovementType[] types;
        for (MovementType currentType : types = MovementType.values()) {
            if (!currentType.isIndex(index)) continue;
            return currentType;
        }
        return null;
    }
}

