/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.condition;

import org.alice.interact.InputState;
import org.alice.interact.condition.InputCondition;

public class AndInputCondition
extends InputCondition {
    private InputCondition[] requiredConditions;

    public AndInputCondition(InputCondition conditionA, InputCondition conditionB) {
        InputCondition[] reqConds = new InputCondition[]{conditionA, conditionB};
        this.setRequiredConditions(reqConds);
    }

    public AndInputCondition(InputCondition[] requiredConditions) {
        this.setRequiredConditions(requiredConditions);
    }

    public void setRequiredConditions(InputCondition[] requiredConditions) {
        this.requiredConditions = requiredConditions;
    }

    public boolean isRunning(InputState currentState, InputState previousState) {
        for (int i = 0; i < this.requiredConditions.length; ++i) {
            if (this.requiredConditions[i].isRunning(currentState, previousState)) continue;
            return false;
        }
        return true;
    }

    public boolean justEnded(InputState currentState, InputState previousState) {
        for (int i = 0; i < this.requiredConditions.length; ++i) {
            if (!this.requiredConditions[i].justEnded(currentState, previousState)) continue;
            return true;
        }
        return false;
    }

    public boolean justStarted(InputState currentState, InputState previousState) {
        boolean anyStart = false;
        for (int i = 0; i < this.requiredConditions.length; ++i) {
            if (this.requiredConditions[i].justStarted(currentState, previousState)) {
                anyStart = true;
                continue;
            }
            if (this.requiredConditions[i].isRunning(currentState, previousState)) continue;
            return false;
        }
        return anyStart;
    }

    public boolean stateChanged(InputState currentState, InputState previousState) {
        for (int i = 0; i < this.requiredConditions.length; ++i) {
            if (!this.requiredConditions[i].stateChanged(currentState, previousState)) continue;
            return true;
        }
        return false;
    }

    protected boolean testState(InputState state) {
        for (int i = 0; i < this.requiredConditions.length; ++i) {
            if (this.requiredConditions[i].testState(state)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String string = "";
        boolean isFirst = true;
        for (InputCondition input : this.requiredConditions) {
            if (isFirst) {
                isFirst = false;
            } else {
                string = string + " AND ";
            }
            string = string + input;
        }
        return string;
    }
}

