/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.condition;

import java.util.Vector;
import org.alice.interact.InputState;
import org.alice.interact.condition.InputCondition;
import org.alice.interact.manipulator.AbstractManipulator;

public class ManipulatorConditionSet {
    private AbstractManipulator manipulator;
    private Vector<InputCondition> inputConditions = new Vector();

    public ManipulatorConditionSet(AbstractManipulator manipulator) {
        this.manipulator = manipulator;
    }

    public void addCondition(InputCondition inputCondition) {
        this.inputConditions.add(inputCondition);
    }

    public AbstractManipulator getManipulator() {
        return this.manipulator;
    }

    private boolean checkCondition(RunningState state, InputState current, InputState previous) {
        switch (state) {
            case CHANGED: {
                for (int i = 0; i < this.inputConditions.size(); ++i) {
                    if (!this.inputConditions.get(i).stateChanged(current, previous)) continue;
                    return true;
                }
                break;
            }
            case JUST_STARTED: {
                for (int i = 0; i < this.inputConditions.size(); ++i) {
                    if (!this.inputConditions.get(i).justStarted(current, previous)) continue;
                    return true;
                }
                break;
            }
            case IS_RUNNING: {
                for (int i = 0; i < this.inputConditions.size(); ++i) {
                    if (!this.inputConditions.get(i).isRunning(current, previous)) continue;
                    return true;
                }
                break;
            }
            case JUST_ENDED: {
                for (int i = 0; i < this.inputConditions.size(); ++i) {
                    if (!this.inputConditions.get(i).justEnded(current, previous)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public boolean stateChanged(InputState current, InputState previous) {
        return this.checkCondition(RunningState.CHANGED, current, previous);
    }

    public boolean shouldContinue(InputState current, InputState previous) {
        return this.checkCondition(RunningState.IS_RUNNING, current, previous);
    }

    public boolean justStarted(InputState current, InputState previous) {
        boolean someoneIsRunning = this.checkCondition(RunningState.IS_RUNNING, current, previous);
        boolean someoneJustStarted = this.checkCondition(RunningState.JUST_STARTED, current, previous);
        return !someoneIsRunning && someoneJustStarted;
    }

    public boolean justEnded(InputState current, InputState previous) {
        boolean someoneIsRunning = this.checkCondition(RunningState.IS_RUNNING, current, previous);
        boolean someoneJustStarted = this.checkCondition(RunningState.JUST_STARTED, current, previous);
        boolean someoneJustEnded = this.checkCondition(RunningState.JUST_ENDED, current, previous);
        return !someoneIsRunning && !someoneJustStarted && someoneJustEnded;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RunningState {
        JUST_STARTED,
        IS_RUNNING,
        JUST_ENDED,
        CHANGED;

    }
}

