/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.condition;

import org.alice.interact.InputState;
import org.alice.interact.PickHint;
import org.alice.interact.condition.InputCondition;
import org.alice.interact.condition.PickCondition;

public class SelectedObjectCondition
extends InputCondition {
    PickHint acceptableType = PickHint.EVERYTHING;
    protected boolean isNot = false;
    private ObjectSwitchBehavior switchBehavior = ObjectSwitchBehavior.END_ON_SWITCH;

    public SelectedObjectCondition(PickHint acceptableType) {
        this(acceptableType, ObjectSwitchBehavior.END_ON_SWITCH);
    }

    public SelectedObjectCondition(PickHint acceptableType, ObjectSwitchBehavior switchBehavior) {
        this.acceptableType = acceptableType;
        this.switchBehavior = switchBehavior;
    }

    protected boolean testState(InputState state) {
        boolean isValid = this.acceptableType.intersects(PickCondition.getPickType(state.getCurrentlySelectedObject()));
        if (this.isNot) {
            return !isValid;
        }
        return isValid;
    }

    protected boolean selectedObjectSwitched(InputState currentState, InputState previousState) {
        if (this.switchBehavior == ObjectSwitchBehavior.END_ON_SWITCH) {
            return currentState.getCurrentlySelectedObject() != previousState.getCurrentlySelectedObject();
        }
        return false;
    }

    public boolean isRunning(InputState currentState, InputState previousState) {
        return super.isRunning(currentState, previousState) && !this.selectedObjectSwitched(currentState, previousState);
    }

    public boolean justEnded(InputState currentState, InputState previousState) {
        if (super.justEnded(currentState, previousState)) {
            return true;
        }
        if (this.testState(previousState)) {
            return this.selectedObjectSwitched(currentState, previousState);
        }
        return false;
    }

    public boolean justStarted(InputState currentState, InputState previousState) {
        if (super.justStarted(currentState, previousState)) {
            return true;
        }
        if (this.testState(currentState)) {
            return this.selectedObjectSwitched(currentState, previousState);
        }
        return false;
    }

    public boolean stateChanged(InputState currentState, InputState previousState) {
        if (this.switchBehavior == ObjectSwitchBehavior.END_ON_SWITCH && currentState.getCurrentlySelectedObject() != previousState.getCurrentlySelectedObject()) {
            return true;
        }
        return this.testState(currentState) != this.testState(previousState);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ObjectSwitchBehavior {
        END_ON_SWITCH,
        IGNORE_SWITCH;

    }
}

