/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.handle;

import edu.cmu.cs.dennisc.animation.Animator;
import edu.cmu.cs.dennisc.scenegraph.Transformable;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.alice.interact.event.ManipulationEvent;
import org.alice.interact.event.ManipulationEventCriteria;
import org.alice.interact.event.ManipulationListener;
import org.alice.interact.handle.HandleSet;
import org.alice.interact.handle.ManipulationHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandleManager
implements ManipulationListener {
    private Stack<HandleSet> handleSetStack = new Stack();
    private List<ManipulationHandle> handles = new ArrayList<ManipulationHandle>();

    public void addHandle(ManipulationHandle handle) {
        this.handles.add(handle);
        handle.setHandleManager(this);
    }

    public HandleSet getCurrentHandleSet() {
        if (this.handleSetStack.empty()) {
            return null;
        }
        return this.handleSetStack.peek();
    }

    private void updateHandlesBasedOnHandleSet() {
        for (ManipulationHandle handle : this.handles) {
            if (handle.isAlwaysVisible()) continue;
            if (handle.isMemberOf(this.getCurrentHandleSet())) {
                handle.setHandleVisible(true);
                continue;
            }
            handle.setHandleVisible(false);
        }
    }

    public void setHandleSet(HandleSet handleSet) {
        if (!this.handleSetStack.empty()) {
            this.handleSetStack.pop();
        }
        this.handleSetStack.push(handleSet);
        this.updateHandlesBasedOnHandleSet();
    }

    public void pushNewHandleSet(HandleSet handleSet) {
        this.handleSetStack.push(handleSet);
        this.updateHandlesBasedOnHandleSet();
    }

    public HandleSet popHandleSet() {
        if (this.handleSetStack.empty()) {
            System.err.println("TRYING TO POP AN EMPTY HANDLE STACK!!!");
            Thread.dumpStack();
            return null;
        }
        HandleSet popped = this.handleSetStack.pop();
        this.updateHandlesBasedOnHandleSet();
        return popped;
    }

    public void setSelectedObject(Transformable selectedObject) {
        for (ManipulationHandle handle : this.handles) {
            handle.setSelectedObject(selectedObject);
        }
    }

    public void setAnimator(Animator animator) {
        for (ManipulationHandle handle : this.handles) {
            handle.setAnimator(animator);
        }
    }

    public boolean isHandleVisible(ManipulationHandle handle) {
        if (handle.isAlwaysVisible()) {
            return true;
        }
        return handle.isMemberOf(this.getCurrentHandleSet());
    }

    private List<ManipulationHandle> getSiblings(ManipulationHandle handle) {
        ArrayList<ManipulationHandle> siblings = new ArrayList<ManipulationHandle>();
        HandleSet toCheck = handle.isAlwaysVisible() ? handle.getHandleSet() : (handle.isMemberOf(this.getCurrentHandleSet()) ? this.getCurrentHandleSet() : new HandleSet(new HandleSet.HandleGroup[0]));
        for (ManipulationHandle otherHandle : this.handles) {
            if (otherHandle == handle) continue;
            if (handle.isAlwaysVisible()) {
                if (!otherHandle.getHandleSet().equals(toCheck)) continue;
                siblings.add(otherHandle);
                continue;
            }
            if (!otherHandle.isMemberOf(toCheck)) continue;
            siblings.add(otherHandle);
        }
        return siblings;
    }

    public boolean isASiblingActive(ManipulationHandle handle) {
        List<ManipulationHandle> siblings = this.getSiblings(handle);
        for (ManipulationHandle sibling : siblings) {
            if (!sibling.getHandleStateCopy().isActive()) continue;
            return true;
        }
        return false;
    }

    public void setHandleRollover(ManipulationHandle handle, boolean isRollover) {
        handle.setHandleRollover(isRollover);
    }

    @Override
    public void activate(ManipulationEvent event) {
    }

    @Override
    public void deactivate(ManipulationEvent event) {
    }

    @Override
    public void addCondition(ManipulationEventCriteria condition) {
    }

    @Override
    public boolean matches(ManipulationEvent event) {
        return false;
    }

    @Override
    public void removeCondition(ManipulationEventCriteria condition) {
    }
}

