/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.handle;

import org.alice.interact.handle.HandleState;
import org.alice.interact.handle.ManipulationHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HandleRenderState {
    JUST_VISIBLE,
    VISIBLE_BUT_SIBLING_IS_ACTIVE,
    VISIBLE_AND_ACTIVE,
    NOT_VISIBLE,
    VISIBLE_AND_ROLLOVER;


    public static HandleRenderState getStateForHandle(ManipulationHandle handle) {
        HandleState handleState;
        boolean isSiblingActive = false;
        if (handle.getHandleManager() != null) {
            isSiblingActive = handle.getHandleManager().isASiblingActive(handle);
        }
        if ((handleState = handle.getHandleStateCopy()).isActive()) {
            return VISIBLE_AND_ACTIVE;
        }
        if (handleState.isRollover()) {
            return VISIBLE_AND_ROLLOVER;
        }
        if (handle.isAlwaysVisible()) {
            return JUST_VISIBLE;
        }
        if (handleState.isVisible()) {
            if (isSiblingActive) {
                return VISIBLE_BUT_SIBLING_IS_ACTIVE;
            }
            return JUST_VISIBLE;
        }
        return NOT_VISIBLE;
    }
}

