/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.handle;

import java.util.BitSet;

public class HandleSet
extends BitSet {
    public static HandleSet GROUND_TRANSLATION_VISUALIZATION = new HandleSet(HandleGroup.TRANSLATION, HandleGroup.VISUALIZATION, HandleGroup.X_AND_Z_AXIS);
    public static HandleSet UP_DOWN_TRANSLATION_VISUALIZATION = new HandleSet(HandleGroup.TRANSLATION, HandleGroup.VISUALIZATION, HandleGroup.Y_AXIS);
    public static HandleSet DEFAULT_INTERACTION = new HandleSet(HandleGroup.DEFAULT, HandleGroup.INTERACTION);
    public static HandleSet RESIZE_INTERACTION = new HandleSet(HandleGroup.RESIZE, HandleGroup.INTERACTION);
    public static HandleSet ROTATION_INTERACTION = new HandleSet(HandleGroup.ROTATION, HandleGroup.INTERACTION);
    public static HandleSet TRANSLATION_INTERACTION = new HandleSet(HandleGroup.TRANSLATION, HandleGroup.INTERACTION);

    public boolean intersects(BitSet set) {
        if (set == null) {
            return false;
        }
        boolean intersection = false;
        for (int i = 0; i < set.length(); ++i) {
            if (set.get(i) && this.get(i)) {
                intersection = true;
                continue;
            }
            if (!set.get(i) || this.get(i)) continue;
            return false;
        }
        return intersection;
    }

    public void addSet(HandleSet set) {
        this.or(set);
    }

    public static String getStringForSet(HandleSet set) {
        if (set == RESIZE_INTERACTION) {
            return "Resize";
        }
        if (set == ROTATION_INTERACTION) {
            return "Rotation";
        }
        if (set == TRANSLATION_INTERACTION) {
            return "Move";
        }
        if (set == DEFAULT_INTERACTION) {
            return "Default";
        }
        return "NO STRING SET";
    }

    public HandleSet(HandleGroup ... groups) {
        this.addGroups(groups);
    }

    public void addGroup(HandleGroup group) {
        this.set(group.getIndex());
    }

    public void addGroups(HandleGroup ... groups) {
        for (int i = 0; i < groups.length; ++i) {
            this.set(groups[i].getIndex());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HandleGroup {
        ROTATION(0),
        TRANSLATION(1),
        RESIZE(2),
        DEFAULT(3),
        LOCAL(4),
        STOOD_UP(5),
        ABSOLUTE(6),
        VISUALIZATION(7),
        INTERACTION(8),
        X_AXIS(9),
        Y_AXIS(10),
        Z_AXIS(11),
        RESIZE_AXIS(12),
        X_AND_Z_AXIS(13),
        X_AND_Y_AXIS(14),
        CAMERA(15);

        private int index;

        private HandleGroup(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

