/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.handle;

import edu.cmu.cs.dennisc.math.Vector2;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import org.alice.interact.event.ManipulationEvent;
import org.alice.interact.handle.HandleRenderState;
import org.alice.interact.handle.ManipulationHandle2D;

public abstract class ImageBasedManipulationHandle2D
extends ManipulationHandle2D {
    protected ImageState currentState;
    protected BufferedImage imageMask;

    public ImageBasedManipulationHandle2D() {
        this.setImageMask();
        this.setStateBasedOnManipulationStatus();
        Dimension size = new Dimension(this.getIcon().getIconWidth(), this.getIcon().getIconHeight());
        this.setSize(size);
        this.setMinimumSize(size);
        this.setPreferredSize(size);
    }

    public Color getColor(int x, int y) {
        if (super.contains(x, y) && this.imageMask != null) {
            int colorInt = this.imageMask.getRGB(x, y);
            Color color = new Color(colorInt, true);
            return color;
        }
        return null;
    }

    protected abstract void setImageMask();

    public boolean contains(int x, int y) {
        Color color = this.getColor(x, y);
        if (color != null) {
            return color.getAlpha() != 0;
        }
        return super.contains(x, y);
    }

    public Vector2 getCenter() {
        Dimension ourSize = new Dimension();
        if (this.currentState != null) {
            ourSize.width = this.currentState.getIcon().getIconWidth();
            ourSize.height = this.currentState.getIcon().getIconHeight();
        }
        return new Vector2((double)ourSize.width * 0.5, (double)ourSize.height * 0.5);
    }

    protected void updateVisibleState(HandleRenderState renderState) {
        this.setStateBasedOnManipulationStatus();
    }

    private void setStateBasedOnManipulationStatus() {
        ImageState newState = this.getStateForManipulationStatus();
        if (newState != this.currentState) {
            this.currentState = newState;
            this.setIcon(this.currentState.getIcon());
        }
    }

    public void activate(ManipulationEvent event) {
        this.setManipulationState(event, true);
        this.setStateBasedOnManipulationStatus();
    }

    public void deactivate(ManipulationEvent event) {
        this.setManipulationState(event, false);
        this.setStateBasedOnManipulationStatus();
    }

    protected abstract ImageState getStateForManipulationStatus();

    protected abstract void setManipulationState(ManipulationEvent var1, boolean var2);

    protected static interface ImageState {
        public ImageIcon getIcon();
    }
}

