/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.handle;

import edu.cmu.cs.dennisc.image.ImageUtilities;
import javax.swing.ImageIcon;
import org.alice.interact.PickHint;
import org.alice.interact.event.ManipulationEvent;
import org.alice.interact.handle.ImageBasedManipulationHandle2D;

public class ManipulationHandle2DCameraDriver
extends ImageBasedManipulationHandle2D {
    private boolean turningLeft = false;
    private boolean turningRight = false;
    private boolean movingForward = false;
    private boolean movingBackward = false;

    public PickHint getPickHint() {
        return PickHint.MULTIMODE_HANDLES;
    }

    protected void setImageMask() {
        this.imageMask = ImageUtilities.read(this.getClass().getResource("images/driveMask.png"));
    }

    protected ImageBasedManipulationHandle2D.ImageState getStateForManipulationStatus() {
        if (this.movingBackward && !this.turningLeft && !this.turningRight) {
            return ControlState.Back;
        }
        if (this.movingBackward && this.turningLeft) {
            return ControlState.BackLeft;
        }
        if (this.movingBackward && this.turningRight) {
            return ControlState.BackRight;
        }
        if (this.movingForward && !this.turningLeft && !this.turningRight) {
            return ControlState.Forward;
        }
        if (this.movingForward && this.turningLeft) {
            return ControlState.ForwardLeft;
        }
        if (this.movingForward && this.turningRight) {
            return ControlState.ForwardRight;
        }
        if (this.turningLeft && !this.movingForward && !this.movingBackward) {
            return ControlState.Left;
        }
        if (this.turningRight && !this.movingForward && !this.movingBackward) {
            return ControlState.Right;
        }
        if (this.state.isRollover()) {
            return ControlState.Highlighted;
        }
        return ControlState.Inactive;
    }

    protected void setManipulationState(ManipulationEvent event, boolean isActive) {
        switch (event.getMovementDescription().direction) {
            case BACKWARD: {
                this.movingBackward = isActive;
                break;
            }
            case FORWARD: {
                this.movingForward = isActive;
                break;
            }
            case UP: {
                this.turningLeft = isActive;
                break;
            }
            case DOWN: {
                this.turningRight = isActive;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ControlState implements ImageBasedManipulationHandle2D.ImageState
    {
        Inactive("images/drive.png"),
        Highlighted("images/driveHighlight.png"),
        Back("images/driveBack.png"),
        BackLeft("images/driveBackLeft.png"),
        BackRight("images/driveBackRight.png"),
        Forward("images/driveForward.png"),
        ForwardLeft("images/driveForwardLeft.png"),
        ForwardRight("images/driveForwardRight.png"),
        Left("images/driveLeft.png"),
        Right("images/driveRight.png");

        private ImageIcon icon;

        private ControlState(String resourceString) {
            this.icon = new ImageIcon(this.getClass().getResource(resourceString));
        }

        @Override
        public ImageIcon getIcon() {
            return this.icon;
        }
    }
}

