/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.handle;

import edu.cmu.cs.dennisc.image.ImageUtilities;
import javax.swing.ImageIcon;
import org.alice.interact.event.ManipulationEvent;
import org.alice.interact.handle.ImageBasedManipulationHandle2D;

public class ManipulationHandle2DCameraStrafe
extends ImageBasedManipulationHandle2D {
    private boolean movingLeft = false;
    private boolean movingRight = false;
    private boolean movingUp = false;
    private boolean movingDown = false;

    protected void setImageMask() {
        this.imageMask = ImageUtilities.read(this.getClass().getResource("images/slideMask.png"));
    }

    protected ImageBasedManipulationHandle2D.ImageState getStateForManipulationStatus() {
        if (this.movingDown && !this.movingLeft && !this.movingRight) {
            return ControlState.Down;
        }
        if (this.movingDown && this.movingLeft) {
            return ControlState.DownLeft;
        }
        if (this.movingDown && this.movingRight) {
            return ControlState.DownRight;
        }
        if (this.movingUp && !this.movingLeft && !this.movingRight) {
            return ControlState.Up;
        }
        if (this.movingUp && this.movingLeft) {
            return ControlState.UpLeft;
        }
        if (this.movingUp && this.movingRight) {
            return ControlState.UpRight;
        }
        if (this.movingLeft && !this.movingUp && !this.movingDown) {
            return ControlState.Left;
        }
        if (this.movingRight && !this.movingUp && !this.movingDown) {
            return ControlState.Right;
        }
        if (this.state.isRollover()) {
            return ControlState.Highlighted;
        }
        return ControlState.Inactive;
    }

    protected void setManipulationState(ManipulationEvent event, boolean isActive) {
        switch (event.getMovementDescription().direction) {
            case UP: {
                this.movingUp = isActive;
                break;
            }
            case DOWN: {
                this.movingDown = isActive;
                break;
            }
            case LEFT: {
                this.movingLeft = isActive;
                break;
            }
            case RIGHT: {
                this.movingRight = isActive;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ControlState implements ImageBasedManipulationHandle2D.ImageState
    {
        Inactive("images/slide.png"),
        Highlighted("images/slideHighlight.png"),
        Down("images/slideDown.png"),
        DownLeft("images/slideDownLeft.png"),
        DownRight("images/slideDownRight.png"),
        Up("images/slideUp.png"),
        UpLeft("images/slideUpLeft.png"),
        UpRight("images/slideUpRight.png"),
        Left("images/slideLeft.png"),
        Right("images/slideRight.png");

        private ImageIcon icon;

        private ControlState(String resourceString) {
            try {
                this.icon = new ImageIcon(this.getClass().getResource(resourceString));
            }
            catch (Exception e) {
                System.err.println("can't load " + resourceString);
            }
        }

        @Override
        public ImageIcon getIcon() {
            return this.icon;
        }
    }
}

