/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.handle;

import edu.cmu.cs.dennisc.animation.Animator;
import edu.cmu.cs.dennisc.color.Color4f;
import edu.cmu.cs.dennisc.math.AbstractMatrix3x3;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.AngleInRadians;
import edu.cmu.cs.dennisc.math.AxisAlignedBox;
import edu.cmu.cs.dennisc.math.Matrix3x3;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.ScaleUtilities;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.property.event.PropertyEvent;
import edu.cmu.cs.dennisc.property.event.PropertyListener;
import edu.cmu.cs.dennisc.scenegraph.Component;
import edu.cmu.cs.dennisc.scenegraph.ReferenceFrame;
import edu.cmu.cs.dennisc.scenegraph.SingleAppearance;
import edu.cmu.cs.dennisc.scenegraph.Transformable;
import edu.cmu.cs.dennisc.scenegraph.Visual;
import org.alice.interact.AbstractDragAdapter;
import org.alice.interact.ColorTargetBasedAnimation;
import org.alice.interact.DoubleTargetBasedAnimation;
import org.alice.interact.InputState;
import org.alice.interact.PickHint;
import org.alice.interact.condition.PickCondition;
import org.alice.interact.event.EventCriteriaManager;
import org.alice.interact.event.ManipulationEvent;
import org.alice.interact.event.ManipulationEventCriteria;
import org.alice.interact.event.ManipulationListener;
import org.alice.interact.handle.HandleManager;
import org.alice.interact.handle.HandleRenderState;
import org.alice.interact.handle.HandleSet;
import org.alice.interact.handle.HandleState;
import org.alice.interact.handle.ManipulationHandle;
import org.alice.interact.manipulator.AbstractManipulator;

public abstract class ManipulationHandle3D
extends Transformable
implements ManipulationHandle,
ManipulationListener,
Cloneable {
    protected Visual sgVisual = new Visual();
    protected SingleAppearance sgFrontFacingAppearance = new SingleAppearance();
    protected Transformable manipulatedObject;
    protected Animator animator;
    private EventCriteriaManager criteriaManager = new EventCriteriaManager();
    protected HandleState state = new HandleState();
    protected HandleManager handleManager = null;
    protected HandleSet handleSet = new HandleSet(new HandleSet.HandleGroup[0]);
    protected DoubleTargetBasedAnimation opacityAnimation;
    protected ColorTargetBasedAnimation colorAnimation;
    protected AbstractManipulator manipulation = null;
    protected AbstractDragAdapter dragAdapter = null;
    protected boolean isPickable = false;
    protected ScaleChangeListener scaleListener = new ScaleChangeListener();

    public void setManipulatedObject(Transformable manipulatedObjectIn) {
        Visual visualElement;
        if (this.manipulatedObject != null && (visualElement = this.getSGVisualForTransformable(this.manipulatedObject)) != null) {
            visualElement.scale.removePropertyListener(this.scaleListener);
        }
        if (this.manipulatedObject != manipulatedObjectIn) {
            this.manipulatedObject = manipulatedObjectIn;
            this.setParent(this.manipulatedObject);
            this.setScale(this.getObjectScale());
        }
        if (this.manipulatedObject != null && (visualElement = this.getSGVisualForTransformable(this.manipulatedObject)) != null) {
            visualElement.scale.addPropertyListener(this.scaleListener);
        }
    }

    public void setSelectedObject(Transformable selectedObject) {
        this.setManipulatedObject(selectedObject);
    }

    public void setDragAdapter(AbstractDragAdapter dragAdapter) {
        this.dragAdapter = dragAdapter;
        if (this.dragAdapter != null) {
            this.dragAdapter.addHandle(this);
        }
    }

    public abstract ManipulationHandle3D clone();

    protected abstract void setScale(double var1);

    protected void initFromHandle(ManipulationHandle3D handle) {
        this.manipulatedObject = handle.manipulatedObject;
        this.state = new HandleState(handle.state);
        this.handleSet.clear();
        this.handleSet.addSet(handle.handleSet);
        this.localTransformation.setValue(new AffineMatrix4x4((AffineMatrix4x4)handle.localTransformation.getValue()));
        this.animator = handle.animator;
        this.criteriaManager = handle.criteriaManager;
        this.handleManager = handle.handleManager;
        this.manipulation = handle.manipulation;
    }

    public ManipulationHandle3D() {
        HandleRenderState renderState = HandleRenderState.getStateForHandle(this);
        this.sgFrontFacingAppearance.diffuseColor.setValue(this.getDesiredColor(renderState));
        this.sgFrontFacingAppearance.opacity.setValue(new Float(this.getDesiredOpacity(renderState)));
        this.sgVisual.frontFacingAppearance.setValue(this.sgFrontFacingAppearance);
        this.sgVisual.setParent(this);
        this.setParent(null);
        this.putBonusDataFor("PICK_HINT_KEY", PickHint.HANDLES);
    }

    protected void initializeAppearance() {
        HandleRenderState renderState = HandleRenderState.getStateForHandle(this);
        this.sgFrontFacingAppearance.diffuseColor.setValue(this.getDesiredColor(renderState));
        this.sgFrontFacingAppearance.opacity.setValue(new Float(this.getDesiredOpacity(renderState)));
    }

    protected Matrix3x3 getTransformableScale(Transformable t) {
        Matrix3x3 returnScale;
        Visual objectVisual = this.getSGVisualForTransformable(t);
        if (objectVisual != null) {
            returnScale = new Matrix3x3();
            returnScale.setValue((AbstractMatrix3x3)objectVisual.scale.getValue());
        } else {
            returnScale = ScaleUtilities.newScaleMatrix3d(1.0, 1.0, 1.0);
        }
        return returnScale;
    }

    protected void setTransformableScale(Transformable t, Matrix3x3 scaleMatrix) {
        Visual objectVisual = this.getSGVisualForTransformable(t);
        objectVisual.scale.setValue(scaleMatrix);
    }

    protected Visual getSGVisualForTransformable(Transformable object) {
        for (int i = 0; i < object.getComponentCount(); ++i) {
            Component c = object.getComponentAt(i);
            if (!(c instanceof Visual)) continue;
            return (Visual)c;
        }
        return null;
    }

    protected void createAnimations() {
        this.opacityAnimation = new DoubleTargetBasedAnimation(new Double(((Float)this.sgFrontFacingAppearance.opacity.getValue()).floatValue())){

            protected void updateValue(Double value) {
                ManipulationHandle3D.this.sgFrontFacingAppearance.opacity.setValue(Float.valueOf(value.floatValue()));
            }
        };
        this.colorAnimation = new ColorTargetBasedAnimation((Color4f)this.sgFrontFacingAppearance.diffuseColor.getValue()){

            protected void updateValue(Color4f value) {
                ManipulationHandle3D.this.sgFrontFacingAppearance.diffuseColor.setValue(value);
            }
        };
        this.animator.invokeLater(this.opacityAnimation, null);
        this.animator.invokeLater(this.colorAnimation, null);
    }

    public void addToSet(HandleSet set) {
        this.handleSet.addSet(set);
    }

    public HandleSet getHandleSet() {
        return this.handleSet;
    }

    public boolean isAlwaysVisible() {
        return false;
    }

    public void addToGroup(HandleSet.HandleGroup group) {
        this.handleSet.addGroup(group);
    }

    public void addToGroups(HandleSet.HandleGroup ... groups) {
        this.handleSet.addGroups(groups);
    }

    public boolean isMemberOf(HandleSet set) {
        return this.handleSet.intersects(set);
    }

    public boolean isMemberOf(HandleSet.HandleGroup group) {
        return this.handleSet.get(group.getIndex());
    }

    public void setAnimator(Animator animator) {
        assert (animator != null);
        this.animator = animator;
        this.createAnimations();
    }

    public Visual getSGVisual() {
        return this.sgVisual;
    }

    public SingleAppearance getSGFrontFacingAppearance() {
        return this.sgFrontFacingAppearance;
    }

    public Transformable getManipulatedObject() {
        return (Transformable)this.getParent();
    }

    public void setName(String name) {
        super.setName(name);
        this.sgVisual.setName(name + ".sgVisual");
        this.sgFrontFacingAppearance.setName(name + ".sgFrontFacingAppearance");
    }

    public ReferenceFrame getReferenceFrame() {
        return this.getManipulatedObject();
    }

    public abstract void positionRelativeToObject();

    public abstract void resizeToObject();

    protected void updateVisibleState(HandleRenderState renderState) {
        if (this.opacityAnimation != null) {
            this.opacityAnimation.setTarget(this.getDesiredOpacity(renderState));
        }
        if (this.colorAnimation != null) {
            this.colorAnimation.setTarget(this.getDesiredColor(renderState));
        }
    }

    public boolean matches(ManipulationEvent event) {
        return this.criteriaManager.matches(event);
    }

    public void addCondition(ManipulationEventCriteria condition) {
        this.criteriaManager.addCondition(condition);
    }

    public void removeCondition(ManipulationEventCriteria condition) {
        this.criteriaManager.removeCondition(condition);
    }

    public void activate(ManipulationEvent event) {
        this.setHandleActive(true);
    }

    public void deactivate(ManipulationEvent event) {
        this.setHandleActive(false);
    }

    protected Color4f getBaseColor() {
        return Color4f.YELLOW;
    }

    protected Color4f getDesiredColor(HandleRenderState renderState) {
        Color4f baseColor = this.getBaseColor();
        switch (renderState) {
            case NOT_VISIBLE: {
                return baseColor;
            }
            case VISIBLE_BUT_SIBLING_IS_ACTIVE: {
                return baseColor;
            }
            case VISIBLE_AND_ACTIVE: {
                return baseColor;
            }
            case VISIBLE_AND_ROLLOVER: {
                return baseColor;
            }
            case JUST_VISIBLE: {
                return baseColor;
            }
        }
        return baseColor;
    }

    protected double getDesiredOpacity(HandleRenderState renderState) {
        switch (renderState) {
            case NOT_VISIBLE: {
                return 0.0;
            }
            case VISIBLE_BUT_SIBLING_IS_ACTIVE: {
                return 0.5;
            }
            case VISIBLE_AND_ACTIVE: {
                return 1.0;
            }
            case VISIBLE_AND_ROLLOVER: {
                return 0.75;
            }
            case JUST_VISIBLE: {
                return 0.6;
            }
        }
        return 0.0;
    }

    public AffineMatrix4x4 getTransformationForAxis(Vector3 axis) {
        double upDot = Vector3.calculateDotProduct(axis, Vector3.accessPositiveYAxis());
        AffineMatrix4x4 transform = new AffineMatrix4x4();
        if (Math.abs(upDot) != 1.0) {
            Vector3 rightAxis = Vector3.createCrossProduct(axis, Vector3.accessPositiveYAxis());
            rightAxis.normalize();
            Vector3 upAxis = axis;
            Vector3 backwardAxis = Vector3.createCrossProduct(rightAxis, upAxis);
            backwardAxis.normalize();
            transform.orientation.set(rightAxis, upAxis, backwardAxis);
        } else if (upDot == -1.0) {
            transform.applyRotationAboutXAxis(new AngleInRadians(Math.PI));
        }
        return transform;
    }

    public void setManipulation(AbstractManipulator manipulation) {
        this.manipulation = manipulation;
        if (this.manipulation != null) {
            this.setPickable(true);
        }
    }

    public AbstractManipulator getManipulation(InputState input) {
        return this.manipulation;
    }

    public void setHandleManager(HandleManager handleManager) {
        this.handleManager = handleManager;
    }

    public HandleManager getHandleManager() {
        return this.handleManager;
    }

    public HandleState getHandleStateCopy() {
        return new HandleState(this.state);
    }

    public boolean isRenderable() {
        if (this.isAlwaysVisible()) {
            return true;
        }
        return this.state.shouldRender();
    }

    protected double getObjectScale() {
        if (this.manipulatedObject == null) {
            return 1.0;
        }
        double VOLUME_NORMALIZER = 1.0;
        AxisAlignedBox bbox = this.getManipulatedObjectBox();
        if (bbox == null) {
            return 1.0;
        }
        Point3 max = bbox.getMaximum();
        max.y = 0.0;
        Point3 min = bbox.getMinimum();
        min.y = 0.0;
        double volume = Point3.createSubtraction(max, min).calculateMagnitude();
        double scale = volume / 1.0;
        if (scale < 0.25) {
            scale = 0.25;
        }
        if (scale > 2.0) {
            scale = 2.0;
        }
        return scale;
    }

    protected AxisAlignedBox getManipulatedObjectBox() {
        Object bbox;
        AxisAlignedBox boundingBox = null;
        if (this.manipulatedObject != null && (bbox = this.manipulatedObject.getBonusDataFor("BOUNDING_BOX_KEY")) instanceof AxisAlignedBox && (boundingBox = new AxisAlignedBox((AxisAlignedBox)bbox)).isNaN()) {
            boundingBox = null;
        }
        if (boundingBox == null) {
            boundingBox = new AxisAlignedBox(new Point3(-1.0, 0.0, -1.0), new Point3(1.0, 1.0, 1.0));
        }
        if (boundingBox != null) {
            boundingBox.scale(this.getTransformableScale(this.manipulatedObject));
        }
        return boundingBox;
    }

    public void setPickable(boolean isPickable) {
        this.isPickable = isPickable;
    }

    public boolean isPickable() {
        if (this.isPickable) {
            return this.state.isVisible();
        }
        return false;
    }

    public void setHandleActive(boolean active) {
        this.state.setActive(active);
        this.updateVisibleState(HandleRenderState.getStateForHandle(this));
    }

    public void setHandleRollover(boolean rollover) {
        this.state.setRollover(rollover);
        this.updateVisibleState(HandleRenderState.getStateForHandle(this));
    }

    public void setHandleVisible(boolean visible) {
        this.state.setVisible(visible);
        this.updateVisibleState(HandleRenderState.getStateForHandle(this));
    }

    public PickHint getPickHint() {
        return PickCondition.getPickType(this);
    }

    protected class ScaleChangeListener
    implements PropertyListener {
        protected ScaleChangeListener() {
        }

        public void propertyChanged(PropertyEvent e) {
            ManipulationHandle3D.this.setScale(ManipulationHandle3D.this.getObjectScale());
            ManipulationHandle3D.this.positionRelativeToObject();
        }

        public void propertyChanging(PropertyEvent e) {
        }
    }
}

