/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.manipulator;

import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.AngleInRadians;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.math.Vector2;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.scenegraph.ReferenceFrame;
import edu.cmu.cs.dennisc.scenegraph.Transformable;
import java.awt.Color;
import org.alice.interact.InputState;
import org.alice.interact.event.ManipulationEvent;
import org.alice.interact.handle.ImageBasedManipulationHandle2D;
import org.alice.interact.manipulator.CameraManipulator2D;

public abstract class Camera2DDragManipulator
extends CameraManipulator2D {
    protected static final double MIN_TIME = 0.001;
    protected static final double MAX_TIME = 0.1;
    protected static final double MIN_AMOUNT_TO_MOVE = 0.005;
    protected static final double WORLD_DISTANCE_PER_PIXEL_SECONDS = 0.1;
    protected static final double RADIANS_PER_PIXEL_SECONDS = 0.02;
    protected static final double MIN_PIXEL_MOVE_AMOUNT = 10.0;
    protected Vector3 initialMoveFactor = new Vector3(0.0, 0.0, 0.0);
    protected Vector3 initialRotateFactor = new Vector3(0.0, 0.0, 0.0);
    protected static final double INITIAL_MOVE_FACTOR = 10.0;
    protected static final double INITIAL_ROTATE_FACTOR = 8.0;
    protected Transformable standUpReference = new Transformable();
    protected Color initialHandleColor = null;
    protected Vector2 initialMousePosition = new Vector2();

    public Camera2DDragManipulator(ImageBasedManipulationHandle2D handle) {
        super(handle);
    }

    protected abstract void initializeEventMessages();

    public void doDataUpdateManipulator(InputState currentInput, InputState previousInput) {
    }

    public void doEndManipulator(InputState endInput, InputState previousInput) {
    }

    public String getUndoRedoDescription() {
        return "Camera Move";
    }

    public boolean doStartManipulator(InputState startInput) {
        if (super.doStartManipulator(startInput)) {
            this.initializeEventMessages();
            this.standUpReference.setParent(this.getCamera().getParent());
            this.standUpReference.localTransformation.setValue(AffineMatrix4x4.createIdentity());
            this.standUpReference.setAxesOnlyToStandUp();
            this.initialMousePosition.x = startInput.getMouseLocation().x;
            this.initialMousePosition.y = startInput.getMouseLocation().y;
            if (this.handle instanceof ImageBasedManipulationHandle2D) {
                this.initialHandleColor = ((ImageBasedManipulationHandle2D)this.handle).getColor((int)this.initialMousePosition.x, (int)this.initialMousePosition.y);
            }
            this.initialMoveFactor = this.getMovementVectorForColor(this.initialHandleColor);
            this.initialRotateFactor = this.getRotationVectorForColor(this.initialHandleColor);
            return true;
        }
        return false;
    }

    protected abstract Vector3 getRotationVectorForColor(Color var1);

    protected abstract Vector3 getMovementVectorForColor(Color var1);

    protected abstract Vector3 getRelativeMovementAmount(Vector2 var1, double var2);

    protected abstract Vector3 getRelativeRotationAmount(Vector2 var1, double var2);

    protected abstract ReferenceFrame getRotationReferenceFrame();

    protected abstract ReferenceFrame getMovementReferenceFrame();

    protected Vector3 getTotalMovementAmount(Vector2 mousePos, double time) {
        Vector3 relativeMovementAmount = this.getRelativeMovementAmount(mousePos, time);
        Vector3 amountToMoveInitial = Vector3.createMultiplication((Tuple3)this.initialMoveFactor, 0.1 * time);
        Vector3 amountToMove = Vector3.createAddition(relativeMovementAmount, amountToMoveInitial);
        return amountToMove;
    }

    protected Vector3 getTotalRotationAmount(Vector2 mousePos, double time) {
        Vector3 relativeRotationAmount = this.getRelativeRotationAmount(mousePos, time);
        Vector3 amountToRotateInitial = Vector3.createMultiplication((Tuple3)this.initialRotateFactor, 0.02 * time);
        Vector3 amountToRotate = Vector3.createAddition(relativeRotationAmount, amountToRotateInitial);
        return amountToRotate;
    }

    public void doTimeUpdateManipulator(double time, InputState currentInput) {
        if (time < 0.001) {
            time = 0.001;
        } else if (time > 0.1) {
            time = 0.1;
        }
        Vector2 mousePos = new Vector2(currentInput.getMouseLocation().x, currentInput.getMouseLocation().y);
        Vector3 moveVector = this.getTotalMovementAmount(mousePos, time);
        Vector3 rotateVector = this.getTotalRotationAmount(mousePos, time);
        this.manipulatedTransformable.applyTranslation(moveVector, this.getMovementReferenceFrame());
        if (rotateVector.x != 0.0) {
            this.manipulatedTransformable.applyRotationAboutXAxis(new AngleInRadians(rotateVector.x), this.getRotationReferenceFrame());
        }
        if (rotateVector.y != 0.0) {
            this.manipulatedTransformable.applyRotationAboutYAxis(new AngleInRadians(rotateVector.y), this.getRotationReferenceFrame());
        }
        if (rotateVector.z != 0.0) {
            this.manipulatedTransformable.applyRotationAboutZAxis(new AngleInRadians(rotateVector.z), this.getRotationReferenceFrame());
        }
        for (ManipulationEvent event : this.manipulationEvents) {
            Vector3 dotVector = null;
            if (event.getType() == ManipulationEvent.EventType.Rotate) {
                dotVector = rotateVector;
            } else if (event.getType() == ManipulationEvent.EventType.Translate) {
                dotVector = moveVector;
            }
            if (dotVector == null) continue;
            Vector3 normalizedDotVector = new Vector3(dotVector);
            normalizedDotVector.normalize();
            double dot = Vector3.calculateDotProduct(event.getMovementDescription().direction.getVector(), normalizedDotVector);
            if (!Double.isNaN(dot) && dot > 0.0) {
                this.dragAdapter.triggerManipulationEvent(event, true);
                continue;
            }
            this.dragAdapter.triggerManipulationEvent(event, false);
        }
    }
}

