/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.manipulator;

import edu.cmu.cs.dennisc.math.Vector2;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.scenegraph.ReferenceFrame;
import java.awt.Color;
import org.alice.interact.MovementDirection;
import org.alice.interact.MovementType;
import org.alice.interact.condition.MovementDescription;
import org.alice.interact.event.ManipulationEvent;
import org.alice.interact.handle.ImageBasedManipulationHandle2D;
import org.alice.interact.manipulator.Camera2DDragManipulator;

public class CameraDragDriveManipulator
extends Camera2DDragManipulator {
    protected static final Color UP = Color.RED;
    protected static final Color LEFT = Color.GREEN;
    protected static final Color RIGHT = Color.BLUE;
    protected static final Color DOWN = Color.WHITE;

    public CameraDragDriveManipulator(ImageBasedManipulationHandle2D handle) {
        super(handle);
    }

    protected void initializeEventMessages() {
        this.manipulationEvents.clear();
        this.manipulationEvents.add(new ManipulationEvent(ManipulationEvent.EventType.Translate, new MovementDescription(MovementDirection.BACKWARD, MovementType.STOOD_UP), this.manipulatedTransformable));
        this.manipulationEvents.add(new ManipulationEvent(ManipulationEvent.EventType.Translate, new MovementDescription(MovementDirection.FORWARD, MovementType.STOOD_UP), this.manipulatedTransformable));
        this.manipulationEvents.add(new ManipulationEvent(ManipulationEvent.EventType.Rotate, new MovementDescription(MovementDirection.UP, MovementType.STOOD_UP), this.manipulatedTransformable));
        this.manipulationEvents.add(new ManipulationEvent(ManipulationEvent.EventType.Rotate, new MovementDescription(MovementDirection.DOWN, MovementType.STOOD_UP), this.manipulatedTransformable));
    }

    protected Vector3 getMovementVectorForColor(Color color) {
        Vector3 initialMove = new Vector3(0.0, 0.0, 0.0);
        if (color != null) {
            if (color.equals(UP)) {
                initialMove.z = -10.0;
            } else if (color.equals(DOWN)) {
                initialMove.z = 10.0;
            }
        }
        return initialMove;
    }

    protected Vector3 getRotationVectorForColor(Color color) {
        Vector3 initialRotate = new Vector3(0.0, 0.0, 0.0);
        if (color != null) {
            if (color.equals(LEFT)) {
                initialRotate.y = 8.0;
            } else if (color.equals(RIGHT)) {
                initialRotate.y = -8.0;
            }
        }
        return initialRotate;
    }

    protected Vector3 getRelativeMovementAmount(Vector2 mousePos, double time) {
        Vector2 relativeMousePos = Vector2.createSubtraction(mousePos, this.initialMousePosition);
        if (this.initialHandleColor != null && (this.initialHandleColor.equals(LEFT) || this.initialHandleColor.equals(RIGHT))) {
            relativeMousePos.y = Math.abs(relativeMousePos.y) < 10.0 ? 0.0 : (relativeMousePos.y < 0.0 ? (relativeMousePos.y += 10.0) : 10.0);
        }
        double amountToMoveZ = relativeMousePos.y * 0.1 * time;
        Vector3 amountToMoveMouse = new Vector3(0.0, 0.0, amountToMoveZ);
        return amountToMoveMouse;
    }

    protected Vector3 getRelativeRotationAmount(Vector2 mousePos, double time) {
        Vector2 relativeMousePos = Vector2.createSubtraction(mousePos, this.initialMousePosition);
        if (this.initialHandleColor != null && (this.initialHandleColor.equals(UP) || this.initialHandleColor.equals(DOWN))) {
            relativeMousePos.x = Math.abs(relativeMousePos.x) < 10.0 ? 0.0 : (relativeMousePos.x < 0.0 ? (relativeMousePos.x += 10.0) : (relativeMousePos.x -= 10.0));
        }
        double amountToRotateY = -relativeMousePos.x * 0.02 * time;
        Vector3 amountToRotateMouse = new Vector3(0.0, amountToRotateY, 0.0);
        return amountToRotateMouse;
    }

    protected ReferenceFrame getRotationReferenceFrame() {
        return this.standUpReference;
    }

    protected ReferenceFrame getMovementReferenceFrame() {
        return this.standUpReference;
    }
}

