/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.manipulator;

import edu.cmu.cs.dennisc.math.Vector2;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.scenegraph.ReferenceFrame;
import java.awt.Color;
import org.alice.interact.MovementDirection;
import org.alice.interact.MovementType;
import org.alice.interact.condition.MovementDescription;
import org.alice.interact.event.ManipulationEvent;
import org.alice.interact.handle.ImageBasedManipulationHandle2D;
import org.alice.interact.manipulator.Camera2DDragManipulator;

public class CameraDragUpDownRotateManipulator
extends Camera2DDragManipulator {
    protected static final Color FORWARD = Color.RED;
    protected static final Color BACKWARD = Color.GREEN;

    public CameraDragUpDownRotateManipulator(ImageBasedManipulationHandle2D handle) {
        super(handle);
    }

    protected void initializeEventMessages() {
        this.manipulationEvents.clear();
        this.manipulationEvents.add(new ManipulationEvent(ManipulationEvent.EventType.Rotate, new MovementDescription(MovementDirection.LEFT, MovementType.LOCAL), this.manipulatedTransformable));
        this.manipulationEvents.add(new ManipulationEvent(ManipulationEvent.EventType.Rotate, new MovementDescription(MovementDirection.RIGHT, MovementType.LOCAL), this.manipulatedTransformable));
    }

    protected Vector3 getRotationVectorForColor(Color color) {
        Vector3 initialRotate = new Vector3(0.0, 0.0, 0.0);
        if (color != null) {
            if (color.equals(FORWARD)) {
                initialRotate.x = -8.0;
            } else if (color.equals(BACKWARD)) {
                initialRotate.x = 8.0;
            }
        }
        return initialRotate;
    }

    protected Vector3 getMovementVectorForColor(Color color) {
        return new Vector3(0.0, 0.0, 0.0);
    }

    protected Vector3 getRelativeMovementAmount(Vector2 mousePos, double time) {
        return new Vector3(0.0, 0.0, 0.0);
    }

    protected Vector3 getRelativeRotationAmount(Vector2 mousePos, double time) {
        Vector2 relativeMousePos = Vector2.createSubtraction(mousePos, this.initialMousePosition);
        double amountToRotateX = relativeMousePos.y * 0.02 * time;
        Vector3 amountToRotateMouse = new Vector3(amountToRotateX, 0.0, 0.0);
        return amountToRotateMouse;
    }

    protected ReferenceFrame getRotationReferenceFrame() {
        return this.getManipulatedTransformable();
    }

    protected ReferenceFrame getMovementReferenceFrame() {
        return this.getManipulatedTransformable();
    }
}

