/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.manipulator;

import edu.cmu.cs.dennisc.lookingglass.OnscreenLookingGlass;
import edu.cmu.cs.dennisc.math.Angle;
import edu.cmu.cs.dennisc.math.AngleInRadians;
import edu.cmu.cs.dennisc.math.AngleUtilities;
import edu.cmu.cs.dennisc.math.Ray;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.scenegraph.AbstractCamera;
import java.awt.Point;
import org.alice.interact.InputState;
import org.alice.interact.MovementDirection;
import org.alice.interact.PlaneUtilities;
import org.alice.interact.handle.HandleSet;
import org.alice.interact.manipulator.AbstractManipulator;
import org.alice.interact.manipulator.CameraInformedManipulator;

public class HandlelessObjectRotateDragManipulator
extends AbstractManipulator
implements CameraInformedManipulator {
    protected static final double MOUSE_DISTANCE_TO_RADIANS_MULTIPLIER = 0.025;
    protected Vector3 rotateAxis;
    protected MovementDirection rotateAxisDirection;
    protected OnscreenLookingGlass onscreenLookingGlass = null;
    protected Point initialPoint;
    protected Vector3 absoluteRotationAxis;

    public AbstractCamera getCamera() {
        if (this.onscreenLookingGlass != null) {
            return this.onscreenLookingGlass.getCameraAt(0);
        }
        return null;
    }

    public String getUndoRedoDescription() {
        return "Object Rotate";
    }

    public void setOnscreenLookingGlass(OnscreenLookingGlass onscreenLookingGlass) {
        this.onscreenLookingGlass = onscreenLookingGlass;
    }

    public HandlelessObjectRotateDragManipulator(MovementDirection rotateAxisDirection) {
        this.rotateAxisDirection = rotateAxisDirection;
        this.rotateAxis = this.rotateAxisDirection.getVector();
    }

    protected Angle getRotationBasedOnMouse(Point mouseLocation) {
        Ray pickRay = PlaneUtilities.getRayFromPixel(this.onscreenLookingGlass, this.getCamera(), mouseLocation.x, mouseLocation.y);
        if (pickRay != null) {
            int xDif = mouseLocation.x - this.initialPoint.x;
            return new AngleInRadians((double)xDif * 0.025);
        }
        return null;
    }

    protected void initManipulator(InputState startInput) {
        this.absoluteRotationAxis = this.manipulatedTransformable.getAbsoluteTransformation().createTransformed(this.rotateAxis);
        this.initialPoint = new Point(startInput.getMouseLocation());
    }

    public boolean doStartManipulator(InputState startInput) {
        this.manipulatedTransformable = startInput.getClickPickTransformable();
        if (this.manipulatedTransformable != null) {
            this.initManipulator(startInput);
            return true;
        }
        return false;
    }

    public void doDataUpdateManipulator(InputState currentInput, InputState previousInput) {
        if (!currentInput.getMouseLocation().equals(previousInput.getMouseLocation())) {
            Angle currentAngle = this.getRotationBasedOnMouse(currentInput.getMouseLocation());
            Angle previousAngle = this.getRotationBasedOnMouse(previousInput.getMouseLocation());
            if (currentAngle != null && previousAngle != null) {
                Angle angleDif = AngleUtilities.createSubtraction(currentAngle, previousAngle);
                this.manipulatedTransformable.applyRotationAboutArbitraryAxis(this.rotateAxis, angleDif, this.manipulatedTransformable);
            }
        }
    }

    public void doEndManipulator(InputState endInput, InputState previousInput) {
    }

    public void doTimeUpdateManipulator(double time, InputState currentInput) {
    }

    protected HandleSet getHandleSetToEnable() {
        return new HandleSet(this.rotateAxisDirection.getHandleGroup(), HandleSet.HandleGroup.VISUALIZATION, HandleSet.HandleGroup.ROTATION);
    }
}

