/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.manipulator;

import edu.cmu.cs.dennisc.lookingglass.OnscreenLookingGlass;
import edu.cmu.cs.dennisc.math.Plane;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Ray;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.scenegraph.AbstractCamera;
import edu.cmu.cs.dennisc.scenegraph.AsSeenBy;
import edu.cmu.cs.dennisc.scenegraph.Component;
import edu.cmu.cs.dennisc.scenegraph.ReferenceFrame;
import java.awt.Point;
import org.alice.interact.InputState;
import org.alice.interact.MovementDirection;
import org.alice.interact.MovementType;
import org.alice.interact.PlaneUtilities;
import org.alice.interact.VectorUtilities;
import org.alice.interact.condition.MovementDescription;
import org.alice.interact.event.ManipulationEvent;
import org.alice.interact.handle.HandleSet;
import org.alice.interact.manipulator.AbstractManipulator;
import org.alice.interact.manipulator.CameraInformedManipulator;

public class OmniDirectionalDragManipulator
extends AbstractManipulator
implements CameraInformedManipulator {
    protected OnscreenLookingGlass onscreenLookingGlass = null;
    protected Plane pickPlane = new Plane(0.0, 1.0, 0.0, 0.0);
    protected Point3 offsetToOrigin = null;
    protected Boolean hasMoved = false;

    public AbstractCamera getCamera() {
        if (this.onscreenLookingGlass != null) {
            return this.onscreenLookingGlass.getCameraAt(0);
        }
        return null;
    }

    public String getUndoRedoDescription() {
        return "Object Move";
    }

    public void setOnscreenLookingGlass(OnscreenLookingGlass onscreenLookingGlass) {
        this.onscreenLookingGlass = onscreenLookingGlass;
    }

    protected void initializeEventMessages() {
        this.manipulationEvents.clear();
        this.manipulationEvents.add(new ManipulationEvent(ManipulationEvent.EventType.Translate, new MovementDescription(MovementDirection.LEFT, MovementType.ABSOLUTE), this.manipulatedTransformable));
        this.manipulationEvents.add(new ManipulationEvent(ManipulationEvent.EventType.Translate, new MovementDescription(MovementDirection.RIGHT, MovementType.ABSOLUTE), this.manipulatedTransformable));
        this.manipulationEvents.add(new ManipulationEvent(ManipulationEvent.EventType.Translate, new MovementDescription(MovementDirection.FORWARD, MovementType.ABSOLUTE), this.manipulatedTransformable));
        this.manipulationEvents.add(new ManipulationEvent(ManipulationEvent.EventType.Translate, new MovementDescription(MovementDirection.BACKWARD, MovementType.ABSOLUTE), this.manipulatedTransformable));
    }

    protected Plane createCameraPickPlane(Point3 clickPoint) {
        Vector3 clickPlaneNormal = this.getCamera().getAxes((ReferenceFrame)AsSeenBy.SCENE).backward;
        clickPlaneNormal.normalize();
        return new Plane(clickPoint, clickPlaneNormal);
    }

    protected Plane createLevelPickPlane(Point3 clickPoint) {
        Vector3 levelPlaneNormal = MovementDirection.UP.getVector();
        levelPlaneNormal.normalize();
        return new Plane(clickPoint, levelPlaneNormal);
    }

    private Vector3 getMouseMovementFromVector(Point mouseVector) {
        if (mouseVector.x == 0 && mouseVector.y == 0) {
            return new Vector3(0.0, 0.0, 0.0);
        }
        Vector3 mouseRelativeMovement = new Vector3(mouseVector.x, 0.0, mouseVector.y);
        this.getCamera().getRoot().transformFrom_AffectReturnValuePassedIn(mouseRelativeMovement, (Component)this.getCamera());
        mouseRelativeMovement.y = 0.0;
        mouseRelativeMovement.normalize();
        double MOVEMENT_SCALE = 0.02;
        double movementAmount = mouseVector.distance(0.0, 0.0) * MOVEMENT_SCALE;
        mouseRelativeMovement.multiply(movementAmount);
        if (mouseRelativeMovement.isNaN()) {
            System.out.println("NaN!");
        }
        return mouseRelativeMovement;
    }

    private Point3 getPickBasedVector(InputState currentInput, InputState previousInput) {
        boolean usePickForVertical = true;
        Ray pickRay = PlaneUtilities.getRayFromPixel(this.onscreenLookingGlass, this.getCamera(), currentInput.getMouseLocation().x, currentInput.getMouseLocation().y);
        if (pickRay == null) {
            return new Point3();
        }
        Vector3 upDownVector = new Vector3(this.getCamera().getAxes((ReferenceFrame)AsSeenBy.SCENE).backward);
        upDownVector.negate();
        upDownVector.y = 0.0;
        upDownVector.normalize();
        Point mouseMovement = new Point(0, currentInput.getMouseLocation().y - previousInput.getMouseLocation().y);
        Vector3 mouseVertical = this.getMouseMovementFromVector(mouseMovement);
        Point3 currentObjectOffsetPoint = Point3.createSubtraction(this.manipulatedTransformable.getAbsoluteTransformation().translation, this.offsetToOrigin);
        Plane cameraPickPlane = this.createCameraPickPlane(currentObjectOffsetPoint);
        Point3 cameraMovementVector = PlaneUtilities.getPointInPlane(cameraPickPlane, pickRay);
        cameraMovementVector.subtract(currentObjectOffsetPoint);
        cameraMovementVector.y = 0.0;
        Vector3 cameraMovementProjection = VectorUtilities.projectOntoVector(new Vector3(cameraMovementVector), upDownVector);
        double cameraMovementDotProd = Vector3.calculateDotProduct(cameraMovementProjection, mouseVertical);
        boolean cameraMovementIsValid = true;
        if (cameraMovementDotProd < 0.0) {
            cameraMovementIsValid = false;
        }
        Plane levelPickPlane = this.createLevelPickPlane(currentObjectOffsetPoint);
        Point3 levelMovementVector = PlaneUtilities.getPointInPlane(levelPickPlane, pickRay);
        boolean levelMovementIsValid = true;
        Vector3 levelMovementProjection = null;
        if (levelMovementVector != null) {
            levelMovementVector.subtract(currentObjectOffsetPoint);
            levelMovementVector.y = 0.0;
            levelMovementProjection = VectorUtilities.projectOntoVector(new Vector3(levelMovementVector), upDownVector);
            double levelMovementDotProd = Vector3.calculateDotProduct(levelMovementProjection, mouseVertical);
            if (levelMovementDotProd < 0.0) {
                levelMovementIsValid = false;
            }
        } else {
            levelMovementIsValid = false;
        }
        Point3 movementVector = new Point3(0.0, 0.0, 0.0);
        Vector3 movementProjection = new Vector3(0.0, 0.0, 0.0);
        if (cameraMovementIsValid && !levelMovementIsValid) {
            movementVector = cameraMovementVector;
            movementProjection = cameraMovementProjection;
        } else if (!cameraMovementIsValid && levelMovementIsValid) {
            movementVector = levelMovementVector;
            movementProjection = levelMovementProjection;
        } else if (cameraMovementIsValid && levelMovementIsValid) {
            double cameraMag = cameraMovementProjection.calculateMagnitude();
            double levelMag = levelMovementProjection.calculateMagnitude();
            if (levelMag > cameraMag && Math.abs(levelMag - cameraMag) < 1.0) {
                movementVector = levelMovementVector;
                movementProjection = levelMovementProjection;
            } else {
                movementVector = levelMovementVector;
                movementProjection = levelMovementProjection;
            }
        }
        double cameraAngleApproximation = Math.abs(this.getCamera().getAxes((ReferenceFrame)AsSeenBy.SCENE).backward.y);
        if (cameraAngleApproximation < 0.1) {
            usePickForVertical = false;
        }
        if (!usePickForVertical) {
            movementVector.subtract(movementProjection);
            movementVector.add(mouseVertical);
        }
        return movementVector;
    }

    public void doDataUpdateManipulator(InputState currentInput, InputState previousInput) {
        if (!currentInput.getMouseLocation().equals(previousInput.getMouseLocation()) && this.manipulatedTransformable != null) {
            if (!this.hasMoved.booleanValue()) {
                this.hasMoved = true;
            }
            Point3 movementVector = this.getPickBasedVector(currentInput, previousInput);
            Point3 currentPosition = this.manipulatedTransformable.getAbsoluteTransformation().translation;
            Point3 newPosition = Point3.createAddition(currentPosition, movementVector);
            Vector3 movementDif = Vector3.createSubtraction(newPosition, this.manipulatedTransformable.getAbsoluteTransformation().translation);
            movementDif.normalize();
            for (ManipulationEvent event : this.manipulationEvents) {
                double dot = Vector3.calculateDotProduct(event.getMovementDescription().direction.getVector(), movementDif);
                if (dot > 0.1) {
                    this.dragAdapter.triggerManipulationEvent(event, true);
                    continue;
                }
                if (!(dot < -0.07)) continue;
                this.dragAdapter.triggerManipulationEvent(event, false);
            }
            if (newPosition != null) {
                this.manipulatedTransformable.setTranslationOnly(newPosition, AsSeenBy.SCENE);
            }
        }
    }

    public void doEndManipulator(InputState endInput, InputState previousInput) {
    }

    public boolean doStartManipulator(InputState startInput) {
        this.manipulatedTransformable = startInput.getClickPickTransformable();
        if (this.manipulatedTransformable != null) {
            this.initializeEventMessages();
            this.hasMoved = false;
            Point3 initialClickPoint = new Point3();
            startInput.getClickPickResult().getPositionInSource(initialClickPoint);
            startInput.getClickPickResult().getSource().transformTo_AffectReturnValuePassedIn(initialClickPoint, (Component)startInput.getClickPickResult().getSource().getRoot());
            this.pickPlane = this.createCameraPickPlane(initialClickPoint);
            Ray pickRay = PlaneUtilities.getRayFromPixel(this.onscreenLookingGlass, this.getCamera(), startInput.getMouseLocation().x, startInput.getMouseLocation().y);
            if (pickRay != null) {
                this.offsetToOrigin = Point3.createSubtraction(this.manipulatedTransformable.getAbsoluteTransformation().translation, initialClickPoint);
            } else {
                this.manipulatedTransformable = null;
            }
            if (this.manipulatedTransformable != null) {
                return true;
            }
        }
        return false;
    }

    public void doTimeUpdateManipulator(double time, InputState currentInput) {
    }

    protected HandleSet getHandleSetToEnable() {
        return HandleSet.GROUND_TRANSLATION_VISUALIZATION;
    }
}

