/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.manipulator;

import edu.cmu.cs.dennisc.math.AngleInDegrees;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Vector3;
import java.util.Vector;
import org.alice.interact.InputState;
import org.alice.interact.MovementDirection;
import org.alice.interact.MovementKey;
import org.alice.interact.MovementType;
import org.alice.interact.handle.HandleSet;
import org.alice.interact.manipulator.AbstractManipulator;

public class RotateKeyManipulator
extends AbstractManipulator {
    protected static double TURN_RATE = 5.0;
    protected static double CLICK_TIME = 0.1;
    protected static double CLICK_MOVE_AMOUNT = 0.2;
    protected Point3 initialPoint = new Point3();
    protected double startTime = 0.0;
    MovementKey[] rotationKeys;
    Vector<MovementDirection> rotateAxes = new Vector();

    public RotateKeyManipulator() {
        this.setKeys(new MovementKey[0]);
    }

    public RotateKeyManipulator(MovementKey[] directionKeys) {
        this.setKeys(directionKeys);
    }

    public String getUndoRedoDescription() {
        return "Object Rotate";
    }

    public void setKeys(MovementKey[] directionKeys) {
        this.rotationKeys = directionKeys;
        for (MovementKey direction : directionKeys) {
            if (this.rotateAxes.contains((Object)direction.movementDescription.direction)) continue;
            this.rotateAxes.add(direction.movementDescription.direction);
        }
    }

    protected double[][] getRotateAmount(InputState input) {
        int i;
        MovementType[] movementTypes = MovementType.values();
        double[][] rotateDirs = new double[this.rotateAxes.size()][movementTypes.length];
        for (i = 0; i < rotateDirs.length; ++i) {
            for (int j = 0; j < rotateDirs[i].length; ++j) {
                rotateDirs[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.rotationKeys.length; ++i) {
            if (!input.isKeyDown(this.rotationKeys[i].keyValue)) continue;
            int typeIndex = this.rotationKeys[i].movementDescription.type.getIndex();
            int axisIndex = this.rotateAxes.indexOf((Object)this.rotationKeys[i].movementDescription.direction);
            double[] dArray = rotateDirs[axisIndex];
            int n = typeIndex;
            dArray[n] = dArray[n] + this.rotationKeys[i].directionMultiplier;
        }
        return rotateDirs;
    }

    private void rotateTransformable(double[][] rotateAmounts) {
        for (int axisIndex = 0; axisIndex < rotateAmounts.length; ++axisIndex) {
            for (int typeIndex = 0; typeIndex < rotateAmounts[axisIndex].length; ++typeIndex) {
                if (rotateAmounts[axisIndex][typeIndex] == 0.0) continue;
                Vector3 rotateAxis = this.rotateAxes.get(axisIndex).getVector();
                AngleInDegrees rotateAngle = new AngleInDegrees(rotateAmounts[axisIndex][typeIndex]);
                MovementType movementType = MovementType.getMovementTypeForIndex(typeIndex);
                if (movementType == null) continue;
                movementType.applyRotation(this.manipulatedTransformable, rotateAxis, rotateAngle);
            }
        }
    }

    public void doEndManipulator(InputState endInput, InputState previousInput) {
        double currentTime = (double)System.currentTimeMillis() * 0.001;
        if (currentTime - this.startTime < CLICK_TIME) {
            double amountToRotate = CLICK_TIME * TURN_RATE;
            double[][] rotateAmounts = this.getRotateAmount(previousInput);
            for (int i = 0; i < rotateAmounts.length; ++i) {
                int j = 0;
                while (j < rotateAmounts[i].length) {
                    double[] dArray = rotateAmounts[i];
                    int n = j++;
                    dArray[n] = dArray[n] * amountToRotate;
                }
            }
            this.manipulatedTransformable.setTranslationOnly(this.initialPoint, this.manipulatedTransformable.getRoot());
            this.rotateTransformable(rotateAmounts);
        }
    }

    public boolean doStartManipulator(InputState startInput) {
        if (this.manipulatedTransformable != null) {
            this.startTime = (double)System.currentTimeMillis() * 0.001;
            this.initialPoint.set(this.manipulatedTransformable.getAbsoluteTransformation().translation);
            return true;
        }
        return false;
    }

    public void doDataUpdateManipulator(InputState currentInput, InputState previousInput) {
    }

    public void doTimeUpdateManipulator(double dTime, InputState currentInput) {
        if (this.manipulatedTransformable != null) {
            double[][] rotateAmounts = this.getRotateAmount(currentInput);
            for (int i = 0; i < rotateAmounts.length; ++i) {
                int j = 0;
                while (j < rotateAmounts[i].length) {
                    double[] dArray = rotateAmounts[i];
                    int n = j++;
                    dArray[n] = dArray[n] * (TURN_RATE * dTime);
                }
            }
            this.rotateTransformable(rotateAmounts);
        }
    }

    protected HandleSet getHandleSetToEnable() {
        return null;
    }
}

