/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.manipulator;

import edu.cmu.cs.dennisc.alice.Project;
import edu.cmu.cs.dennisc.animation.Animator;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.pattern.Criterion;
import edu.cmu.cs.dennisc.scenegraph.Component;
import edu.cmu.cs.dennisc.scenegraph.scale.ScaleUtilities;
import edu.cmu.cs.dennisc.zoot.ZManager;
import org.alice.interact.PickHint;
import org.alice.interact.handle.HandleSet;
import org.alice.interact.handle.LinearScaleHandle;
import org.alice.interact.manipulator.LinearDragManipulator;
import org.alice.interact.operations.PredeterminedScaleActionOperation;

public class ScaleDragManipulator
extends LinearDragManipulator {
    private static final double MIN_HANDLE_PULL = 0.1;
    private Vector3 accumulatedScaleVector = new Vector3(1.0, 1.0, 1.0);
    private Criterion<Component> handleCriterion = new Criterion<Component>(){

        protected boolean isHandle(Component c) {
            if (c == null) {
                return false;
            }
            Object bonusData = c.getBonusDataFor("PICK_HINT_KEY");
            if (bonusData instanceof PickHint && ((PickHint)bonusData).intersects(PickHint.HANDLES)) {
                return true;
            }
            return this.isHandle(c.getParent());
        }

        @Override
        public boolean accept(Component c) {
            return !this.isHandle(c);
        }
    };

    protected void updateBasedOnHandlePull(double previousPull, double newPull) {
        Vector3 scaleVector;
        double pullDif = newPull / previousPull;
        LinearScaleHandle scaleHandle = (LinearScaleHandle)this.linearHandle;
        if (scaleHandle.applyAlongAxis()) {
            scaleVector = new Vector3(1.0, 1.0, 1.0);
            if (scaleHandle.getDragAxis().x != 0.0) {
                scaleVector.x = Math.abs(scaleHandle.getDragAxis().x) * pullDif;
            }
            if (scaleHandle.getDragAxis().y != 0.0) {
                scaleVector.y = Math.abs(scaleHandle.getDragAxis().y) * pullDif;
            }
            if (scaleHandle.getDragAxis().z != 0.0) {
                scaleVector.z = Math.abs(scaleHandle.getDragAxis().z) * pullDif;
            }
        } else {
            scaleVector = new Vector3(pullDif, pullDif, pullDif);
        }
        if (previousPull <= 0.1 || newPull <= 0.1) {
            scaleVector = new Vector3(1.0, 1.0, 1.0);
        }
        this.accumulatedScaleVector.multiply(scaleVector);
        ScaleUtilities.applyScale(this.manipulatedTransformable, scaleVector, this.handleCriterion);
    }

    public void undoRedoBeginManipulation() {
        this.accumulatedScaleVector = new Vector3(1.0, 1.0, 1.0);
    }

    public void undoRedoEndManipulation() {
        if (this.getManipulatedTransformable() != null) {
            Animator animator = this.dragAdapter != null ? this.dragAdapter.getAnimator() : null;
            PredeterminedScaleActionOperation undoOperation = new PredeterminedScaleActionOperation(Project.GROUP_UUID, false, animator, this.getManipulatedTransformable(), this.accumulatedScaleVector, this.handleCriterion, this.getUndoRedoDescription());
            ZManager.performIfAppropriate(undoOperation, null, false);
        }
    }

    public String getUndoRedoDescription() {
        return "Object Resize";
    }

    protected HandleSet getHandleSetToEnable() {
        return new HandleSet(this.linearHandle.getMovementDescription().direction.getHandleGroup(), HandleSet.HandleGroup.VISUALIZATION, HandleSet.HandleGroup.RESIZE);
    }
}

