/*
 * Decompiled with CFR 0.152.
 */
package org.alice.virtualmachine.resources;

import edu.cmu.cs.dennisc.io.FileUtilities;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.alice.virtualmachine.Resource;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioResource
extends Resource {
    private static Map<String, String> extensionToContentTypeMap = new HashMap<String, String>();
    private static Map<UUID, AudioResource> uuidToResourceMap;
    private double duration = Double.NaN;
    private static String XML_DURATION_ATTRIBUTE;

    public static String getContentType(String path) {
        String extension = FileUtilities.getExtension(path);
        String contentType = extensionToContentTypeMap.get(extension.toLowerCase());
        return contentType;
    }

    public static String getContentType(File file) {
        return AudioResource.getContentType(file.getName());
    }

    public static boolean isAcceptableContentType(String contentType) {
        return extensionToContentTypeMap.containsValue(contentType);
    }

    public static FilenameFilter createFilenameFilter(final boolean areDirectoriesAccepted) {
        return new FilenameFilter(){

            public boolean accept(File dir, String name) {
                File file = new File(dir, name);
                if (file.isDirectory()) {
                    return areDirectoriesAccepted;
                }
                return AudioResource.getContentType(name) != null;
            }
        };
    }

    private static AudioResource get(UUID uuid) {
        AudioResource rv = uuidToResourceMap.get(uuid);
        if (rv == null) {
            rv = new AudioResource(uuid);
            uuidToResourceMap.put(uuid, rv);
        }
        return rv;
    }

    public static AudioResource valueOf(String s) {
        return AudioResource.get(UUID.fromString(s));
    }

    public AudioResource(UUID uuid) {
        super(uuid);
    }

    public AudioResource(Class<?> cls, String resourceName, String contentType) {
        super(cls, resourceName, contentType);
    }

    public AudioResource(Class<?> cls, String resourceName) {
        this(cls, resourceName, AudioResource.getContentType(resourceName));
    }

    public AudioResource(File file, String contentType) throws IOException {
        super(file, contentType);
    }

    public AudioResource(File file) throws IOException {
        this(file, AudioResource.getContentType(file));
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    @Override
    public void encodeAttributes(Element xmlElement) {
        super.encodeAttributes(xmlElement);
        xmlElement.setAttribute(XML_DURATION_ATTRIBUTE, Double.toString(this.duration));
    }

    @Override
    public void decodeAttributes(Element xmlElement, byte[] data) {
        super.decodeAttributes(xmlElement, data);
        this.duration = Double.parseDouble(xmlElement.getAttribute(XML_DURATION_ATTRIBUTE));
    }

    static {
        extensionToContentTypeMap.put("au", "audio.basic");
        extensionToContentTypeMap.put("wav", "audio.x_wav");
        extensionToContentTypeMap.put("mp3", "audio.mpeg");
        uuidToResourceMap = new HashMap<UUID, AudioResource>();
        XML_DURATION_ATTRIBUTE = "duration";
    }
}

