/*
 * Decompiled with CFR 0.152.
 */
package org.alice.apis.moveandturn;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.random.RandomUtilities;

public abstract class AbstractBoundedValue
extends Number
implements BinaryEncodableAndDecodable {
    private double m_value;

    protected abstract Double getMinimum();

    protected abstract Double getMaximum();

    public AbstractBoundedValue() {
        this.m_value = Double.NaN;
    }

    public AbstractBoundedValue(Number value) {
        this.m_value = value.doubleValue();
    }

    public AbstractBoundedValue(AbstractBoundedValue other) {
        this.set(other);
    }

    public void decode(BinaryDecoder binaryDecoder) {
        this.m_value = binaryDecoder.decodeDouble();
    }

    public void encode(BinaryEncoder binaryEncoder) {
        binaryEncoder.encode(this.m_value);
    }

    public double doubleValue() {
        return this.m_value;
    }

    public float floatValue() {
        return (float)this.m_value;
    }

    public int intValue() {
        return (int)this.m_value;
    }

    public long longValue() {
        return (long)this.m_value;
    }

    protected void set(AbstractBoundedValue other) {
        this.m_value = other != null ? other.m_value : Double.NaN;
    }

    public Double getValue() {
        return this.m_value;
    }

    public void setValue(Number value) {
        assert (value.doubleValue() >= this.getMinimum());
        assert (value.doubleValue() <= this.getMaximum());
        this.m_value = value.doubleValue();
    }

    public static AbstractBoundedValue setReturnValueToRandom(AbstractBoundedValue rv) {
        rv.m_value = RandomUtilities.nextDoubleInRange((Number)rv.getMinimum(), (Number)rv.getMaximum());
        return rv;
    }

    public void setRandom() {
        AbstractBoundedValue.setReturnValueToRandom(this);
    }
}

