/*
 * Decompiled with CFR 0.152.
 */
package org.alice.apis.moveandturn;

import edu.cmu.cs.dennisc.alice.annotations.ClassTemplate;
import edu.cmu.cs.dennisc.alice.annotations.MethodTemplate;
import edu.cmu.cs.dennisc.alice.annotations.Visibility;
import edu.cmu.cs.dennisc.lookingglass.LookingGlass;
import edu.cmu.cs.dennisc.lookingglass.OnscreenLookingGlass;
import edu.cmu.cs.dennisc.lookingglass.util.TransformationUtilities;
import edu.cmu.cs.dennisc.math.Matrix4x4;
import edu.cmu.cs.dennisc.math.Vector4;
import edu.cmu.cs.dennisc.scenegraph.Layer;
import java.awt.Point;
import org.alice.apis.moveandturn.Composite;
import org.alice.apis.moveandturn.SceneOwner;
import org.alice.apis.moveandturn.Transformable;

@ClassTemplate(isFollowToSuperClassDesired=true, isConsumptionBySubClassDesired=true)
public abstract class AbstractCamera
extends Transformable {
    private LookingGlass m_lookingGlass = null;

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public abstract edu.cmu.cs.dennisc.scenegraph.AbstractCamera getSGCamera();

    private void setLookingGlass(LookingGlass lookingGlass) {
        if (this.m_lookingGlass != lookingGlass) {
            if (this.m_lookingGlass != null) {
                this.m_lookingGlass.removeCamera(this.getSGCamera());
            }
            this.m_lookingGlass = lookingGlass;
            if (lookingGlass != null) {
                this.m_lookingGlass.addCamera(this.getSGCamera());
            }
        }
    }

    protected void handleOwnerChange(SceneOwner owner) {
        super.handleOwnerChange(owner);
        OnscreenLookingGlass lookingGlass = owner != null ? owner.getOnscreenLookingGlass() : null;
        this.setLookingGlass((LookingGlass)lookingGlass);
    }

    protected void handleVehicleChange(Composite vehicle) {
        super.handleVehicleChange(vehicle);
        LookingGlass lookingGlass = vehicle != null ? vehicle.getLookingGlass() : null;
        this.setLookingGlass(lookingGlass);
    }

    Point transformToAWT(Vector4 xyzw, LookingGlass lookingGlass) {
        return TransformationUtilities.transformFromCameraToAWT_New((Vector4)xyzw, (LookingGlass)lookingGlass, (edu.cmu.cs.dennisc.scenegraph.AbstractCamera)this.getSGCamera());
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public Matrix4x4 getActualProjectionMatrix() {
        LookingGlass lg = this.getLookingGlass();
        assert (lg != null);
        return lg.getActualProjectionMatrix(this.getSGCamera());
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public Layer getPostRenderLayer() {
        edu.cmu.cs.dennisc.scenegraph.AbstractCamera sgCamera = this.getSGCamera();
        if (sgCamera.postRenderLayers.getLength() == 0) {
            Layer[] layers = new Layer[]{new Layer()};
            sgCamera.postRenderLayers.setValue((Object)layers);
        }
        return ((Layer[])sgCamera.postRenderLayers.getValue())[0];
    }
}

