/*
 * Decompiled with CFR 0.152.
 */
package org.alice.apis.moveandturn;

import edu.cmu.cs.dennisc.alice.annotations.ClassTemplate;
import edu.cmu.cs.dennisc.alice.annotations.MethodTemplate;
import edu.cmu.cs.dennisc.alice.annotations.ParameterTemplate;
import edu.cmu.cs.dennisc.alice.annotations.PropertyGetterTemplate;
import edu.cmu.cs.dennisc.alice.annotations.Visibility;
import edu.cmu.cs.dennisc.animation.Animation;
import edu.cmu.cs.dennisc.animation.DurationBasedAnimation;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.AngleUtilities;
import edu.cmu.cs.dennisc.math.EpsilonUtilities;
import edu.cmu.cs.dennisc.math.ForwardAndUpGuide;
import edu.cmu.cs.dennisc.math.Orientation;
import edu.cmu.cs.dennisc.math.OrthogonalMatrix3x3;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.math.UnitQuaternion;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.math.animation.AffineMatrix4x4Animation;
import edu.cmu.cs.dennisc.math.animation.Point3Animation;
import edu.cmu.cs.dennisc.math.animation.UnitQuaternionAnimation;
import edu.cmu.cs.dennisc.property.GetterSetterProperty;
import edu.cmu.cs.dennisc.scenegraph.util.ExtravagantAxes;
import org.alice.apis.moveandturn.AngleInRadians;
import org.alice.apis.moveandturn.AngleInRevolutions;
import org.alice.apis.moveandturn.AsSeenBy;
import org.alice.apis.moveandturn.Composite;
import org.alice.apis.moveandturn.MoveDirection;
import org.alice.apis.moveandturn.PointOfView;
import org.alice.apis.moveandturn.ReferenceFrame;
import org.alice.apis.moveandturn.RollDirection;
import org.alice.apis.moveandturn.Scene;
import org.alice.apis.moveandturn.SceneOwner;
import org.alice.apis.moveandturn.StandIn;
import org.alice.apis.moveandturn.Style;
import org.alice.apis.moveandturn.Transformable;
import org.alice.apis.moveandturn.TurnDirection;

@ClassTemplate(isFollowToSuperClassDesired=true, isConsumptionBySubClassDesired=true)
public abstract class AbstractTransformable
extends Composite {
    public static final GetterSetterProperty<PointOfView> LOCAL_POINT_OF_VIEW_PROPERTY = new GetterSetterProperty(Transformable.class, "LocalPointOfView");
    private ExtravagantAxes m_sgAxes = null;

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public edu.cmu.cs.dennisc.scenegraph.Composite getSGComposite() {
        return this.getSGAbstractTransformable();
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public abstract edu.cmu.cs.dennisc.scenegraph.AbstractTransformable getSGAbstractTransformable();

    @PropertyGetterTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public AffineMatrix4x4 getLocalTransformation() {
        return this.getSGAbstractTransformable().getLocalTransformation();
    }

    public void setLocalTransformation(AffineMatrix4x4 transformation) {
        this.getSGAbstractTransformable().setLocalTransformation(transformation);
    }

    @PropertyGetterTemplate(visibility=Visibility.TUCKED_AWAY)
    public PointOfView getLocalPointOfView() {
        return new PointOfView(this.getLocalTransformation());
    }

    public void setLocalPointOfView(PointOfView pointOfView) {
        this.setLocalTransformation(pointOfView.getInternal());
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public AffineMatrix4x4 getTransformation(AffineMatrix4x4 rv, ReferenceFrame asSeenBy) {
        assert (asSeenBy != null);
        return this.getSGAbstractTransformable().getTransformation(rv, asSeenBy.getSGReferenceFrame());
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public AffineMatrix4x4 getTransformation(ReferenceFrame asSeenBy) {
        return this.getTransformation(new AffineMatrix4x4(), asSeenBy);
    }

    public abstract Composite getVehicle();

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Scene getScene() {
        if (this.getVehicle() != null) {
            return this.getVehicle().getScene();
        }
        return null;
    }

    @MethodTemplate(visibility=Visibility.TUCKED_AWAY)
    public SceneOwner getOwner() {
        Scene scene = this.getScene();
        if (scene != null) {
            return scene.getOwner();
        }
        return null;
    }

    protected StandIn acquireStandIn(ReferenceFrame referenceFrame) {
        Composite composite;
        if (referenceFrame instanceof Composite) {
            composite = (Composite)referenceFrame;
        } else if (referenceFrame == AsSeenBy.SCENE) {
            composite = this.getScene();
        } else if (referenceFrame == AsSeenBy.PARENT) {
            composite = this.getVehicle();
        } else if (referenceFrame == AsSeenBy.SELF) {
            composite = this;
        } else {
            throw new RuntimeException();
        }
        return Composite.acquireStandIn(composite);
    }

    protected StandIn acquireStandIn(ReferenceFrame referenceFrame, Point3 offset) {
        StandIn rv = this.acquireStandIn(referenceFrame);
        assert (offset != null);
        rv.getSGAbstractTransformable().setTranslationOnly((Tuple3)offset, (edu.cmu.cs.dennisc.scenegraph.ReferenceFrame)edu.cmu.cs.dennisc.scenegraph.AsSeenBy.PARENT);
        return rv;
    }

    protected StandIn acquireStandIn(ReferenceFrame referenceFrame, Orientation offset) {
        StandIn rv = this.acquireStandIn(referenceFrame);
        assert (offset != null);
        rv.getSGAbstractTransformable().setAxesOnly(offset, (edu.cmu.cs.dennisc.scenegraph.ReferenceFrame)edu.cmu.cs.dennisc.scenegraph.AsSeenBy.PARENT);
        return rv;
    }

    protected StandIn acquireStandIn(ReferenceFrame referenceFrame, AffineMatrix4x4 offset) {
        StandIn rv = this.acquireStandIn(referenceFrame);
        assert (offset != null);
        rv.getSGAbstractTransformable().setLocalTransformation(offset);
        return rv;
    }

    private void applyTranslation(double x, double y, double z, edu.cmu.cs.dennisc.scenegraph.ReferenceFrame sgAsSeenBy) {
        this.getSGAbstractTransformable().applyTranslation(x, y, z, sgAsSeenBy);
    }

    protected void applyTranslation(double x, double y, double z, Number duration, ReferenceFrame asSeenBy, Style style) {
        assert (!Double.isNaN(x));
        assert (!Double.isNaN(y));
        assert (!Double.isNaN(z));
        assert (duration.doubleValue() >= 0.0) : "Invalid argument: duration " + duration + " must be >= 0";
        assert (style != null);
        assert (asSeenBy != null);
        if (EpsilonUtilities.isWithinReasonableEpsilon((Number)(duration = Double.valueOf(this.adjustDurationIfNecessary(duration))), (double)RIGHT_NOW)) {
            this.applyTranslation(x, y, z, asSeenBy.getSGReferenceFrame());
        } else {
            class TranslateAnimation
            extends DurationBasedAnimation {
                private edu.cmu.cs.dennisc.scenegraph.ReferenceFrame m_sgAsSeenBy;
                private double m_x;
                private double m_y;
                private double m_z;
                private double m_xSum;
                private double m_ySum;
                private double m_zSum;

                public TranslateAnimation(Number duration, Style style, double x, double y, double z, edu.cmu.cs.dennisc.scenegraph.ReferenceFrame sgAsSeenBy) {
                    super(duration, (edu.cmu.cs.dennisc.animation.Style)style);
                    this.m_x = x;
                    this.m_y = y;
                    this.m_z = z;
                    this.m_sgAsSeenBy = sgAsSeenBy;
                }

                protected void prologue() {
                    this.m_xSum = 0.0;
                    this.m_ySum = 0.0;
                    this.m_zSum = 0.0;
                }

                protected void setPortion(double portion) {
                    double xPortion = this.m_x * portion - this.m_xSum;
                    double yPortion = this.m_y * portion - this.m_ySum;
                    double zPortion = this.m_z * portion - this.m_zSum;
                    AbstractTransformable.this.applyTranslation(xPortion, yPortion, zPortion, this.m_sgAsSeenBy);
                    this.m_xSum += xPortion;
                    this.m_ySum += yPortion;
                    this.m_zSum += zPortion;
                }

                protected void epilogue() {
                    AbstractTransformable.this.applyTranslation(this.m_x - this.m_xSum, this.m_y - this.m_ySum, this.m_z - this.m_zSum, this.m_sgAsSeenBy);
                }
            }
            this.perform((Animation)new TranslateAnimation(duration, style, x, y, z, asSeenBy.getSGReferenceFrame()));
        }
    }

    private void applyRotationInRadians(Vector3 axis, double angleInRadians, edu.cmu.cs.dennisc.scenegraph.ReferenceFrame sgAsSeenBy) {
        this.getSGAbstractTransformable().applyRotationAboutArbitraryAxisInRadians(axis, angleInRadians, sgAsSeenBy);
    }

    protected void applyRotationInRadians(Vector3 axis, double angleInRadians, Number duration, ReferenceFrame asSeenBy, Style style) {
        assert (axis != null);
        assert (duration.doubleValue() >= 0.0) : "Invalid argument: duration " + duration + " must be >= 0";
        if (EpsilonUtilities.isWithinReasonableEpsilon((Number)(duration = Double.valueOf(this.adjustDurationIfNecessary(duration))), (double)RIGHT_NOW)) {
            this.applyRotationInRadians(axis, angleInRadians, asSeenBy.getSGReferenceFrame());
        } else {
            class RotateAnimation
            extends DurationBasedAnimation {
                private edu.cmu.cs.dennisc.scenegraph.ReferenceFrame m_sgAsSeenBy;
                private Vector3 m_axis;
                private double m_angleInRadians;
                private double m_angleSumInRadians;

                public RotateAnimation(Number duration, Style style, Vector3 axis, double angleInRadians, edu.cmu.cs.dennisc.scenegraph.ReferenceFrame sgAsSeenBy) {
                    super(duration, (edu.cmu.cs.dennisc.animation.Style)style);
                    this.m_axis = axis;
                    this.m_angleInRadians = angleInRadians;
                    this.m_sgAsSeenBy = sgAsSeenBy;
                }

                protected void prologue() {
                    this.m_angleSumInRadians = 0.0;
                }

                protected void setPortion(double portion) {
                    double anglePortionInRadians = this.m_angleInRadians * portion - this.m_angleSumInRadians;
                    AbstractTransformable.this.applyRotationInRadians(this.m_axis, anglePortionInRadians, this.m_sgAsSeenBy);
                    this.m_angleSumInRadians += anglePortionInRadians;
                }

                protected void epilogue() {
                    AbstractTransformable.this.applyRotationInRadians(this.m_axis, this.m_angleInRadians - this.m_angleSumInRadians, this.m_sgAsSeenBy);
                }
            }
            this.perform((Animation)new RotateAnimation(duration, style, axis, angleInRadians, asSeenBy.getSGReferenceFrame()));
        }
    }

    private void setTranslationOnly(Point3 t, edu.cmu.cs.dennisc.scenegraph.ReferenceFrame sgReferenceFrame) {
        this.getSGAbstractTransformable().setTranslationOnly((Tuple3)t, sgReferenceFrame);
    }

    protected void setTranslationOnly(ReferenceFrame target, Number duration, Style style) {
        edu.cmu.cs.dennisc.scenegraph.AsSeenBy sgReferenceFrame = edu.cmu.cs.dennisc.scenegraph.AsSeenBy.SCENE;
        AffineMatrix4x4 m1 = target.getSGReferenceFrame().getAbsoluteTransformation();
        if (EpsilonUtilities.isWithinReasonableEpsilon((Number)(duration = Double.valueOf(this.adjustDurationIfNecessary(duration))), (double)RIGHT_NOW)) {
            this.setTranslationOnly(m1.translation, (edu.cmu.cs.dennisc.scenegraph.ReferenceFrame)sgReferenceFrame);
        } else {
            AffineMatrix4x4 m0 = this.getSGAbstractTransformable().getAbsoluteTransformation();
            this.perform((Animation)new Point3Animation(this.adjustDurationIfNecessary(duration), style, m0.translation, m1.translation, (edu.cmu.cs.dennisc.scenegraph.ReferenceFrame)sgReferenceFrame){
                final /* synthetic */ edu.cmu.cs.dennisc.scenegraph.ReferenceFrame val$sgReferenceFrame;
                {
                    this.val$sgReferenceFrame = referenceFrame;
                    super(x0, x1, x2, x3);
                }

                protected void updateValue(Point3 t) {
                    AbstractTransformable.this.setTranslationOnly(t, this.val$sgReferenceFrame);
                }
            });
        }
    }

    private void setAxesOnly(OrthogonalMatrix3x3 orientation, edu.cmu.cs.dennisc.scenegraph.ReferenceFrame sgAsSeenBy) {
        this.getSGAbstractTransformable().setAxesOnly((Orientation)orientation, sgAsSeenBy);
    }

    protected void setAxesOnly(OrthogonalMatrix3x3 axes, Number duration, Style style) {
        edu.cmu.cs.dennisc.scenegraph.AsSeenBy sgReferenceFrame = edu.cmu.cs.dennisc.scenegraph.AsSeenBy.SCENE;
        if (EpsilonUtilities.isWithinReasonableEpsilon((Number)(duration = Double.valueOf(this.adjustDurationIfNecessary(duration))), (double)RIGHT_NOW)) {
            if (!axes.isNaN()) {
                this.setAxesOnly(axes, (edu.cmu.cs.dennisc.scenegraph.ReferenceFrame)sgReferenceFrame);
            }
        } else if (axes.isNaN()) {
            this.alreadyAdjustedDelay(duration);
        } else {
            AffineMatrix4x4 m0 = this.getSGAbstractTransformable().getAbsoluteTransformation();
            this.perform((Animation)new SetAxesOnlyAnimation(duration, style, m0.orientation.createUnitQuaternion(), axes.createUnitQuaternion(), (edu.cmu.cs.dennisc.scenegraph.ReferenceFrame)sgReferenceFrame));
        }
    }

    protected void setAxesOnly(ReferenceFrame target, Number duration, Style style) {
        this.setAxesOnly(target.getSGReferenceFrame().getAbsoluteTransformation().orientation, duration, style);
    }

    protected void setAxesOnlyToUpright(Number duration, ReferenceFrame asSeenBy, Style style) {
        edu.cmu.cs.dennisc.scenegraph.ReferenceFrame sgReferenceFrame = asSeenBy.getSGReferenceFrame();
        OrthogonalMatrix3x3 axes0 = this.getSGAbstractTransformable().getAxes(sgReferenceFrame);
        OrthogonalMatrix3x3 axes1 = OrthogonalMatrix3x3.createFromStandUp((OrthogonalMatrix3x3)axes0);
        if (EpsilonUtilities.isWithinReasonableEpsilon((Number)(duration = Double.valueOf(this.adjustDurationIfNecessary(duration))), (double)RIGHT_NOW)) {
            this.setAxesOnly(axes1, sgReferenceFrame);
        } else {
            this.perform((Animation)new SetAxesOnlyAnimation(duration, style, axes0.createUnitQuaternion(), axes1.createUnitQuaternion(), sgReferenceFrame));
        }
    }

    protected OrthogonalMatrix3x3 calculatePointAtAxes(OrthogonalMatrix3x3 rv, ReferenceFrame target) {
        Point3 t0 = this.getTransformation((ReferenceFrame)AsSeenBy.SCENE).translation;
        Point3 t1 = target.getTransformation((ReferenceFrame)AsSeenBy.SCENE).translation;
        Vector3 forward = Vector3.createSubtraction((Tuple3)t1, (Tuple3)t0);
        ForwardAndUpGuide fowardAndUpGuide = new ForwardAndUpGuide(forward, null);
        rv.setValue(fowardAndUpGuide);
        return rv;
    }

    protected final OrthogonalMatrix3x3 calculatePointAtAxes(ReferenceFrame target) {
        return this.calculatePointAtAxes(OrthogonalMatrix3x3.createNaN(), target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OrthogonalMatrix3x3 calculateTurnToFaceAxes(OrthogonalMatrix3x3 rv, ReferenceFrame target) {
        Scene asSeenBy = this.getScene();
        StandIn standInA = AbstractTransformable.acquireStandIn(asSeenBy);
        try {
            OrthogonalMatrix3x3 orthogonalMatrix3x3;
            standInA.moveTo(this, RIGHT_NOW);
            Point3 targetPos = target.getTransformation((ReferenceFrame)standInA).translation;
            double targetTheta = Math.atan2(targetPos.z, targetPos.x);
            StandIn standInB = AbstractTransformable.acquireStandIn(this);
            try {
                standInB.move(MoveDirection.FORWARD, 1.0, RIGHT_NOW);
                Point3 forwardPos = standInB.getTransformation((ReferenceFrame)standInA).translation;
                double forwardTheta = Math.atan2(forwardPos.z, forwardPos.x);
                standInB.setLocalTransformation(AffineMatrix4x4.accessIdentity());
                standInB.turn(TurnDirection.RIGHT, new AngleInRadians(targetTheta - forwardTheta), RIGHT_NOW, standInA);
                rv.setValue(standInB.getTransformation((ReferenceFrame)asSeenBy).orientation);
                orthogonalMatrix3x3 = rv;
            }
            catch (Throwable throwable) {
                AbstractTransformable.releaseStandIn(standInB);
                throw throwable;
            }
            AbstractTransformable.releaseStandIn(standInB);
            return orthogonalMatrix3x3;
        }
        finally {
            AbstractTransformable.releaseStandIn(standInA);
        }
    }

    protected OrthogonalMatrix3x3 calculateTurnToFaceAxes(ReferenceFrame target) {
        return this.calculateTurnToFaceAxes(OrthogonalMatrix3x3.createNaN(), target);
    }

    private void setPointOfView(AffineMatrix4x4 pointOfView, edu.cmu.cs.dennisc.scenegraph.ReferenceFrame sgReferenceFrame) {
        this.getSGAbstractTransformable().setTransformation(pointOfView, sgReferenceFrame);
    }

    protected void setPointOfView(AffineMatrix4x4 pointOfView, Number duration, ReferenceFrame asSeenBy, Style style) {
        final edu.cmu.cs.dennisc.scenegraph.ReferenceFrame sgReferenceFrame = asSeenBy.getSGReferenceFrame();
        if (EpsilonUtilities.isWithinReasonableEpsilon((Number)(duration = Double.valueOf(this.adjustDurationIfNecessary(duration))), (double)RIGHT_NOW)) {
            if (!pointOfView.isNaN()) {
                this.setPointOfView(pointOfView, sgReferenceFrame);
            }
        } else if (pointOfView.isNaN()) {
            this.alreadyAdjustedDelay(duration);
        } else {
            AffineMatrix4x4 m0 = this.getTransformation(asSeenBy);
            this.perform((Animation)new AffineMatrix4x4Animation(duration, style, m0, pointOfView){

                protected void updateValue(AffineMatrix4x4 pointOfView) {
                    AbstractTransformable.this.setPointOfView(pointOfView, sgReferenceFrame);
                }
            });
        }
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void move(MoveDirection direction, Number amount, Number duration, ReferenceFrame asSeenBy, Style style) {
        Vector3 axis = direction.getAxis();
        this.applyTranslation(axis.x * amount.doubleValue(), axis.y * amount.doubleValue(), axis.z * amount.doubleValue(), duration, asSeenBy, style);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void move(MoveDirection direction, Number amount, Number duration, ReferenceFrame asSeenBy) {
        this.move(direction, amount, duration, asSeenBy, DEFAULT_STYLE);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void move(MoveDirection direction, Number amount, Number duration) {
        this.move(direction, amount, duration, AsSeenBy.SELF);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void move(MoveDirection direction, Number amount) {
        this.move(direction, amount, DEFAULT_DURATION);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void moveToward(Number amount, Composite target, Number duration, Style style) {
        Point3 tTarget = target.getSGComposite().getAbsoluteTransformation().translation;
        Point3 tThis = this.getSGComposite().getAbsoluteTransformation().translation;
        Vector3 v = Vector3.createSubtraction((Tuple3)tTarget, (Tuple3)tThis);
        double length = v.calculateMagnitude();
        if (length > 0.0) {
            v.multiply(amount.doubleValue() / length);
        } else {
            v.set(0.0, 0.0, amount.doubleValue());
        }
        this.applyTranslation(v.x, v.y, v.z, duration, AsSeenBy.SCENE, style);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void moveToward(Number amount, Composite target, Number duration) {
        this.moveToward(amount, target, duration, DEFAULT_STYLE);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void moveToward(Number amount, Composite target) {
        this.moveToward(amount, target, DEFAULT_DURATION);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void moveAwayFrom(Number amount, Composite target, Number duration, Style style) {
        this.moveToward(-amount.doubleValue(), target, duration, style);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void moveAwayFrom(Number amount, Composite target, Number duration) {
        this.moveAwayFrom(amount, target, duration, DEFAULT_STYLE);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void moveAwayFrom(Number amount, Composite target) {
        this.moveAwayFrom(amount, target, DEFAULT_DURATION);
    }

    @MethodTemplate(visibility=Visibility.TUCKED_AWAY)
    public void moveAtSpeed(MoveDirection direction, Number speed, Number duration, ReferenceFrame asSeenBy) {
        double amount = speed.doubleValue() * duration.doubleValue();
        Vector3 axis = direction.getAxis();
        this.applyTranslation(axis.x * amount, axis.y * amount, axis.z * amount, duration, asSeenBy, DEFAULT_SPEED_STYLE);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void moveAtSpeed(MoveDirection direction, Number speed, Number duration) {
        this.moveAtSpeed(direction, speed, duration, AsSeenBy.SELF);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void moveAtSpeed(MoveDirection direction, Number speed) {
        this.moveAtSpeed(direction, speed, DEFAULT_DURATION);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void turn(TurnDirection direction, @ParameterTemplate(preferredArgumentClass=AngleInRevolutions.class) Number amount, Number duration, ReferenceFrame asSeenBy, Style style) {
        this.applyRotationInRadians(direction.getAxis(), AngleUtilities.revolutionsToRadians((double)amount.doubleValue()), duration, asSeenBy, style);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void turn(TurnDirection direction, @ParameterTemplate(preferredArgumentClass=AngleInRevolutions.class) Number amount, Number duration, ReferenceFrame asSeenBy) {
        this.turn(direction, amount, duration, asSeenBy, DEFAULT_STYLE);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void turn(TurnDirection direction, @ParameterTemplate(preferredArgumentClass=AngleInRevolutions.class) Number amount, Number duration) {
        this.turn(direction, amount, duration, AsSeenBy.SELF);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void turn(TurnDirection direction, @ParameterTemplate(preferredArgumentClass=AngleInRevolutions.class) Number amount) {
        this.turn(direction, amount, DEFAULT_DURATION);
    }

    @MethodTemplate(visibility=Visibility.TUCKED_AWAY)
    public void turnAtSpeed(TurnDirection direction, @ParameterTemplate(preferredArgumentClass=AngleInRevolutions.class) Number speed, Number duration, ReferenceFrame asSeenBy) {
        this.applyRotationInRadians(direction.getAxis(), AngleUtilities.revolutionsToRadians((double)speed.doubleValue()) * duration.doubleValue(), duration, asSeenBy, DEFAULT_SPEED_STYLE);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void turnAtSpeed(TurnDirection direction, @ParameterTemplate(preferredArgumentClass=AngleInRevolutions.class) Number speed, Number duration) {
        this.turnAtSpeed(direction, speed, duration, AsSeenBy.SELF);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void turnAtSpeed(TurnDirection direction, @ParameterTemplate(preferredArgumentClass=AngleInRevolutions.class) Number speed) {
        this.turnAtSpeed(direction, speed, DEFAULT_DURATION);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void roll(RollDirection direction, @ParameterTemplate(preferredArgumentClass=AngleInRevolutions.class) Number amount, Number duration, ReferenceFrame asSeenBy, Style style) {
        this.applyRotationInRadians(direction.getAxis(), AngleUtilities.revolutionsToRadians((double)amount.doubleValue()), duration, asSeenBy, style);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void roll(RollDirection direction, @ParameterTemplate(preferredArgumentClass=AngleInRevolutions.class) Number amount, Number duration, ReferenceFrame asSeenBy) {
        this.roll(direction, amount, duration, asSeenBy, DEFAULT_STYLE);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void roll(RollDirection direction, @ParameterTemplate(preferredArgumentClass=AngleInRevolutions.class) Number amount, Number duration) {
        this.roll(direction, amount, duration, AsSeenBy.SELF);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void roll(RollDirection direction, @ParameterTemplate(preferredArgumentClass=AngleInRevolutions.class) Number amount) {
        this.roll(direction, amount, DEFAULT_DURATION);
    }

    @MethodTemplate(visibility=Visibility.TUCKED_AWAY)
    public void rollAtSpeed(RollDirection direction, @ParameterTemplate(preferredArgumentClass=AngleInRevolutions.class) Number speed, Number duration, ReferenceFrame asSeenBy) {
        this.applyRotationInRadians(direction.getAxis(), AngleUtilities.revolutionsToRadians((double)speed.doubleValue()) * duration.doubleValue(), duration, asSeenBy, DEFAULT_SPEED_STYLE);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void rollAtSpeed(RollDirection direction, @ParameterTemplate(preferredArgumentClass=AngleInRevolutions.class) Number speed, Number duration) {
        this.rollAtSpeed(direction, speed, duration, AsSeenBy.SELF);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void rollAtSpeed(RollDirection direction, @ParameterTemplate(preferredArgumentClass=AngleInRevolutions.class) Number speed) {
        this.rollAtSpeed(direction, speed, DEFAULT_DURATION);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void moveTo(ReferenceFrame target, Number duration, Style style) {
        this.setTranslationOnly(target, duration, style);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void moveTo(ReferenceFrame target, Number duration) {
        this.moveTo(target, duration, DEFAULT_STYLE);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void moveTo(ReferenceFrame target) {
        this.moveTo(target, DEFAULT_DURATION);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void orientTo(ReferenceFrame target, Number duration, Style style) {
        this.setAxesOnly(target, duration, style);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void orientTo(ReferenceFrame target, Number duration) {
        this.orientTo(target, duration, DEFAULT_STYLE);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void orientTo(ReferenceFrame target) {
        this.orientTo(target, DEFAULT_DURATION);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void moveAndOrientTo(ReferenceFrame target, Number duration, Style style) {
        this.setPointOfView(AffineMatrix4x4.accessIdentity(), duration, target, style);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void moveAndOrientTo(ReferenceFrame target, Number duration) {
        this.moveAndOrientTo(target, duration, DEFAULT_STYLE);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void moveAndOrientTo(ReferenceFrame target) {
        this.moveAndOrientTo(target, DEFAULT_DURATION);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void pointAt(ReferenceFrame target, Number duration, Style style) {
        this.setAxesOnly(this.calculatePointAtAxes(target), duration, style);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void pointAt(ReferenceFrame target, Number duration) {
        this.pointAt(target, duration, DEFAULT_STYLE);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void pointAt(ReferenceFrame target) {
        this.pointAt(target, DEFAULT_DURATION);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void turnToFace(ReferenceFrame target, Number duration, Style style) {
        this.setAxesOnly(this.calculateTurnToFaceAxes(target), duration, style);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void turnToFace(ReferenceFrame target, Number duration) {
        this.turnToFace(target, duration, DEFAULT_STYLE);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void turnToFace(ReferenceFrame target) {
        this.turnToFace(target, DEFAULT_DURATION);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void orientToUpright(Number duration, ReferenceFrame asSeenBy, Style style) {
        this.setAxesOnlyToUpright(duration, asSeenBy, style);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void orientToUpright(Number duration, ReferenceFrame asSeenBy) {
        this.orientToUpright(duration, asSeenBy, DEFAULT_STYLE);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void orientToUpright(Number duration) {
        this.orientToUpright(duration, AsSeenBy.SCENE);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void orientToUpright() {
        this.orientToUpright(DEFAULT_DURATION);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Point3 getPosition(ReferenceFrame asSeenBy) {
        return new Point3((Tuple3)this.getTransformation((ReferenceFrame)asSeenBy).translation);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public OrthogonalMatrix3x3 getOrientation(ReferenceFrame asSeenBy) {
        return this.getTransformation((ReferenceFrame)asSeenBy).orientation.createOrthogonalMatrix3x3();
    }

    @PropertyGetterTemplate(visibility=Visibility.TUCKED_AWAY)
    public Boolean isPivotShowing() {
        if (this.m_sgAxes != null) {
            return this.m_sgAxes.getParent() != null;
        }
        return false;
    }

    public void setPivotShowing(Boolean isPivotShowing) {
        if (isPivotShowing.booleanValue()) {
            if (this.m_sgAxes == null) {
                this.m_sgAxes = new ExtravagantAxes(1.0);
            }
            this.m_sgAxes.setParent(this.getSGComposite());
        } else if (this.m_sgAxes != null) {
            this.m_sgAxes.setParent(null);
        }
    }

    private class SetAxesOnlyAnimation
    extends UnitQuaternionAnimation {
        private edu.cmu.cs.dennisc.scenegraph.ReferenceFrame m_sgReferenceFrame;
        private OrthogonalMatrix3x3 m_buffer;

        public SetAxesOnlyAnimation(Number duration, Style style, UnitQuaternion q0, UnitQuaternion q1, edu.cmu.cs.dennisc.scenegraph.ReferenceFrame sgReferenceFrame) {
            super(duration, (edu.cmu.cs.dennisc.animation.Style)style, q0, q1);
            this.m_buffer = new OrthogonalMatrix3x3();
            this.m_sgReferenceFrame = sgReferenceFrame;
        }

        protected void updateValue(UnitQuaternion q) {
            this.m_buffer.setValue(q);
            AbstractTransformable.this.setAxesOnly(this.m_buffer, this.m_sgReferenceFrame);
        }
    }
}

