/*
 * Decompiled with CFR 0.152.
 */
package org.alice.apis.moveandturn;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.math.AngleUtilities;
import edu.cmu.cs.dennisc.math.InterpolationUtilities;
import org.alice.apis.moveandturn.Angle;

public class AngleInDegrees
extends Angle {
    private double m_degrees;

    public AngleInDegrees(Number other) {
        if (other instanceof edu.cmu.cs.dennisc.math.Angle) {
            this.setAsDegrees(((edu.cmu.cs.dennisc.math.Angle)other).getAsDegrees());
        } else {
            this.setAsDegrees(other.doubleValue());
        }
    }

    public AngleInDegrees(Angle other) {
        this.set(other);
    }

    public void decode(BinaryDecoder binaryDecoder) {
        this.m_degrees = binaryDecoder.decodeDouble();
    }

    public void encode(BinaryEncoder binaryEncoder) {
        binaryEncoder.encode(this.m_degrees);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Angle) {
            Angle a = (Angle)obj;
            return this.m_degrees == a.getAsDegrees();
        }
        return false;
    }

    public boolean isNaN() {
        return Double.isNaN(this.m_degrees);
    }

    public void setNaN() {
        this.m_degrees = Double.NaN;
    }

    public double getAsRadians() {
        return AngleUtilities.degreesToRadians((double)this.m_degrees);
    }

    public double getAsDegrees() {
        return this.m_degrees;
    }

    public double getAsRevolutions() {
        return AngleUtilities.degreesToRevolutions((double)this.m_degrees);
    }

    public void setAsRadians(double radians) {
        this.m_degrees = AngleUtilities.radiansToDegrees((double)radians);
    }

    public void setAsDegrees(double degrees) {
        this.m_degrees = degrees;
    }

    public void setAsRevolutions(double revolutions) {
        this.m_degrees = AngleUtilities.revolutionsToDegrees((double)revolutions);
    }

    public Angle createCopy() {
        return new AngleInDegrees(this);
    }

    public void set(edu.cmu.cs.dennisc.math.Angle other) {
        this.setAsDegrees(other.getAsDegrees());
    }

    public void setToInterpolation(edu.cmu.cs.dennisc.math.Angle a0, edu.cmu.cs.dennisc.math.Angle a1, double portion) {
        this.setAsDegrees(InterpolationUtilities.interpolate((double)a0.getAsDegrees(), (double)a1.getAsDegrees(), (double)portion));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(AngleInDegrees.class.getName());
        sb.append("[");
        sb.append(this.m_degrees);
        sb.append("]");
        return sb.toString();
    }
}

