/*
 * Decompiled with CFR 0.152.
 */
package org.alice.apis.moveandturn;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.math.AngleUtilities;
import edu.cmu.cs.dennisc.math.InterpolationUtilities;
import org.alice.apis.moveandturn.Angle;
import org.alice.apis.moveandturn.AngleInDegrees;

public class AngleInRevolutions
extends Angle {
    private double m_revolutions;

    public AngleInRevolutions(Number other) {
        if (other instanceof edu.cmu.cs.dennisc.math.Angle) {
            this.setAsRevolutions(((edu.cmu.cs.dennisc.math.Angle)other).getAsRevolutions());
        } else {
            this.setAsRevolutions(other.doubleValue());
        }
    }

    public void decode(BinaryDecoder binaryDecoder) {
        this.m_revolutions = binaryDecoder.decodeDouble();
    }

    public void encode(BinaryEncoder binaryEncoder) {
        binaryEncoder.encode(this.m_revolutions);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Angle) {
            Angle a = (Angle)obj;
            return this.m_revolutions == a.getAsRevolutions();
        }
        return false;
    }

    public boolean isNaN() {
        return Double.isNaN(this.m_revolutions);
    }

    public void setNaN() {
        this.m_revolutions = Double.NaN;
    }

    public double getAsRadians() {
        return AngleUtilities.revolutionsToRadians((double)this.m_revolutions);
    }

    public double getAsDegrees() {
        return AngleUtilities.revolutionsToDegrees((double)this.m_revolutions);
    }

    public double getAsRevolutions() {
        return this.m_revolutions;
    }

    public void setAsRadians(double radians) {
        this.m_revolutions = AngleUtilities.radiansToRevolutions((double)radians);
    }

    public void setAsDegrees(double degrees) {
        this.m_revolutions = AngleUtilities.degreesToRevolutions((double)degrees);
    }

    public void setAsRevolutions(double revolutions) {
        this.m_revolutions = revolutions;
    }

    public Angle createCopy() {
        return new AngleInDegrees(this);
    }

    public void set(edu.cmu.cs.dennisc.math.Angle other) {
        this.setAsRevolutions(other.getAsRevolutions());
    }

    public void setToInterpolation(edu.cmu.cs.dennisc.math.Angle a0, edu.cmu.cs.dennisc.math.Angle a1, double portion) {
        this.setAsRevolutions(InterpolationUtilities.interpolate((double)a0.getAsRevolutions(), (double)a1.getAsRevolutions(), (double)portion));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[");
        sb.append(this.m_revolutions);
        sb.append("]");
        return sb.toString();
    }
}

