/*
 * Decompiled with CFR 0.152.
 */
package org.alice.apis.moveandturn;

import edu.cmu.cs.dennisc.alice.annotations.ConstructorTemplate;
import edu.cmu.cs.dennisc.alice.annotations.MethodTemplate;
import edu.cmu.cs.dennisc.alice.annotations.ParameterTemplate;
import edu.cmu.cs.dennisc.alice.annotations.Visibility;
import edu.cmu.cs.dennisc.math.EpsilonUtilities;
import org.alice.apis.moveandturn.VolumeLevel;
import org.alice.virtualmachine.resources.AudioResource;

public class AudioSource {
    private AudioResource audioResource;
    private Double volume;
    private Double startTime;
    private Double stopTime;

    public static boolean isWithinReasonableEpsilonOfDefaultVolume(double volume) {
        return EpsilonUtilities.isWithinReasonableEpsilon((Number)1.0, (double)volume);
    }

    public static boolean isWithinReasonableEpsilonOfDefaultStartTime(double startTime) {
        return EpsilonUtilities.isWithinReasonableEpsilon((Number)0.0, (double)startTime);
    }

    public static boolean isDefaultStopTime_aka_NaN(double stopTime) {
        return Double.isNaN(stopTime);
    }

    @ConstructorTemplate(visibility=Visibility.PRIME_TIME)
    public AudioSource(AudioResource audioResource, @ParameterTemplate(preferredArgumentClass=VolumeLevel.class) Number volume, Number startTime, Number stopTime) {
        this.audioResource = audioResource;
        this.setVolume(volume);
        this.setStartTime(startTime);
        this.setStopTime(stopTime);
    }

    @ConstructorTemplate(visibility=Visibility.CHAINED)
    public AudioSource(AudioResource audioResource, @ParameterTemplate(preferredArgumentClass=VolumeLevel.class) Number volume, Number startTime) {
        this(audioResource, volume, startTime, Double.NaN);
    }

    @ConstructorTemplate(visibility=Visibility.CHAINED)
    public AudioSource(AudioResource audioResource, @ParameterTemplate(preferredArgumentClass=VolumeLevel.class) Number volume) {
        this(audioResource, volume, 0.0);
    }

    @ConstructorTemplate(visibility=Visibility.CHAINED)
    public AudioSource(AudioResource audioResource) {
        this(audioResource, 1.0);
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public AudioResource getAudioResource() {
        return this.audioResource;
    }

    public Double getVolume() {
        return this.volume;
    }

    private void setVolume(Number volume) {
        this.volume = volume.doubleValue();
    }

    public Double getStartTime() {
        return this.startTime;
    }

    private void setStartTime(Number startTime) {
        this.startTime = startTime != null ? Double.valueOf(startTime.doubleValue()) : Double.valueOf(Double.NaN);
    }

    public Double getStopTime() {
        return this.stopTime;
    }

    private void setStopTime(Number stopTime) {
        this.stopTime = stopTime != null ? Double.valueOf(stopTime.doubleValue()) : Double.valueOf(Double.NaN);
    }
}

