/*
 * Decompiled with CFR 0.152.
 */
package org.alice.apis.moveandturn;

import java.util.HashMap;
import org.alice.apis.moveandturn.font.Attribute;
import org.alice.apis.moveandturn.font.FamilyAttribute;
import org.alice.apis.moveandturn.font.FamilyConstant;
import org.alice.apis.moveandturn.font.PostureAttribute;
import org.alice.apis.moveandturn.font.PostureConstant;
import org.alice.apis.moveandturn.font.SizeAttribute;
import org.alice.apis.moveandturn.font.SizeValue;
import org.alice.apis.moveandturn.font.WeightAttribute;
import org.alice.apis.moveandturn.font.WeightConstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Font {
    private java.awt.Font m_awtFont;

    public Font(Attribute<?> ... attributes) {
        HashMap map = new HashMap();
        for (Attribute<?> attribute : attributes) {
            map.put(attribute.getKey(), attribute.getValue());
        }
        this.m_awtFont = new java.awt.Font(map);
    }

    public Font(java.awt.Font awtFont) {
        this.m_awtFont = awtFont;
    }

    public java.awt.Font getAsAWTFont() {
        return this.m_awtFont;
    }

    public Font deriveScaledFont(float scalar) {
        return this.deriveSizeFont((int)((float)this.m_awtFont.getSize() * scalar));
    }

    public Font deriveSizeFont(float size) {
        return new Font(this.m_awtFont.deriveFont(size));
    }

    public FamilyAttribute getFamily() {
        String family = this.m_awtFont.getFamily();
        if (family.equals("Serif")) {
            return FamilyConstant.SERIF;
        }
        return FamilyConstant.SANS_SERIF;
    }

    public WeightAttribute getWeight() {
        int style = this.m_awtFont.getStyle();
        if ((style & 1) != 0) {
            return WeightConstant.BOLD;
        }
        return WeightConstant.REGULAR;
    }

    public PostureAttribute getPosture() {
        int style = this.m_awtFont.getStyle();
        if ((style & 2) != 0) {
            return PostureConstant.OBLIQUE;
        }
        return PostureConstant.REGULAR;
    }

    public SizeAttribute getSize() {
        int size = this.m_awtFont.getSize();
        return new SizeValue(Float.valueOf(size));
    }
}

