/*
 * Decompiled with CFR 0.152.
 */
package org.alice.apis.moveandturn;

import edu.cmu.cs.dennisc.alice.annotations.PropertyGetterTemplate;
import edu.cmu.cs.dennisc.alice.annotations.Visibility;
import edu.cmu.cs.dennisc.animation.Animation;
import edu.cmu.cs.dennisc.animation.interpolation.DoubleAnimation;
import edu.cmu.cs.dennisc.math.EpsilonUtilities;
import edu.cmu.cs.dennisc.property.GetterSetterProperty;
import org.alice.apis.moveandturn.Light;
import org.alice.apis.moveandturn.Style;

public class PointLight
extends Light {
    public static final GetterSetterProperty<Double> CONSTANT_ATTENUATION_PROPERTY = new GetterSetterProperty(PointLight.class, "ConstantAttenuation");
    public static final GetterSetterProperty<Double> LINEAR_ATTENUATION_PROPERTY = new GetterSetterProperty(PointLight.class, "LinearAttenuation");
    public static final GetterSetterProperty<Double> QUADRATIC_ATTENUATION_PROPERTY = new GetterSetterProperty(PointLight.class, "QuadraticAttenuation");
    private edu.cmu.cs.dennisc.scenegraph.PointLight m_sgPointLight;

    protected edu.cmu.cs.dennisc.scenegraph.Light getSGLight() {
        if (this.m_sgPointLight == null) {
            this.m_sgPointLight = new edu.cmu.cs.dennisc.scenegraph.PointLight();
        }
        return this.m_sgPointLight;
    }

    @PropertyGetterTemplate(visibility=Visibility.PRIME_TIME)
    public Double getConstantAttenuation() {
        return (Double)this.m_sgPointLight.constantAttenuation.getValue();
    }

    public void setConstantAttenuation(Number constantAttenuation, Number duration, Style style) {
        if (EpsilonUtilities.isWithinReasonableEpsilon((Number)(duration = Double.valueOf(this.adjustDurationIfNecessary(duration))), (double)RIGHT_NOW)) {
            this.m_sgPointLight.constantAttenuation.setValue((Object)constantAttenuation.doubleValue());
        } else {
            this.perform((Animation)new DoubleAnimation(duration, style, this.getConstantAttenuation(), constantAttenuation.doubleValue()){

                protected void updateValue(Double v) {
                    ((PointLight)PointLight.this).m_sgPointLight.constantAttenuation.setValue((Object)v);
                }
            });
        }
    }

    public void setConstantAttenuation(Number constantAttenuation, Number duration) {
        this.setConstantAttenuation(constantAttenuation, duration, DEFAULT_STYLE);
    }

    public void setConstantAttenuation(Number constantAttenuation) {
        this.setConstantAttenuation(constantAttenuation, DEFAULT_DURATION);
    }

    @PropertyGetterTemplate(visibility=Visibility.PRIME_TIME)
    public Double getLinearAttenuation() {
        return (Double)this.m_sgPointLight.linearAttenuation.getValue();
    }

    public void setLinearAttenuation(Number linearAttenuation, Number duration, Style style) {
        if (EpsilonUtilities.isWithinReasonableEpsilon((Number)(duration = Double.valueOf(this.adjustDurationIfNecessary(duration))), (double)RIGHT_NOW)) {
            this.m_sgPointLight.linearAttenuation.setValue((Object)linearAttenuation.doubleValue());
        } else {
            this.perform((Animation)new DoubleAnimation(duration, style, this.getLinearAttenuation(), linearAttenuation.doubleValue()){

                protected void updateValue(Double v) {
                    ((PointLight)PointLight.this).m_sgPointLight.linearAttenuation.setValue((Object)v);
                }
            });
        }
    }

    public void setLinearAttenuation(Number linearAttenuation, Number duration) {
        this.setLinearAttenuation(linearAttenuation, duration, DEFAULT_STYLE);
    }

    public void setLinearAttenuation(Number linearAttenuation) {
        this.setLinearAttenuation(linearAttenuation, DEFAULT_DURATION);
    }

    @PropertyGetterTemplate(visibility=Visibility.PRIME_TIME)
    public Double getQuadraticAttenuation() {
        return (Double)this.m_sgPointLight.quadraticAttenuation.getValue();
    }

    public void setQuadraticAttenuation(Number quadraticAttenuation, Number duration, Style style) {
        if (EpsilonUtilities.isWithinReasonableEpsilon((Number)(duration = Double.valueOf(this.adjustDurationIfNecessary(duration))), (double)RIGHT_NOW)) {
            this.m_sgPointLight.quadraticAttenuation.setValue((Object)quadraticAttenuation.doubleValue());
        } else {
            this.perform((Animation)new DoubleAnimation(duration, style, this.getQuadraticAttenuation(), quadraticAttenuation.doubleValue()){

                protected void updateValue(Double v) {
                    ((PointLight)PointLight.this).m_sgPointLight.quadraticAttenuation.setValue((Object)v);
                }
            });
        }
    }

    public void setQuadraticAttenuation(Number quadraticAttenuation, Number duration) {
        this.setQuadraticAttenuation(quadraticAttenuation, duration, DEFAULT_STYLE);
    }

    public void setQuadraticAttenuation(Number quadraticAttenuation) {
        this.setQuadraticAttenuation(quadraticAttenuation, DEFAULT_DURATION);
    }
}

