/*
 * Decompiled with CFR 0.152.
 */
package org.alice.apis.moveandturn;

import edu.cmu.cs.dennisc.alice.ProgramClosedException;
import edu.cmu.cs.dennisc.alice.annotations.MethodTemplate;
import edu.cmu.cs.dennisc.alice.annotations.PropertyGetterTemplate;
import edu.cmu.cs.dennisc.alice.annotations.Visibility;
import edu.cmu.cs.dennisc.animation.Animation;
import edu.cmu.cs.dennisc.animation.interpolation.DoubleAnimation;
import edu.cmu.cs.dennisc.awt.event.LenientMouseClickAdapter;
import edu.cmu.cs.dennisc.color.Color4f;
import edu.cmu.cs.dennisc.color.animation.Color4fAnimation;
import edu.cmu.cs.dennisc.lookingglass.OnscreenLookingGlass;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.EpsilonUtilities;
import edu.cmu.cs.dennisc.property.GetterSetterProperty;
import edu.cmu.cs.dennisc.scenegraph.AmbientLight;
import edu.cmu.cs.dennisc.scenegraph.Background;
import edu.cmu.cs.dennisc.scenegraph.Element;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.LinkedList;
import java.util.List;
import org.alice.apis.moveandturn.Color;
import org.alice.apis.moveandturn.Composite;
import org.alice.apis.moveandturn.Model;
import org.alice.apis.moveandturn.PickHintUtilities;
import org.alice.apis.moveandturn.ReferenceFrame;
import org.alice.apis.moveandturn.SceneOwner;
import org.alice.apis.moveandturn.Style;
import org.alice.apis.moveandturn.Transformable;
import org.alice.apis.moveandturn.event.KeyEvent;
import org.alice.apis.moveandturn.event.KeyListener;
import org.alice.apis.moveandturn.event.MouseButtonEvent;
import org.alice.apis.moveandturn.event.MouseButtonListener;
import org.alice.interact.AbstractDragAdapter;
import org.alice.interact.GlobalDragAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scene
extends Composite {
    public static final GetterSetterProperty<Color> AMBIENT_LIGHT_BRIGHTNESS_PROPERTY = new GetterSetterProperty(Scene.class, "AmbientLightBrightness");
    public static final GetterSetterProperty<Color> AMBIENT_LIGHT_COLOR_PROPERTY = new GetterSetterProperty(Scene.class, "AmbientLightColor");
    public static final GetterSetterProperty<Color> ATMOSPHERE_COLOR_PROPERTY = new GetterSetterProperty(Scene.class, "AtmosphereColor");
    public static final GetterSetterProperty<Double> GLOBAL_BRIGHTNESS_PROPERTY = new GetterSetterProperty(Scene.class, "GlobalBrightness");
    private edu.cmu.cs.dennisc.scenegraph.Scene m_sgScene = new edu.cmu.cs.dennisc.scenegraph.Scene();
    private Background m_sgBackground = new Background();
    private AmbientLight m_sgAmbientLight = new AmbientLight();
    private SceneOwner m_owner;
    private AbstractDragAdapter dragAdapter;
    private List<MouseButtonListener> mouseButtonListeners = new LinkedList<MouseButtonListener>();
    private List<KeyListener> keyListeners = new LinkedList<KeyListener>();
    private LenientMouseClickAdapter mouseAdapter = new LenientMouseClickAdapter(){

        protected void mouseQuoteClickedUnquote(MouseEvent e, int quoteClickCountUnquote) {
            Scene.this.handleMouseQuoteClickedUnquote(e, quoteClickCountUnquote);
        }
    };
    private java.awt.event.KeyListener keyAdapter = new java.awt.event.KeyListener(){

        public void keyPressed(java.awt.event.KeyEvent e) {
            Scene.this.handleKeyPressed(e);
        }

        public void keyReleased(java.awt.event.KeyEvent e) {
        }

        public void keyTyped(java.awt.event.KeyEvent e) {
        }
    };

    public Scene() {
        this.putElement((Element)this.m_sgScene);
        this.m_sgBackground.color.setValue((Object)new Color4f(0.5f, 0.5f, 1.0f, 1.0f));
        this.m_sgScene.background.setValue((Object)this.m_sgBackground);
        this.m_sgAmbientLight.setParent((edu.cmu.cs.dennisc.scenegraph.Composite)this.m_sgScene);
        this.m_sgAmbientLight.color.setValue((Object)new Color4f(1.0f, 1.0f, 1.0f, 1.0f));
        this.m_sgAmbientLight.brightness.setValue((Object)Float.valueOf(0.3f));
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.m_sgScene.setName(name + ".m_sgScene");
        this.m_sgBackground.setName(name + ".m_sgBackground");
        this.m_sgAmbientLight.setName(name + ".m_sgAmbientLight");
    }

    @Override
    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public AffineMatrix4x4 getTransformation(ReferenceFrame other) {
        return other.getSGReferenceFrame().getInverseAbsoluteTransformation();
    }

    @Override
    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public edu.cmu.cs.dennisc.scenegraph.Composite getSGComposite() {
        return this.m_sgScene;
    }

    @Override
    public Scene getScene() {
        return this;
    }

    private void putBonusDataFor(Transformable transformable) {
        PickHintUtilities.setPickHint(transformable);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void addDefaultModelManipulation() {
        if (this.dragAdapter == null) {
            this.dragAdapter = new GlobalDragAdapter();
            this.dragAdapter.setOnscreenLookingGlass(this.getOwner().getOnscreenLookingGlass());
            for (Transformable transformable : this.getComponents()) {
                this.putBonusDataFor(transformable);
            }
        }
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void removeDefaultModelManipulation() {
        if (this.dragAdapter != null) {
            this.dragAdapter.setOnscreenLookingGlass(null);
            this.dragAdapter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void addMouseButtonListener(MouseButtonListener mouseButtonListener) {
        List<MouseButtonListener> list = this.mouseButtonListeners;
        synchronized (list) {
            this.mouseButtonListeners.add(mouseButtonListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodTemplate(visibility=Visibility.TUCKED_AWAY)
    public void removeMouseButtonListener(MouseButtonListener mouseButtonListener) {
        List<MouseButtonListener> list = this.mouseButtonListeners;
        synchronized (list) {
            this.mouseButtonListeners.remove(mouseButtonListener);
        }
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public List<MouseButtonListener> getMouseButtonListeners() {
        return this.mouseButtonListeners;
    }

    private boolean isMouseButtonListenerInExistence() {
        if (this.mouseButtonListeners.size() > 0) {
            return true;
        }
        for (Transformable component : this.getComponents()) {
            Model model;
            if (!(component instanceof Model) || (model = (Model)component).getMouseButtonListeners().size() <= 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMouseQuoteClickedUnquote(MouseEvent e, int quoteClickCountUnquote) {
        if (this.isMouseButtonListenerInExistence()) {
            List<MouseButtonListener> list = this.mouseButtonListeners;
            synchronized (list) {
                final MouseButtonEvent mbe = new MouseButtonEvent(e, this);
                Model model = mbe.getModelAtMouseLocation();
                if (model != null) {
                    for (final MouseButtonListener mouseButtonListener : this.getMouseButtonListeners()) {
                        new Thread(){

                            public void run() {
                                ProgramClosedException.invokeAndCatchProgramClosedException((Runnable)new Runnable(){

                                    public void run() {
                                        mouseButtonListener.mouseButtonClicked(mbe);
                                    }
                                });
                            }
                        }.start();
                    }
                    for (final MouseButtonListener mouseButtonListener : model.getMouseButtonListeners()) {
                        new Thread(){

                            public void run() {
                                ProgramClosedException.invokeAndCatchProgramClosedException((Runnable)new Runnable(){

                                    public void run() {
                                        mouseButtonListener.mouseButtonClicked(mbe);
                                    }
                                });
                            }
                        }.start();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void addKeyListener(KeyListener keyListener) {
        List<KeyListener> list = this.keyListeners;
        synchronized (list) {
            this.keyListeners.add(keyListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodTemplate(visibility=Visibility.TUCKED_AWAY)
    public void removeKeyListener(KeyListener keyListener) {
        List<KeyListener> list = this.keyListeners;
        synchronized (list) {
            this.keyListeners.remove(keyListener);
        }
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public List<KeyListener> getKeyListeners() {
        return this.keyListeners;
    }

    private boolean isKeyListenerInExistence() {
        if (this.keyListeners.size() > 0) {
            return true;
        }
        for (Transformable component : this.getComponents()) {
            if (component.getKeyListeners().size() <= 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleKeyPressed(java.awt.event.KeyEvent e) {
        if (this.isKeyListenerInExistence()) {
            List<KeyListener> list = this.keyListeners;
            synchronized (list) {
                final KeyEvent ke = new KeyEvent(e);
                for (final KeyListener keyListener : this.keyListeners) {
                    new Thread(){

                        public void run() {
                            ProgramClosedException.invokeAndCatchProgramClosedException((Runnable)new Runnable(){

                                public void run() {
                                    keyListener.keyPressed(ke);
                                }
                            });
                        }
                    }.start();
                }
                for (Transformable component : this.getComponents()) {
                    for (final KeyListener keyListener : component.getKeyListeners()) {
                        new Thread(){

                            public void run() {
                                ProgramClosedException.invokeAndCatchProgramClosedException((Runnable)new Runnable(){

                                    public void run() {
                                        keyListener.keyPressed(ke);
                                    }
                                });
                            }
                        }.start();
                    }
                }
            }
        }
    }

    @Override
    @PropertyGetterTemplate(visibility=Visibility.TUCKED_AWAY)
    public SceneOwner getOwner() {
        return this.m_owner;
    }

    public void setOwner(SceneOwner owner) {
        if (this.m_owner != owner) {
            Component component;
            OnscreenLookingGlass lg;
            if (this.m_owner != null) {
                lg = this.m_owner.getOnscreenLookingGlass();
                component = lg.getAWTComponent();
                component.removeMouseListener((MouseListener)this.mouseAdapter);
                component.removeMouseMotionListener((MouseMotionListener)this.mouseAdapter);
                component.removeKeyListener(this.keyAdapter);
            }
            this.m_owner = owner;
            this.handleOwnerChange(this.m_owner);
            if (this.m_owner != null) {
                lg = this.m_owner.getOnscreenLookingGlass();
                component = lg.getAWTComponent();
                component.addMouseListener((MouseListener)this.mouseAdapter);
                component.addMouseMotionListener((MouseMotionListener)this.mouseAdapter);
                component.addKeyListener(this.keyAdapter);
            }
        }
    }

    @PropertyGetterTemplate(visibility=Visibility.PRIME_TIME)
    public Color getAmbientLightColor() {
        return new Color((Color4f)this.m_sgAmbientLight.color.getValue());
    }

    public void setAmbientLightColor(Color color, Number duration, Style style) {
        if (EpsilonUtilities.isWithinReasonableEpsilon((Number)(duration = Double.valueOf(this.adjustDurationIfNecessary(duration))), (double)RIGHT_NOW)) {
            this.m_sgAmbientLight.color.setValue((Object)color.getInternal());
        } else {
            this.perform((Animation)new Color4fAnimation(duration, style, this.getAmbientLightColor().getInternal(), color.getInternal()){

                protected void updateValue(Color4f c) {
                    ((Scene)Scene.this).m_sgAmbientLight.color.setValue((Object)c);
                }
            });
        }
    }

    public void setAmbientLightColor(Color color, Number duration) {
        this.setAmbientLightColor(color, duration, DEFAULT_STYLE);
    }

    public void setAmbientLightColor(Color color) {
        this.setAmbientLightColor(color, DEFAULT_DURATION);
    }

    @PropertyGetterTemplate(visibility=Visibility.PRIME_TIME)
    public Double getAmbientLightBrightness() {
        return ((Float)this.m_sgAmbientLight.brightness.getValue()).floatValue();
    }

    public void setAmbientLightBrightness(Number brightness, Number duration, Style style) {
        if (EpsilonUtilities.isWithinReasonableEpsilon((Number)(duration = Double.valueOf(this.adjustDurationIfNecessary(duration))), (double)RIGHT_NOW)) {
            this.m_sgAmbientLight.brightness.setValue((Object)Float.valueOf(brightness.floatValue()));
        } else {
            this.perform((Animation)new DoubleAnimation(duration, style, this.getAmbientLightBrightness(), brightness.doubleValue()){

                protected void updateValue(Double d) {
                    ((Scene)Scene.this).m_sgAmbientLight.brightness.setValue((Object)Float.valueOf(d.floatValue()));
                }
            });
        }
    }

    public void setAmbientLightBrightness(Number brightness, Number duration) {
        this.setAmbientLightBrightness(brightness, duration, DEFAULT_STYLE);
    }

    public void setAmbientLightBrightness(Number brightness) {
        this.setAmbientLightBrightness(brightness, DEFAULT_DURATION);
    }

    @PropertyGetterTemplate(visibility=Visibility.PRIME_TIME)
    public Color getAtmosphereColor() {
        return new Color((Color4f)this.m_sgBackground.color.getValue());
    }

    public void setAtmosphereColor(Color color, Number duration, Style style) {
        if (EpsilonUtilities.isWithinReasonableEpsilon((Number)(duration = Double.valueOf(this.adjustDurationIfNecessary(duration))), (double)RIGHT_NOW)) {
            this.m_sgBackground.color.setValue((Object)color.getInternal());
        } else {
            this.perform((Animation)new Color4fAnimation(duration, style, this.getAtmosphereColor().getInternal(), color.getInternal()){

                protected void updateValue(Color4f c) {
                    ((Scene)Scene.this).m_sgBackground.color.setValue((Object)c);
                }
            });
        }
    }

    public void setAtmosphereColor(Color color, Number duration) {
        this.setAtmosphereColor(color, duration, DEFAULT_STYLE);
    }

    public void setAtmosphereColor(Color color) {
        this.setAtmosphereColor(color, DEFAULT_DURATION);
    }

    @PropertyGetterTemplate(visibility=Visibility.PRIME_TIME)
    public Double getGlobalBrightness() {
        return ((Float)this.m_sgScene.globalBrightness.getValue()).floatValue();
    }

    public void setGlobalBrightness(Number brightness, Number duration, Style style) {
        if (EpsilonUtilities.isWithinReasonableEpsilon((Number)(duration = Double.valueOf(this.adjustDurationIfNecessary(duration))), (double)RIGHT_NOW)) {
            this.m_sgScene.globalBrightness.setValue((Object)Float.valueOf(brightness.floatValue()));
        } else {
            this.perform((Animation)new DoubleAnimation(duration, style, this.getGlobalBrightness(), brightness.doubleValue()){

                protected void updateValue(Double d) {
                    ((Scene)Scene.this).m_sgScene.globalBrightness.setValue((Object)Float.valueOf(d.floatValue()));
                }
            });
        }
    }

    public void setGlobalBrightness(Number brightness, Number duration) {
        this.setGlobalBrightness(brightness, duration, DEFAULT_STYLE);
    }

    public void setGlobalBrightness(Number brightness) {
        this.setGlobalBrightness(brightness, DEFAULT_DURATION);
    }
}

