/*
 * Decompiled with CFR 0.152.
 */
package org.alice.apis.moveandturn;

import edu.cmu.cs.dennisc.alice.annotations.MethodTemplate;
import edu.cmu.cs.dennisc.alice.annotations.ParameterTemplate;
import edu.cmu.cs.dennisc.alice.annotations.PropertyGetterTemplate;
import edu.cmu.cs.dennisc.alice.annotations.Visibility;
import edu.cmu.cs.dennisc.lookingglass.LookingGlass;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.Angle;
import edu.cmu.cs.dennisc.math.AxisAlignedBox;
import edu.cmu.cs.dennisc.math.Sphere;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.scenegraph.Composite;
import edu.cmu.cs.dennisc.scenegraph.Element;
import org.alice.apis.moveandturn.AbstractPerspectiveCamera;
import org.alice.apis.moveandturn.AngleInRevolutions;
import org.alice.apis.moveandturn.AsSeenBy;
import org.alice.apis.moveandturn.HowMuch;
import org.alice.apis.moveandturn.Model;
import org.alice.apis.moveandturn.ReferenceFrame;
import org.alice.apis.moveandturn.StandIn;
import org.alice.apis.moveandturn.Style;

public class SymmetricPerspectiveCamera
extends AbstractPerspectiveCamera {
    private edu.cmu.cs.dennisc.scenegraph.SymmetricPerspectiveCamera m_sgCamera = null;

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public edu.cmu.cs.dennisc.scenegraph.AbstractPerspectiveCamera getSGPerspectiveCamera() {
        return this.getSGSymmetricPerspectiveCamera();
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public edu.cmu.cs.dennisc.scenegraph.SymmetricPerspectiveCamera getSGSymmetricPerspectiveCamera() {
        if (this.m_sgCamera == null) {
            this.m_sgCamera = new edu.cmu.cs.dennisc.scenegraph.SymmetricPerspectiveCamera();
            this.m_sgCamera.farClippingPlaneDistance.setValue((Object)1000.0);
            this.m_sgCamera.setParent((Composite)this.getSGTransformable());
            this.putElement((Element)this.m_sgCamera);
        }
        return this.m_sgCamera;
    }

    @PropertyGetterTemplate(visibility=Visibility.TUCKED_AWAY)
    public Double getHorizontalViewingAngle() {
        return ((Angle)this.getSGSymmetricPerspectiveCamera().horizontalViewingAngle.getValue()).getAsRevolutions();
    }

    public void setHorizontalViewingAngle(@ParameterTemplate(preferredArgumentClass=AngleInRevolutions.class) Number horizontalViewingAngle) {
        this.getSGSymmetricPerspectiveCamera().horizontalViewingAngle.setValue((Object)new edu.cmu.cs.dennisc.math.AngleInRevolutions(horizontalViewingAngle.doubleValue()));
    }

    @PropertyGetterTemplate(visibility=Visibility.TUCKED_AWAY)
    public Double getVerticalViewingAngle() {
        return ((Angle)this.getSGSymmetricPerspectiveCamera().verticalViewingAngle.getValue()).getAsRevolutions();
    }

    public void setVerticalViewingAngle(@ParameterTemplate(preferredArgumentClass=AngleInRevolutions.class) Number verticalViewingAngle) {
        this.getSGSymmetricPerspectiveCamera().verticalViewingAngle.setValue((Object)new edu.cmu.cs.dennisc.math.AngleInRevolutions(verticalViewingAngle.doubleValue()));
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public Angle getActualHorizontalViewingAngle() {
        LookingGlass lg = this.getLookingGlass();
        assert (lg != null);
        return lg.getActualHorizontalViewingAngle(this.getSGSymmetricPerspectiveCamera());
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public Angle getActualVerticalViewingAngle() {
        LookingGlass lg = this.getLookingGlass();
        assert (lg != null);
        return lg.getActualVerticalViewingAngle(this.getSGSymmetricPerspectiveCamera());
    }

    private static double getMinAngleAsRadians(Angle horizontal, Angle vertical) {
        if (horizontal.isNaN()) {
            if (vertical.isNaN()) {
                return 0.7853981633974483;
            }
            return vertical.getAsRadians();
        }
        if (vertical.isNaN()) {
            return vertical.getAsRadians();
        }
        return Math.min(vertical.getAsRadians(), horizontal.getAsRadians());
    }

    protected double getViewingAngleInRadiansForGoodLookAt() {
        LookingGlass lg = this.getLookingGlass();
        if (lg != null) {
            return SymmetricPerspectiveCamera.getMinAngleAsRadians(lg.getActualHorizontalViewingAngle(this.getSGSymmetricPerspectiveCamera()), lg.getActualVerticalViewingAngle(this.getSGSymmetricPerspectiveCamera()));
        }
        return SymmetricPerspectiveCamera.getMinAngleAsRadians((Angle)this.getSGSymmetricPerspectiveCamera().horizontalViewingAngle.getValue(), (Angle)this.getSGSymmetricPerspectiveCamera().verticalViewingAngle.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AffineMatrix4x4 calculateGoodLookAt(AffineMatrix4x4 rv, Model target, HowMuch howMuch, ReferenceFrame asSeenBy) {
        Sphere boundingSphere = new Sphere();
        AxisAlignedBox boundingBox = target.getAxisAlignedMinimumBoundingBox(AsSeenBy.SELF, howMuch);
        boundingBox.getCenter(boundingSphere.center);
        double diameter = Math.max(boundingBox.getWidth(), Math.max(boundingBox.getHeight(), boundingBox.getDepth()));
        boundingSphere.radius = diameter * 0.5;
        if (boundingSphere.isNaN()) {
            boundingSphere.center.set(0.0, 0.0, 0.0);
            boundingSphere.radius = 1.0;
        }
        double theta = this.getViewingAngleInRadiansForGoodLookAt();
        double distance = boundingSphere.radius / Math.sin(theta * 0.5);
        double offset = (distance *= 1.5) / Math.sqrt(3.0);
        StandIn standInA = SymmetricPerspectiveCamera.acquireStandIn(target);
        try {
            standInA.moveTo(target.createOffsetStandIn(boundingSphere.center.x + offset, boundingSphere.center.y + offset, boundingSphere.center.z - offset), RIGHT_NOW);
            standInA.pointAt(target.createOffsetStandIn((Tuple3)boundingSphere.center), RIGHT_NOW);
            AffineMatrix4x4 affineMatrix4x4 = standInA.getTransformation(rv, asSeenBy);
            return affineMatrix4x4;
        }
        finally {
            SymmetricPerspectiveCamera.releaseStandIn(standInA);
        }
    }

    protected final AffineMatrix4x4 calculateGoodLookAt(Model target, HowMuch howMuch, ReferenceFrame referenceFrame) {
        return this.calculateGoodLookAt(AffineMatrix4x4.createNaN(), target, howMuch, referenceFrame);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void getGoodLookAt(Model target, Number duration, ReferenceFrame asSeenBy, Style style, HowMuch howMuch) {
        this.setPointOfView(this.calculateGoodLookAt(target, howMuch, asSeenBy), duration, asSeenBy, style);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void getGoodLookAt(Model target, Number duration, ReferenceFrame asSeenBy, Style style) {
        this.getGoodLookAt(target, duration, asSeenBy, style, DEFAULT_HOW_MUCH);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void getGoodLookAt(Model target, Number duration, ReferenceFrame asSeenBy) {
        this.getGoodLookAt(target, duration, asSeenBy, DEFAULT_STYLE);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void getGoodLookAt(Model target, Number duration) {
        this.getGoodLookAt(target, duration, target);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void getGoodLookAt(Model target) {
        this.getGoodLookAt(target, DEFAULT_DURATION);
    }
}

