/*
 * Decompiled with CFR 0.152.
 */
package org.alice.apis.moveandturn;

import edu.cmu.cs.dennisc.alice.annotations.MethodTemplate;
import edu.cmu.cs.dennisc.alice.annotations.PropertyGetterTemplate;
import edu.cmu.cs.dennisc.alice.annotations.Visibility;
import edu.cmu.cs.dennisc.alice.virtualmachine.ExceptionDetailUtilities;
import edu.cmu.cs.dennisc.animation.Animation;
import edu.cmu.cs.dennisc.lookingglass.LookingGlass;
import edu.cmu.cs.dennisc.math.AbstractMatrix4x4;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.AxisAlignedBox;
import edu.cmu.cs.dennisc.math.EpsilonUtilities;
import edu.cmu.cs.dennisc.math.Hexahedron;
import edu.cmu.cs.dennisc.math.Sphere;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.math.Vector4;
import edu.cmu.cs.dennisc.math.animation.Vector3Animation;
import edu.cmu.cs.dennisc.scenegraph.AbstractCamera;
import edu.cmu.cs.dennisc.scenegraph.Component;
import edu.cmu.cs.dennisc.scenegraph.Element;
import edu.cmu.cs.dennisc.scenegraph.bound.CumulativeBound;
import edu.cmu.cs.dennisc.scenegraph.graphics.Bubble;
import edu.cmu.cs.dennisc.scenegraph.graphics.SpeechBubble;
import edu.cmu.cs.dennisc.scenegraph.graphics.ThoughtBubble;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.alice.apis.moveandturn.AbstractTransformable;
import org.alice.apis.moveandturn.AsSeenBy;
import org.alice.apis.moveandturn.AxisAlignedBoundingBoxDecorator;
import org.alice.apis.moveandturn.BoundingSphereDecorator;
import org.alice.apis.moveandturn.Color;
import org.alice.apis.moveandturn.Composite;
import org.alice.apis.moveandturn.Font;
import org.alice.apis.moveandturn.HowMuch;
import org.alice.apis.moveandturn.Model;
import org.alice.apis.moveandturn.MoveDirection;
import org.alice.apis.moveandturn.OriginInclusionPolicy;
import org.alice.apis.moveandturn.ReferenceFrame;
import org.alice.apis.moveandturn.ResizePolicy;
import org.alice.apis.moveandturn.SceneOwner;
import org.alice.apis.moveandturn.SetSizePolicy;
import org.alice.apis.moveandturn.Style;
import org.alice.apis.moveandturn.Transformable;
import org.alice.apis.moveandturn.event.KeyListener;
import org.alice.apis.moveandturn.font.Attribute;
import org.alice.apis.moveandturn.graphic.animation.BubbleAnimation;
import org.alice.virtualmachine.DoTogether;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Transformable
extends AbstractTransformable {
    private edu.cmu.cs.dennisc.scenegraph.Transformable m_sgTransformable = new edu.cmu.cs.dennisc.scenegraph.Transformable();
    private Bubble.Originator m_originator = this.createOriginator();
    private List<KeyListener> keyListeners = new LinkedList<KeyListener>();
    private boolean m_isRealized = false;
    public static final OriginInclusionPolicy DEFAULT_ORIGIN_INCLUSION_POLICY = OriginInclusionPolicy.EXCLUDE_ORIGINS;
    private Font DEFAULT_FONT = new Font(new Attribute[0]).deriveScaledFont(2.0f);
    private AxisAlignedBoundingBoxDecorator m_boundingBoxDecorator;
    private BoundingSphereDecorator m_boundingSphereDecorator;
    public static final ResizePolicy DEFAULT_RESIZE_POLICY = ResizePolicy.PRESERVE_VOLUME;
    public static final SetSizePolicy DEFAULT_SET_SIZE_POLICY = SetSizePolicy.PRESERVE_ASPECT_RATIO;

    protected Bubble.Originator createOriginator() {
        return new Bubble.Originator(){

            public void calculate(Point2D.Float out_originOfTail, Point2D.Float out_bodyConnectionLocationOfTail, Point2D.Float out_textBoundsOffset, Bubble bubble, LookingGlass lookingGlass, Rectangle actualViewport, AbstractCamera sgCamera, Dimension2D textSize) {
                Vector4 offsetAsSeenBySubject = new Vector4();
                AxisAlignedBox bb = Transformable.this.getAxisAlignedMinimumBoundingBox();
                if (bubble instanceof SpeechBubble) {
                    offsetAsSeenBySubject.x = (bb.getXMinimum() + bb.getXMaximum()) * 0.5;
                    offsetAsSeenBySubject.y = (bb.getYMinimum() + bb.getYMaximum()) * 0.75;
                    offsetAsSeenBySubject.z = bb.getZMinimum();
                } else if (bubble instanceof ThoughtBubble) {
                    offsetAsSeenBySubject.x = (bb.getXMinimum() + bb.getXMaximum()) * 0.5;
                    offsetAsSeenBySubject.y = bb.getYMaximum();
                    offsetAsSeenBySubject.z = (bb.getZMinimum() + bb.getZMaximum()) * 0.5;
                } else {
                    offsetAsSeenBySubject.x = (bb.getXMinimum() + bb.getXMaximum()) * 0.5;
                    offsetAsSeenBySubject.y = (bb.getYMinimum() + bb.getYMaximum()) * 0.5;
                    offsetAsSeenBySubject.z = (bb.getZMinimum() + bb.getZMaximum()) * 0.5;
                }
                offsetAsSeenBySubject.w = 1.0;
                Vector4 offsetAsSeenByCamera = Transformable.this.getSGTransformable().transformTo_New(offsetAsSeenBySubject, (Component)sgCamera);
                Point p = sgCamera.transformToAWT_New(offsetAsSeenByCamera, lookingGlass);
                out_originOfTail.setLocation(p);
                out_bodyConnectionLocationOfTail.setLocation(200.0f, 100.0f);
                out_textBoundsOffset.setLocation(0.0f, 0.0f);
            }
        };
    }

    public Transformable() {
        this.putElement((Element)this.m_sgTransformable);
    }

    @Override
    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public edu.cmu.cs.dennisc.scenegraph.AbstractTransformable getSGAbstractTransformable() {
        return this.m_sgTransformable;
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public edu.cmu.cs.dennisc.scenegraph.Transformable getSGTransformable() {
        return this.m_sgTransformable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void addKeyListener(KeyListener keyListener) {
        List<KeyListener> list = this.keyListeners;
        synchronized (list) {
            this.keyListeners.add(keyListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodTemplate(visibility=Visibility.TUCKED_AWAY)
    public void removeKeyListener(KeyListener keyListener) {
        List<KeyListener> list = this.keyListeners;
        synchronized (list) {
            this.keyListeners.remove(keyListener);
        }
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public List<KeyListener> getKeyListeners() {
        return this.keyListeners;
    }

    protected void realize() {
        this.m_isRealized = true;
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public void realizeIfNecessary() {
        if (!this.m_isRealized) {
            this.realize();
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.m_sgTransformable.setName(name + ".m_sgTransformable");
    }

    @Override
    @PropertyGetterTemplate(visibility=Visibility.PRIME_TIME)
    public Composite getVehicle() {
        edu.cmu.cs.dennisc.scenegraph.Composite sgVehicle = this.m_sgTransformable.getParent();
        return (Composite)Transformable.getElement((Element)sgVehicle);
    }

    public void setVehicle(Composite vehicle) {
        Composite o = vehicle;
        while (true) {
            assert (o != this);
            if (o == null || !(o instanceof Transformable)) break;
            o = ((Transformable)o).getVehicle();
        }
        Composite previousVehicle = this.getVehicle();
        AffineMatrix4x4 absolute = null;
        if (previousVehicle != null) {
            absolute = this.m_sgTransformable.getTransformation((edu.cmu.cs.dennisc.scenegraph.ReferenceFrame)edu.cmu.cs.dennisc.scenegraph.AsSeenBy.SCENE);
            previousVehicle.removeComponent(this);
        }
        if (vehicle != null) {
            this.realizeIfNecessary();
            vehicle.addComponent(this);
            if (absolute != null) {
                this.m_sgTransformable.setTransformation(absolute, (edu.cmu.cs.dennisc.scenegraph.ReferenceFrame)edu.cmu.cs.dennisc.scenegraph.AsSeenBy.SCENE);
            }
        }
    }

    protected void handleVehicleChange(Composite vehicle) {
        if (vehicle != null) {
            this.realizeIfNecessary();
            this.m_sgTransformable.setParent(vehicle.getSGComposite());
        } else {
            this.m_sgTransformable.setParent(null);
        }
    }

    protected List<Transformable> updateHowMuch(List<Transformable> rv, boolean isThisIncluded, boolean isChildIncluded, boolean isGrandchildAndBeyondACandidate) {
        if (isThisIncluded) {
            rv.add(this);
        }
        if (isChildIncluded) {
            for (Transformable child : this.getComponents()) {
                child.updateHowMuch(rv, true, isGrandchildAndBeyondACandidate, isGrandchildAndBeyondACandidate);
            }
        }
        return rv;
    }

    protected CumulativeBound updateCumulativeBound(CumulativeBound rv, AffineMatrix4x4 trans, boolean isOriginIncluded) {
        if (isOriginIncluded) {
            rv.addOrigin(trans);
        }
        return rv;
    }

    private CumulativeBound createCumulativeBound(ReferenceFrame asSeenBy, HowMuch howMuch, OriginInclusionPolicy originPolicy) {
        LinkedList<Transformable> transformables = new LinkedList<Transformable>();
        this.updateHowMuch(transformables, howMuch.isThisACandidate(), howMuch.isChildACandidate(), howMuch.isGrandchildAndBeyondACandidate());
        CumulativeBound rv = new CumulativeBound();
        Composite actualAsSeenBy = asSeenBy.getActualReferenceFrame(this);
        for (Transformable transformable : transformables) {
            AffineMatrix4x4 m = transformable.getTransformation(actualAsSeenBy);
            assert (!m.isNaN());
            transformable.updateCumulativeBound(rv, m, originPolicy.isOriginIncluded());
        }
        return rv;
    }

    @MethodTemplate(visibility=Visibility.TUCKED_AWAY)
    public AxisAlignedBox getAxisAlignedMinimumBoundingBox(ReferenceFrame asSeenBy, HowMuch howMuch, OriginInclusionPolicy originPolicy) {
        CumulativeBound cumulativeBound = this.createCumulativeBound(asSeenBy, howMuch, originPolicy);
        return cumulativeBound.getBoundingBox();
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public AxisAlignedBox getAxisAlignedMinimumBoundingBox(ReferenceFrame asSeenBy, HowMuch howMuch) {
        return this.getAxisAlignedMinimumBoundingBox(asSeenBy, howMuch, DEFAULT_ORIGIN_INCLUSION_POLICY);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public AxisAlignedBox getAxisAlignedMinimumBoundingBox(ReferenceFrame asSeenBy) {
        return this.getAxisAlignedMinimumBoundingBox(asSeenBy, DEFAULT_HOW_MUCH);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public AxisAlignedBox getAxisAlignedMinimumBoundingBox() {
        return this.getAxisAlignedMinimumBoundingBox(AsSeenBy.SELF);
    }

    @MethodTemplate(visibility=Visibility.TUCKED_AWAY)
    public Sphere getBoundingSphere(ReferenceFrame asSeenBy, HowMuch howMuch, OriginInclusionPolicy originPolicy) {
        CumulativeBound cumulativeBound = this.createCumulativeBound(asSeenBy, howMuch, originPolicy);
        return cumulativeBound.getBoundingSphere();
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public Sphere getBoundingSphere(ReferenceFrame asSeenBy, HowMuch howMuch) {
        return this.getBoundingSphere(asSeenBy, howMuch, DEFAULT_ORIGIN_INCLUSION_POLICY);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public Sphere getBoundingSphere(ReferenceFrame asSeenBy) {
        return this.getBoundingSphere(asSeenBy, DEFAULT_HOW_MUCH);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public Sphere getBoundingSphere() {
        return this.getBoundingSphere(AsSeenBy.SELF);
    }

    protected void displayBubble(Bubble bubble, Number duration) {
        SceneOwner owner = this.getOwner();
        if (owner != null) {
            this.perform((Animation)new BubbleAnimation(this, 0.2, duration.doubleValue(), 0.2, bubble));
        } else {
            JOptionPane.showMessageDialog(null, "unable to display bubble");
        }
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void say(String text, Number duration, Font font, Color textColor, Color bubbleFillColor, Color bubbleOutlineColor) {
        SpeechBubble bubble = new SpeechBubble();
        bubble.text.setValue((Object)text);
        bubble.font.setValue((Object)font.getAsAWTFont());
        bubble.textColor.setValue((Object)textColor.getInternal());
        bubble.fillColor.setValue((Object)bubbleFillColor.getInternal());
        bubble.outlineColor.setValue((Object)bubbleOutlineColor.getInternal());
        bubble.originator.setValue((Object)this.m_originator);
        this.displayBubble((Bubble)bubble, duration);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void say(String text, Number duration, Font font, Color textColor, Color bubbleFillColor) {
        this.say(text, duration, font, textColor, bubbleFillColor, Color.BLACK);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void say(String text, Number duration, Font font, Color textColor) {
        this.say(text, duration, font, textColor, Color.WHITE);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void say(String text, Number duration, Font font) {
        this.say(text, duration, font, Color.BLACK);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void say(String text, Number duration) {
        this.say(text, duration, this.DEFAULT_FONT);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void say(String text) {
        this.say(text, DEFAULT_DURATION);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void think(String text, Number duration, Font font, Color textColor, Color bubbleFillColor, Color bubbleOutlineColor) {
        ThoughtBubble bubble = new ThoughtBubble();
        bubble.text.setValue((Object)text);
        bubble.font.setValue((Object)font.getAsAWTFont());
        bubble.textColor.setValue((Object)textColor.getInternal());
        bubble.fillColor.setValue((Object)bubbleFillColor.getInternal());
        bubble.outlineColor.setValue((Object)bubbleOutlineColor.getInternal());
        bubble.originator.setValue((Object)this.m_originator);
        this.displayBubble((Bubble)bubble, duration);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void think(String text, Number duration, Font font, Color textColor, Color bubbleFillColor) {
        this.think(text, duration, font, textColor, bubbleFillColor, Color.BLACK);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void think(String text, Number duration, Font font, Color textColor) {
        this.think(text, duration, font, textColor, Color.WHITE);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void think(String text, Number duration, Font font) {
        this.think(text, duration, font, Color.BLACK);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void think(String text, Number duration) {
        this.think(text, duration, this.DEFAULT_FONT);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void think(String text) {
        this.think(text, DEFAULT_DURATION);
    }

    protected void applyScale(Vector3 axis, boolean isScootDesired) {
        if (isScootDesired) {
            AffineMatrix4x4 m = (AffineMatrix4x4)this.getSGTransformable().localTransformation.getValue();
            m.translation.multiply((Tuple3)axis);
            this.getSGTransformable().localTransformation.setValue((Object)m);
        }
    }

    protected void applyScale(final Vector3 axis, Number duration, HowMuch howMuch, final Style style) {
        final double actualDuration = this.adjustDurationIfNecessary(duration);
        LinkedList<Transformable> transformables = new LinkedList<Transformable>();
        this.updateHowMuch(transformables, howMuch.isThisACandidate(), howMuch.isChildACandidate(), howMuch.isGrandchildAndBeyondACandidate());
        if (EpsilonUtilities.isWithinReasonableEpsilon((Number)actualDuration, (double)RIGHT_NOW)) {
            Iterator i$ = transformables.iterator();
            while (i$.hasNext()) {
                Transformable transformable;
                transformable.applyScale(axis, (transformable = (Transformable)i$.next()) != this);
            }
        } else {
            Runnable[] runnables = new Runnable[transformables.size()];
            int i = 0;
            for (final Transformable transformable : transformables) {
                runnables[i++] = new Runnable(){

                    public void run() {
                        class ScaleAnimation
                        extends Vector3Animation {
                            private Vector3 m_vPrev;
                            private Vector3 m_vBuffer;
                            private Transformable m_subject;
                            private boolean m_isScootDesired;
                            final /* synthetic */ Transformable this$0;

                            public ScaleAnimation(Transformable transformable, double duration, Style style, Vector3 axis, Transformable subject, boolean isScootDesired) {
                                this.this$0 = transformable;
                                super(duration, (edu.cmu.cs.dennisc.animation.Style)style, new Vector3(1.0, 1.0, 1.0), axis);
                                this.m_vPrev = new Vector3(1.0, 1.0, 1.0);
                                this.m_vBuffer = new Vector3();
                                this.m_subject = subject;
                                this.m_isScootDesired = isScootDesired;
                            }

                            protected void updateValue(Vector3 v) {
                                Vector3.setReturnValueToDivision((Tuple3)this.m_vBuffer, (Tuple3)v, (Tuple3)this.m_vPrev);
                                this.m_subject.applyScale(this.m_vBuffer, this.m_isScootDesired);
                                this.m_vPrev.set((Tuple3)v);
                            }
                        }
                        Transformable.this.perform((Animation)new ScaleAnimation(Transformable.this, actualDuration, style, axis, transformable, transformable != Transformable.this));
                    }
                };
            }
            DoTogether.invokeAndWait((Runnable[])runnables);
        }
    }

    @PropertyGetterTemplate(visibility=Visibility.TUCKED_AWAY)
    public Boolean isBoundingBoxShowing() {
        return this.m_boundingBoxDecorator != null && this.m_boundingBoxDecorator.isShowing() != false;
    }

    public void setBoundingBoxShowing(Boolean isBoundingBoxShowing) {
        if (isBoundingBoxShowing.booleanValue()) {
            if (this.m_boundingBoxDecorator == null) {
                this.m_boundingBoxDecorator = new AxisAlignedBoundingBoxDecorator(this, this);
            }
            this.m_boundingBoxDecorator.setShowing(true);
        } else if (this.m_boundingBoxDecorator != null) {
            this.m_boundingBoxDecorator.setShowing(false);
        }
    }

    @PropertyGetterTemplate(visibility=Visibility.TUCKED_AWAY)
    public Boolean isBoundingSphereShowing() {
        return this.m_boundingSphereDecorator != null && this.m_boundingSphereDecorator.isShowing() != false;
    }

    public void setBoundingSphereShowing(Boolean isBoundingSphereShowing) {
        if (isBoundingSphereShowing.booleanValue()) {
            if (this.m_boundingSphereDecorator == null) {
                this.m_boundingSphereDecorator = new BoundingSphereDecorator(this);
            }
            this.m_boundingSphereDecorator.setShowing(true);
        } else if (this.m_boundingSphereDecorator != null) {
            this.m_boundingSphereDecorator.setShowing(false);
        }
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Boolean isWithinThresholdOf(Number threshold, Model other) {
        return this.getDistanceTo(other) < threshold.doubleValue();
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Boolean isAtLeastThresholdAwayFrom(Number threshold, Model other) {
        return this.getDistanceTo(other) >= threshold.doubleValue();
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Double getDistanceTo(Model other) {
        assert (other != null);
        return this.getTransformation((ReferenceFrame)other).translation.calculateMagnitude();
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Double getDistanceToTheLeftOf(Model other) {
        assert (other != null);
        return -this.getTransformation((ReferenceFrame)other).translation.x;
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Double getDistanceToTheRightOf(Model other) {
        assert (other != null);
        return this.getTransformation((ReferenceFrame)other).translation.x;
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Double getDistanceAbove(Model other) {
        assert (other != null);
        return this.getTransformation((ReferenceFrame)other).translation.y;
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Double getDistanceBelow(Model other) {
        assert (other != null);
        return -this.getTransformation((ReferenceFrame)other).translation.y;
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Double getDistanceInFrontOf(Model other) {
        assert (other != null);
        return -this.getTransformation((ReferenceFrame)other).translation.z;
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Double getDistanceBehind(Model other) {
        assert (other != null);
        return this.getTransformation((ReferenceFrame)other).translation.z;
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Double getWidth() {
        return this.getAxisAlignedMinimumBoundingBox().getWidth();
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Double getHeight() {
        return this.getAxisAlignedMinimumBoundingBox().getHeight();
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Double getDepth() {
        return this.getAxisAlignedMinimumBoundingBox().getDepth();
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Boolean isSmallerThan(Model other) {
        assert (other != null);
        AxisAlignedBox bbThis = this.getAxisAlignedMinimumBoundingBox();
        AxisAlignedBox bbOther = other.getAxisAlignedMinimumBoundingBox();
        return bbThis.getVolume() < bbOther.getVolume();
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Boolean isLargerThan(Model other) {
        assert (other != null);
        AxisAlignedBox bbThis = this.getAxisAlignedMinimumBoundingBox();
        AxisAlignedBox bbOther = other.getAxisAlignedMinimumBoundingBox();
        return bbThis.getVolume() > bbOther.getVolume();
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Boolean isNarrowerThan(Model other) {
        assert (other != null);
        AxisAlignedBox bbThis = this.getAxisAlignedMinimumBoundingBox();
        AxisAlignedBox bbOther = other.getAxisAlignedMinimumBoundingBox();
        return bbThis.getWidth() < bbOther.getWidth();
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Boolean isWiderThan(Model other) {
        assert (other != null);
        AxisAlignedBox bbThis = this.getAxisAlignedMinimumBoundingBox();
        AxisAlignedBox bbOther = other.getAxisAlignedMinimumBoundingBox();
        return bbThis.getWidth() > bbOther.getWidth();
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Boolean isShorterThan(Model other) {
        assert (other != null);
        AxisAlignedBox bbThis = this.getAxisAlignedMinimumBoundingBox();
        AxisAlignedBox bbOther = other.getAxisAlignedMinimumBoundingBox();
        return bbThis.getHeight() < bbOther.getHeight();
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Boolean isTallerThan(Model other) {
        assert (other != null);
        AxisAlignedBox bbThis = this.getAxisAlignedMinimumBoundingBox();
        AxisAlignedBox bbOther = other.getAxisAlignedMinimumBoundingBox();
        return bbThis.getHeight() > bbOther.getHeight();
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Boolean isThinnerThan(Model other) {
        assert (other != null);
        AxisAlignedBox bbThis = this.getAxisAlignedMinimumBoundingBox();
        AxisAlignedBox bbOther = other.getAxisAlignedMinimumBoundingBox();
        return bbThis.getDepth() < bbOther.getDepth();
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Boolean isThickerThan(Model other) {
        assert (other != null);
        AxisAlignedBox bbThis = this.getAxisAlignedMinimumBoundingBox();
        AxisAlignedBox bbOther = other.getAxisAlignedMinimumBoundingBox();
        return bbThis.getDepth() > bbOther.getDepth();
    }

    private boolean isToCertainSideOf(Model other, Model asSeenBy, MoveDirection direction) {
        AffineMatrix4x4 thisTransformation = this.getTransformation(asSeenBy);
        AxisAlignedBox thisBB = this.getAxisAlignedMinimumBoundingBox();
        Hexahedron thisHexahedron = thisBB.getHexahedron();
        thisHexahedron.transform((AbstractMatrix4x4)thisTransformation);
        AxisAlignedBox thisTransformedBB = thisHexahedron.getAxisAlignedMinimumBoundingBox();
        AffineMatrix4x4 otherTransformation = other.getTransformation(asSeenBy);
        AxisAlignedBox otherBB = other.getAxisAlignedMinimumBoundingBox();
        Hexahedron otherHexahedron = otherBB.getHexahedron();
        otherHexahedron.transform((AbstractMatrix4x4)otherTransformation);
        AxisAlignedBox otherTransformedBB = otherHexahedron.getAxisAlignedMinimumBoundingBox();
        Vector3 axis = direction.getAxis();
        if (axis.isPositiveXAxis()) {
            return thisTransformedBB.getXMinimum() > otherTransformedBB.getXMaximum();
        }
        if (axis.isNegativeXAxis()) {
            return thisTransformedBB.getXMaximum() < otherTransformedBB.getXMinimum();
        }
        if (axis.isPositiveYAxis()) {
            return thisTransformedBB.getYMinimum() > otherTransformedBB.getYMaximum();
        }
        if (axis.isNegativeYAxis()) {
            return thisTransformedBB.getYMaximum() < otherTransformedBB.getYMinimum();
        }
        if (axis.isPositiveZAxis()) {
            return thisTransformedBB.getZMinimum() > otherTransformedBB.getZMaximum();
        }
        if (axis.isNegativeZAxis()) {
            return thisTransformedBB.getZMaximum() < otherTransformedBB.getZMinimum();
        }
        throw new RuntimeException();
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Boolean isToTheLeftOf(Model other, Model asSeenBy) {
        return this.isToCertainSideOf(other, asSeenBy, MoveDirection.LEFT);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public Boolean isToTheLeftOf(Model other) {
        return this.isToTheLeftOf(other, other);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Boolean isToTheRightOf(Model other, Model asSeenBy) {
        return this.isToCertainSideOf(other, asSeenBy, MoveDirection.RIGHT);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public Boolean isToTheRightOf(Model other) {
        return this.isToTheRightOf(other, other);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Boolean isAbove(Model other, Model asSeenBy) {
        return this.isToCertainSideOf(other, asSeenBy, MoveDirection.UP);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public Boolean isAbove(Model other) {
        return this.isAbove(other, other);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Boolean isBelow(Model other, Model asSeenBy) {
        return this.isToCertainSideOf(other, asSeenBy, MoveDirection.DOWN);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public Boolean isBelow(Model other) {
        return this.isBelow(other, other);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Boolean isInFrontOf(Model other, Model asSeenBy) {
        return this.isToCertainSideOf(other, asSeenBy, MoveDirection.FORWARD);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public Boolean isInFrontOf(Model other) {
        return this.isInFrontOf(other, other);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Boolean isBehind(Model other, Model asSeenBy) {
        return this.isToCertainSideOf(other, asSeenBy, MoveDirection.BACKWARD);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public Boolean isBehind(Model other) {
        return this.isBehind(other, other);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void resize(Number amount, Number duration, HowMuch howMuch, Style style) {
        this.applyScale(new Vector3(amount.doubleValue(), amount.doubleValue(), amount.doubleValue()), duration, howMuch, style);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void resize(Number amount, Number duration, HowMuch howMuch) {
        this.resize(amount, duration, howMuch, DEFAULT_STYLE);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void resize(Number amount, Number duration) {
        this.resize(amount, duration, DEFAULT_HOW_MUCH);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void resize(Number amount) {
        this.resize(amount, DEFAULT_DURATION);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void resizeWidth(Number amount, Number duration, ResizePolicy resizePolicy, HowMuch howMuch, Style style) {
        this.applyScale(Dimension.LEFT_TO_RIGHT.getResizeAxis(amount.doubleValue(), resizePolicy), duration, howMuch, style);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void resizeWidth(Number amount, Number duration, ResizePolicy resizePolicy, HowMuch howMuch) {
        this.resizeWidth(amount, duration, resizePolicy, howMuch, DEFAULT_STYLE);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void resizeWidth(Number amount, Number duration, ResizePolicy resizePolicy) {
        this.resizeWidth(amount, duration, resizePolicy, DEFAULT_HOW_MUCH);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void resizeWidth(Number amount, Number duration) {
        this.resizeWidth(amount, duration, DEFAULT_RESIZE_POLICY);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void resizeWidth(Number amount) {
        this.resizeWidth(amount, DEFAULT_DURATION);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void resizeHeight(Number amount, Number duration, ResizePolicy resizePolicy, HowMuch howMuch, Style style) {
        this.applyScale(Dimension.TOP_TO_BOTTOM.getResizeAxis(amount.doubleValue(), resizePolicy), duration, howMuch, style);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void resizeHeight(Number amount, Number duration, ResizePolicy resizePolicy, HowMuch howMuch) {
        this.resizeHeight(amount, duration, resizePolicy, howMuch, DEFAULT_STYLE);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void resizeHeight(Number amount, Number duration, ResizePolicy resizePolicy) {
        this.resizeHeight(amount, duration, resizePolicy, DEFAULT_HOW_MUCH);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void resizeHeight(Number amount, Number duration) {
        this.resizeHeight(amount, duration, DEFAULT_RESIZE_POLICY);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void resizeHeight(Number amount) {
        this.resizeHeight(amount, DEFAULT_DURATION);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void resizeDepth(Number amount, Number duration, ResizePolicy resizePolicy, HowMuch howMuch, Style style) {
        this.applyScale(Dimension.FRONT_TO_BACK.getResizeAxis(amount.doubleValue(), resizePolicy), duration, howMuch, style);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void resizeDepth(Number amount, Number duration, ResizePolicy resizePolicy, HowMuch howMuch) {
        this.resizeDepth(amount, duration, resizePolicy, howMuch, DEFAULT_STYLE);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void resizeDepth(Number amount, Number duration, ResizePolicy resizePolicy) {
        this.resizeDepth(amount, duration, resizePolicy, DEFAULT_HOW_MUCH);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void resizeDepth(Number amount, Number duration) {
        this.resizeDepth(amount, duration, DEFAULT_RESIZE_POLICY);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void resizeDepth(Number amount) {
        this.resizeDepth(amount, DEFAULT_DURATION);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void setWidth(Number amount, Number duration, SetSizePolicy setSizePolicy, HowMuch howMuch, Style style) {
        double width = this.getWidth();
        if (width > 0.0) {
            double factor = amount.doubleValue() / width;
            assert (!Double.isNaN(factor));
            if (setSizePolicy.isAspectRatioPreserved()) {
                this.resize(factor, duration, howMuch, style);
            } else {
                this.resizeWidth(factor, duration, setSizePolicy.getResizePolicy(), howMuch, style);
            }
        } else {
            throw new ArithmeticException(ExceptionDetailUtilities.createExceptionDetail((String)"unable to set the width of object that has zero width to begin with."));
        }
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void setWidth(Number amount, Number duration, SetSizePolicy setSizePolicy, HowMuch howMuch) {
        this.setWidth(amount, duration, setSizePolicy, howMuch, DEFAULT_STYLE);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void setWidth(Number amount, Number duration, SetSizePolicy setSizePolicy) {
        this.setWidth(amount, duration, setSizePolicy, DEFAULT_HOW_MUCH);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void setWidth(Number amount, Number duration) {
        this.setWidth(amount, duration, DEFAULT_SET_SIZE_POLICY);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void setWidth(Number amount) {
        this.setWidth(amount, DEFAULT_DURATION);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void setHeight(Number amount, Number duration, SetSizePolicy setSizePolicy, HowMuch howMuch, Style style) {
        double height = this.getHeight();
        if (height > 0.0) {
            double factor = amount.doubleValue() / height;
            assert (!Double.isNaN(factor));
            if (setSizePolicy.isAspectRatioPreserved()) {
                this.resize(factor, duration, howMuch, style);
            } else {
                this.resizeHeight(factor, duration, setSizePolicy.getResizePolicy(), howMuch, style);
            }
        } else {
            throw new ArithmeticException(ExceptionDetailUtilities.createExceptionDetail((String)"unable to set the height of object that has zero height to begin with."));
        }
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void setHeight(Number amount, Number duration, SetSizePolicy setSizePolicy, HowMuch howMuch) {
        this.setHeight(amount, duration, setSizePolicy, howMuch, DEFAULT_STYLE);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void setHeight(Number amount, Number duration, SetSizePolicy setSizePolicy) {
        this.setHeight(amount, duration, setSizePolicy, DEFAULT_HOW_MUCH);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void setHeight(Number amount, Number duration) {
        this.setHeight(amount, duration, DEFAULT_SET_SIZE_POLICY);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void setHeight(Number amount) {
        this.setHeight(amount, DEFAULT_DURATION);
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void setDepth(Number amount, Number duration, SetSizePolicy setSizePolicy, HowMuch howMuch, Style style) {
        double depth = this.getDepth();
        if (depth > 0.0) {
            double factor = amount.doubleValue() / depth;
            assert (!Double.isNaN(factor));
            if (setSizePolicy.isAspectRatioPreserved()) {
                this.resize(factor, duration, howMuch, style);
            } else {
                this.resizeDepth(factor, duration, setSizePolicy.getResizePolicy(), howMuch, style);
            }
        } else {
            throw new ArithmeticException(ExceptionDetailUtilities.createExceptionDetail((String)"unable to set the depth of object that has zero depth to begin with."));
        }
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void setDepth(Number amount, Number duration, SetSizePolicy setSizePolicy, HowMuch howMuch) {
        this.setDepth(amount, duration, setSizePolicy, howMuch, DEFAULT_STYLE);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void setDepth(Number amount, Number duration, SetSizePolicy setSizePolicy) {
        this.setDepth(amount, duration, setSizePolicy, DEFAULT_HOW_MUCH);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void setDepth(Number amount, Number duration) {
        this.setDepth(amount, duration, DEFAULT_SET_SIZE_POLICY);
    }

    @MethodTemplate(visibility=Visibility.CHAINED)
    public void setDepth(Number amount) {
        this.setDepth(amount, DEFAULT_DURATION);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class Dimension
    extends Enum<Dimension> {
        public static final /* enum */ Dimension LEFT_TO_RIGHT = new Dimension(true, false, false);
        public static final /* enum */ Dimension TOP_TO_BOTTOM = new Dimension(false, true, false);
        public static final /* enum */ Dimension FRONT_TO_BACK = new Dimension(false, false, true);
        private boolean m_isXScaled;
        private boolean m_isYScaled;
        private boolean m_isZScaled;
        private static final /* synthetic */ Dimension[] $VALUES;

        public static final Dimension[] values() {
            return (Dimension[])$VALUES.clone();
        }

        public static Dimension valueOf(String name) {
            return Enum.valueOf(Dimension.class, name);
        }

        private Dimension(boolean isXScaled, boolean isYScaled, boolean isZScaled) {
            this.m_isXScaled = isXScaled;
            this.m_isYScaled = isYScaled;
            this.m_isZScaled = isZScaled;
            assert (this.m_isXScaled ^ this.m_isYScaled ^ this.m_isZScaled);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Vector3 getResizeAxis(Vector3 rv, double amount, ResizePolicy resizePolicy) {
            double z;
            double y;
            double x;
            boolean isVolumePreserved = resizePolicy.isVolumePreserved();
            assert (amount > 0.0);
            if (isVolumePreserved) {
                double squash = 1.0 / Math.sqrt(amount);
                if (this.m_isXScaled) {
                    x = amount;
                    y = squash;
                    z = squash;
                } else if (this.m_isYScaled) {
                    x = squash;
                    y = amount;
                    z = squash;
                } else {
                    if (!this.m_isZScaled) throw new RuntimeException();
                    x = squash;
                    y = squash;
                    z = amount;
                }
            } else {
                x = 1.0;
                y = 1.0;
                z = 1.0;
                if (this.m_isXScaled) {
                    x = amount;
                }
                if (this.m_isYScaled) {
                    y = amount;
                }
                if (this.m_isZScaled) {
                    z = amount;
                }
            }
            rv.set(x, y, z);
            return rv;
        }

        public Vector3 getResizeAxis(double amount, ResizePolicy resizePolicy) {
            return this.getResizeAxis(Vector3.createNaN(), amount, resizePolicy);
        }

        static {
            $VALUES = new Dimension[]{LEFT_TO_RIGHT, TOP_TO_BOTTOM, FRONT_TO_BACK};
        }
    }
}

