/*
 * Decompiled with CFR 0.152.
 */
package org.alice.apis.moveandturn.gallery;

import edu.cmu.cs.dennisc.io.FileUtilities;
import edu.cmu.cs.dennisc.lang.SystemUtilities;
import java.awt.Component;
import java.io.File;
import java.util.LinkedList;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import org.alice.apis.moveandturn.gallery.GalleryDirectorySelectionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GalleryRootUtilities {
    private static final String ROOT_PATH_KEY = "rootPath";

    public static File calculateGalleryRootDirectory(Class<?> cls, String subPath, String name, String childName, String grandchildName, String titleForPromptingUserToSpecifyOrInstall, String applicationName) {
        File rv = null;
        Preferences userPreferences = Preferences.userNodeForPackage(cls);
        if (SystemUtilities.isPropertyTrue((String)"org.alice.clearAllPreferences")) {
            try {
                userPreferences.clear();
            }
            catch (BackingStoreException bse) {
                throw new RuntimeException(bse);
            }
        }
        String rootPathUserPreference = userPreferences.get(ROOT_PATH_KEY, null);
        do {
            String rootPathProperty;
            File installDir;
            String installDirPath;
            File galleryDir;
            LinkedList<String> potentialPaths = new LinkedList<String>();
            String galleryDirPath = System.getProperty("org.alice.apis.gallery.dir");
            if (galleryDirPath != null && galleryDirPath.length() > 0 && (galleryDir = new File(galleryDirPath)) != null && galleryDir.exists()) {
                potentialPaths.add(galleryDirPath);
            }
            if ((installDirPath = System.getProperty("org.alice.ide.IDE.install.dir")) != null && installDirPath.length() > 0 && (installDir = new File(installDirPath)) != null && installDir.exists()) {
                potentialPaths.add(FileUtilities.getCanonicalPathIfPossible((File)installDir) + "/gallery");
            }
            if ((rootPathProperty = System.getProperty(cls.getName() + "." + ROOT_PATH_KEY)) != null) {
                potentialPaths.add(rootPathProperty);
            }
            potentialPaths.add("/Program Files" + subPath);
            potentialPaths.add("/Applications" + subPath);
            potentialPaths.add("/Applications/Programming" + subPath);
            if (subPath.startsWith("/LookingGlass")) {
                potentialPaths.add("/Applications/Programming/Alice" + subPath);
            }
            potentialPaths.add("c:/Program Files" + subPath);
            potentialPaths.add("c:/Program Files (x86)" + subPath);
            potentialPaths.add(System.getProperty("user.home") + subPath);
            File userDir = new File(System.getProperty("user.dir"));
            if (userDir != null && userDir.exists()) {
                potentialPaths.add(FileUtilities.getCanonicalPathIfPossible((File)userDir) + "/" + name);
            }
            if (rootPathUserPreference != null) {
                potentialPaths.add(rootPathUserPreference);
            }
            for (String path : potentialPaths) {
                File directory = new File(path);
                if (!directory.exists() || !directory.isDirectory()) continue;
                rv = directory;
                break;
            }
            if (rv != null) continue;
            String expectedRoot = SystemUtilities.isWindows() ? "c:/Program Files" : (SystemUtilities.isMac() ? "/Applications" : System.getProperty("user.home"));
            int result = GalleryRootUtilities.promptUserToSpecifyOrInstall(expectedRoot + subPath, titleForPromptingUserToSpecifyOrInstall);
            if (result == 0) {
                GalleryDirectorySelectionPane galleryDirectorySelectionPane = new GalleryDirectorySelectionPane(name, childName, grandchildName);
                File directory = (File)galleryDirectorySelectionPane.showInJDialog(null);
                if (directory == null) continue;
                rv = directory;
                continue;
            }
            result = GalleryRootUtilities.promptUserToRetryOrExit(titleForPromptingUserToSpecifyOrInstall, applicationName);
            if (result == 0) continue;
            System.exit(-1);
        } while (rv == null);
        if (rv != null) {
            String path = FileUtilities.getCanonicalPathIfPossible(rv);
            try {
                userPreferences.put(ROOT_PATH_KEY, path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return rv;
    }

    private static int promptUserToSpecifyOrInstall(String expectedLocation, String title) {
        Component owner = null;
        title = "Cannot find " + title;
        String message = title + " in its expected location:\n    " + expectedLocation;
        Object[] options = new Object[]{"Specify Actual Gallery Location", "Exit and Install Gallery"};
        return JOptionPane.showOptionDialog(owner, message, title, 0, 0, null, options, null);
    }

    private static int promptUserToRetryOrExit(String title, String applicationName) {
        Component owner = null;
        title = "Must Install " + title;
        String message = applicationName + " will not work until the gallery is successfully installed.\nIf you are a student, please check with your instructor on how to install the gallery.\nIf you are an instructor, please check the wiki for information.";
        Object[] options = new Object[]{"Retry", "Exit"};
        return JOptionPane.showOptionDialog(owner, message, title, 0, 0, null, options, null);
    }
}

