/*
 * Decompiled with CFR 0.152.
 */
package org.alice.apis.moveandturn.graphic.animation;

import edu.cmu.cs.dennisc.animation.AnimationObserver;
import org.alice.apis.moveandturn.Composite;
import org.alice.apis.moveandturn.graphic.animation.OverlayGraphicAnimation;

public abstract class OpenUpdateCloseOverlayGraphicAnimation
extends OverlayGraphicAnimation {
    private double m_openingDuration;
    private double m_updatingDuration;
    private double m_closingDuration;

    public OpenUpdateCloseOverlayGraphicAnimation(Composite composite, double openingDuration, double updatingDuration, double closingDuration) {
        super(composite);
        this.m_openingDuration = openingDuration;
        this.m_updatingDuration = updatingDuration;
        this.m_closingDuration = closingDuration;
    }

    protected double getOpeningDuration() {
        return this.m_openingDuration;
    }

    protected double getUpdatingDuration() {
        return this.m_updatingDuration;
    }

    protected double getClosingDuration() {
        return this.m_closingDuration;
    }

    protected abstract void updateStateAndPortion(State var1, double var2);

    protected void prologue() {
        this.updateStateAndPortion(State.OPENNING, 0.0);
        super.prologue();
    }

    protected double update(double deltaSincePrologue, double deltaSinceLastUpdate, AnimationObserver animationObserver) {
        double portion;
        State state;
        if (this.m_openingDuration > 0.0 && deltaSincePrologue <= this.m_openingDuration) {
            state = State.OPENNING;
            portion = deltaSincePrologue / this.m_openingDuration;
        } else if (this.m_updatingDuration > 0.0 && deltaSincePrologue <= this.m_openingDuration + this.m_updatingDuration) {
            state = State.UPDATING;
            portion = (deltaSincePrologue - this.m_openingDuration) / this.m_updatingDuration;
        } else {
            state = State.CLOSING;
            portion = this.m_closingDuration > 0.0 ? Math.min((deltaSincePrologue - this.m_openingDuration - this.m_updatingDuration) / this.m_closingDuration, 1.0) : 1.0;
        }
        this.updateStateAndPortion(state, portion);
        return this.m_openingDuration + this.m_updatingDuration + this.m_closingDuration - deltaSincePrologue;
    }

    protected void epilogue() {
        this.updateStateAndPortion(State.CLOSING, 1.0);
        super.epilogue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum State {
        OPENNING,
        UPDATING,
        CLOSING;

    }
}

