/*
 * Decompiled with CFR 0.152.
 */
package alice.kareltherobot;

import java.util.HashMap;
import java.util.Map;

public abstract class Direction {
    public static final Direction NORTH = new KarelNorth();
    public static final Direction SOUTH = new KarelSouth();
    public static final Direction WEST = new KarelWest();
    public static final Direction EAST = new KarelEast();
    private static final Map<Direction, Direction> nextDirection = new HashMap<Direction, Direction>();

    static {
        nextDirection.put(NORTH, WEST);
        nextDirection.put(WEST, SOUTH);
        nextDirection.put(SOUTH, EAST);
        nextDirection.put(EAST, NORTH);
    }

    Direction() {
    }

    Direction next() {
        return nextDirection.get(this);
    }

    abstract int deltaStreet();

    abstract int deltaAvenue();

    static class KarelEast
    extends Direction {
        private KarelEast() {
        }

        int deltaStreet() {
            return 0;
        }

        int deltaAvenue() {
            return 1;
        }
    }

    static class KarelNorth
    extends Direction {
        private KarelNorth() {
        }

        int deltaStreet() {
            return 1;
        }

        int deltaAvenue() {
            return 0;
        }
    }

    static class KarelSouth
    extends Direction {
        private KarelSouth() {
        }

        int deltaStreet() {
            return -1;
        }

        int deltaAvenue() {
            return 0;
        }
    }

    static class KarelWest
    extends Direction {
        private KarelWest() {
        }

        int deltaStreet() {
            return 0;
        }

        int deltaAvenue() {
            return -1;
        }
    }
}

