/*
 * Decompiled with CFR 0.152.
 */
package alice.kareltherobot;

import alice.kareltherobot.Beeper;
import alice.kareltherobot.Direction;
import alice.kareltherobot.InfiniteBeepers;
import alice.kareltherobot.KarelWorld;
import alice.kareltherobot.Robot;
import alice.kareltherobot.UrRobot;
import alice.kareluser.TestWorld;
import org.alice.apis.moveandturn.Composite;
import org.alice.apis.moveandturn.Transformable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KarelTest {
    KarelWorld world;
    UrRobot karel;
    Robot karl;

    @Before
    public void setUp() throws Exception {
        this.world = new TestWorld();
        this.karel = new UrRobot(1, 1, Direction.NORTH, 0);
        this.karl = new Robot(5, 2, Direction.NORTH, 0);
        this.world.addComponent((Transformable)this.karel);
        this.world.addComponent((Transformable)this.karl);
    }

    @Test
    public void testPickInfinite() {
        this.world.placeBeepers(2, 1, -1);
        this.karel.move();
        this.karel.pickBeeper();
        this.karel.pickBeeper();
        this.karel.pickBeeper();
        Assert.assertEquals((long)-1L, (long)this.beepersAt(2, 1));
        Assert.assertEquals((Object)3, (Object)this.karel.value("b"));
        this.karel.move();
        this.karel.putBeeper();
        this.karel.putBeeper();
        Assert.assertEquals((Object)1, (Object)this.karel.value("b"));
        Assert.assertEquals((long)2L, (long)this.beepersAt(3, 1));
        Assert.assertEquals((long)-1L, (long)this.beepersAt(2, 1));
        Assert.assertEquals((long)0L, (long)this.beepersAt(1, 1));
    }

    @Test
    public void testPutInfinite() {
        UrRobot carol = new UrRobot(1, 1, Direction.NORTH, -1);
        this.world.addComponent((Transformable)carol);
        carol.putBeeper();
        carol.putBeeper();
        carol.putBeeper();
        Assert.assertEquals((Object)-1, (Object)carol.value("b"));
        Assert.assertEquals((long)3L, (long)this.beepersAt(1, 1));
        carol.pickBeeper();
        carol.pickBeeper();
        Assert.assertEquals((Object)-1, (Object)carol.value("b"));
        Assert.assertEquals((long)1L, (long)this.beepersAt(1, 1));
    }

    @Test
    public void testState() {
        Assert.assertEquals((long)1L, (long)this.robotsAt(1, 1));
        Assert.assertEquals((Object)1, (Object)this.karel.value("s"));
        Assert.assertEquals((Object)1, (Object)this.karel.value("a"));
        Assert.assertEquals((Object)0, (Object)this.karel.value("b"));
        Assert.assertEquals((Object)Direction.NORTH, (Object)this.karel.value("d"));
        Assert.assertTrue((boolean)((Boolean)this.karel.value("r")));
        this.karel.move();
        Assert.assertEquals((Object)2, (Object)this.karel.value("s"));
        Assert.assertEquals((Object)1, (Object)this.karel.value("a"));
        Assert.assertEquals((Object)0, (Object)this.karel.value("b"));
        Assert.assertEquals((Object)Direction.NORTH, (Object)this.karel.value("d"));
        Assert.assertTrue((boolean)((Boolean)this.karel.value("r")));
        this.karel.turnLeft();
        Assert.assertEquals((Object)2, (Object)this.karel.value("s"));
        Assert.assertEquals((Object)1, (Object)this.karel.value("a"));
        Assert.assertEquals((Object)0, (Object)this.karel.value("b"));
        Assert.assertEquals((Object)Direction.WEST, (Object)this.karel.value("d"));
        Assert.assertTrue((boolean)((Boolean)this.karel.value("r")));
        this.karel.turnLeft();
        Assert.assertEquals((Object)2, (Object)this.karel.value("s"));
        Assert.assertEquals((Object)1, (Object)this.karel.value("a"));
        Assert.assertEquals((Object)0, (Object)this.karel.value("b"));
        Assert.assertEquals((Object)Direction.SOUTH, (Object)this.karel.value("d"));
        Assert.assertTrue((boolean)((Boolean)this.karel.value("r")));
        this.karel.turnLeft();
        Assert.assertEquals((Object)2, (Object)this.karel.value("s"));
        Assert.assertEquals((Object)1, (Object)this.karel.value("a"));
        Assert.assertEquals((Object)0, (Object)this.karel.value("b"));
        Assert.assertEquals((Object)Direction.EAST, (Object)this.karel.value("d"));
        Assert.assertTrue((boolean)((Boolean)this.karel.value("r")));
        this.karel.move();
        Assert.assertEquals((Object)2, (Object)this.karel.value("s"));
        Assert.assertEquals((Object)2, (Object)this.karel.value("a"));
        Assert.assertEquals((Object)0, (Object)this.karel.value("b"));
        Assert.assertEquals((Object)Direction.EAST, (Object)this.karel.value("d"));
        Assert.assertTrue((boolean)((Boolean)this.karel.value("r")));
        Assert.assertEquals((long)0L, (long)this.beepersAt(2, 2));
        this.world.placeBeepers(2, 2, 1);
        Assert.assertEquals((long)1L, (long)this.beepersAt(2, 2));
        this.karel.pickBeeper();
        Assert.assertEquals((long)0L, (long)this.beepersAt(2, 2));
        Assert.assertEquals((Object)2, (Object)this.karel.value("s"));
        Assert.assertEquals((Object)2, (Object)this.karel.value("a"));
        Assert.assertEquals((Object)1, (Object)this.karel.value("b"));
        Assert.assertEquals((Object)Direction.EAST, (Object)this.karel.value("d"));
        Assert.assertTrue((boolean)((Boolean)this.karel.value("r")));
        Assert.assertEquals((long)0L, (long)this.beepersAt(2, 2));
        this.karel.move();
        this.karel.putBeeper();
        Assert.assertEquals((Object)2, (Object)this.karel.value("s"));
        Assert.assertEquals((Object)3, (Object)this.karel.value("a"));
        Assert.assertEquals((Object)0, (Object)this.karel.value("b"));
        Assert.assertEquals((Object)Direction.EAST, (Object)this.karel.value("d"));
        Assert.assertTrue((boolean)((Boolean)this.karel.value("r")));
        Assert.assertEquals((long)0L, (long)this.beepersAt(2, 2));
        Assert.assertEquals((long)1L, (long)this.beepersAt(2, 3));
        this.karel.turnOff();
        Assert.assertEquals((Object)2, (Object)this.karel.value("s"));
        Assert.assertEquals((Object)3, (Object)this.karel.value("a"));
        Assert.assertEquals((Object)0, (Object)this.karel.value("b"));
        Assert.assertEquals((Object)Direction.EAST, (Object)this.karel.value("d"));
        Assert.assertFalse((boolean)((Boolean)this.karel.value("r")));
        Assert.assertEquals((long)0L, (long)this.beepersAt(2, 2));
        Assert.assertEquals((long)1L, (long)this.beepersAt(2, 3));
        this.karel.move();
        this.karel.pickBeeper();
        this.karel.putBeeper();
        this.karel.turnLeft();
        Assert.assertEquals((Object)2, (Object)this.karel.value("s"));
        Assert.assertEquals((Object)3, (Object)this.karel.value("a"));
        Assert.assertEquals((Object)0, (Object)this.karel.value("b"));
        Assert.assertEquals((Object)Direction.EAST, (Object)this.karel.value("d"));
        Assert.assertFalse((boolean)((Boolean)this.karel.value("r")));
        Assert.assertEquals((long)0L, (long)this.beepersAt(2, 2));
        Assert.assertEquals((long)1L, (long)this.beepersAt(2, 3));
        UrRobot carol = new UrRobot(2, 3, Direction.NORTH, -1);
        this.world.addComponent((Transformable)carol);
        Assert.assertEquals((long)2L, (long)this.robotsAt(2, 3));
    }

    @Test
    public void testRobot() {
        Assert.assertTrue((boolean)this.karl.facingNorth());
        Assert.assertFalse((boolean)this.karl.nextToARobot());
        Assert.assertTrue((boolean)this.karl.frontIsClear());
        this.world.placeWallNorthOf(5, 2);
        Assert.assertFalse((boolean)this.karl.frontIsClear());
        Assert.assertFalse((boolean)this.karl.anyBeepersInBeeperBag());
        this.world.placeBeepers(5, 2, 1);
        this.karl.pickBeeper();
        Assert.assertTrue((boolean)this.karl.anyBeepersInBeeperBag());
        this.karl.putBeeper();
        Assert.assertFalse((boolean)this.karl.anyBeepersInBeeperBag());
        this.karl.turnLeft();
        Assert.assertTrue((boolean)this.karl.facingWest());
        this.karl.move();
        Assert.assertFalse((boolean)this.karl.frontIsClear());
        this.karl.turnLeft();
        Assert.assertTrue((boolean)this.karl.facingSouth());
        this.karl.turnLeft();
        Assert.assertTrue((boolean)this.karl.facingEast());
        UrRobot mary = new UrRobot(5, 1, Direction.EAST, 0);
        this.world.addComponent((Transformable)mary);
        Assert.assertTrue((boolean)this.karl.nextToARobot());
        this.karl.move();
        Assert.assertFalse((boolean)this.karl.nextToARobot());
    }

    @Test(expected=RuntimeException.class)
    public void testWalkThroughWall() {
        this.karel.turnLeft();
        this.karel.move();
    }

    public int beepersAt(int street, int avenue) {
        int result = 0;
        for (Composite match : this.world.findAllMatches()) {
            Beeper beep;
            if (match instanceof InfiniteBeepers && (beep = (Beeper)match).street() == street && beep.avenue() == avenue) {
                return -1;
            }
            if (!(match instanceof Beeper) || (beep = (Beeper)match).street() != street || beep.avenue() != avenue) continue;
            ++result;
        }
        return result;
    }

    public int robotsAt(int street, int avenue) {
        int result = 0;
        for (Composite match : this.world.findAllMatches()) {
            UrRobot robot;
            if (!(match instanceof UrRobot) || (Integer)(robot = (UrRobot)match).value("s") != street || (Integer)robot.value("a") != avenue) continue;
            ++result;
        }
        return result;
    }
}

