/*
 * Decompiled with CFR 0.152.
 */
package alice.kareltherobot;

import alice.kareltherobot.Beeper;
import alice.kareltherobot.InfiniteBeepers;
import alice.kareltherobot.InvisibleCameraTarget;
import alice.kareltherobot.UrRobot;
import alice.kareltherobot.Wall;
import com.jbergin.util.OpenQuaternion;
import com.jbergin.util.QuaternionCalculator;
import edu.cmu.cs.dennisc.texture.BufferedImageTexture;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.concurrent.Semaphore;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageOutputStream;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.SimpleDoc;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.alice.apis.moveandturn.AbstractCamera;
import org.alice.apis.moveandturn.Composite;
import org.alice.apis.moveandturn.DirectionalLight;
import org.alice.apis.moveandturn.Key;
import org.alice.apis.moveandturn.Model;
import org.alice.apis.moveandturn.MoveDirection;
import org.alice.apis.moveandturn.Orientation;
import org.alice.apis.moveandturn.PointOfView;
import org.alice.apis.moveandturn.Position;
import org.alice.apis.moveandturn.Quaternion;
import org.alice.apis.moveandturn.ReferenceFrame;
import org.alice.apis.moveandturn.Scene;
import org.alice.apis.moveandturn.SurfaceTexture;
import org.alice.apis.moveandturn.SymmetricPerspectiveCamera;
import org.alice.apis.moveandturn.Text;
import org.alice.apis.moveandturn.Transformable;
import org.alice.apis.moveandturn.TurnDirection;
import org.alice.apis.moveandturn.event.KeyEvent;
import org.alice.apis.moveandturn.event.KeyListener;
import org.alice.apis.moveandturn.gallery.GalleryModel;
import org.alice.apis.moveandturn.gallery.environments.grounds.GrassyGround;
import org.alice.apis.moveandturn.gallery.fantasy.Dragon;
import org.alice.apis.moveandturn.gallery.objects.Compass;
import org.alice.apis.moveandturn.gallery.shapes.HalfCylinder;

public abstract class KarelWorld
extends Scene {
    private DirectionalLight sunLight = new DirectionalLight();
    private GalleryModel groundImage = new GrassyGround();
    private SymmetricPerspectiveCamera camera = new SymmetricPerspectiveCamera();
    private AbstractCamera trackingCamera = null;
    private Model trackedModel = null;
    private int maximumBoundaryWall = 30;
    private int lastGridDrawn = 0;
    private int linesToDraw = 10;
    private boolean customImage = false;
    private boolean permissionToAct = true;
    private double defaultSpeed = 1.0;
    private static KarelWorld currentWorld = null;
    public static final int INFINITE = -1;

    public KarelWorld() {
        this(null);
    }

    public KarelWorld(GalleryModel groundImage) {
        if (groundImage != null) {
            this.groundImage = groundImage;
            this.customImage = true;
        }
        this.performSceneEditorGeneratedSetUp();
        this.setName("Karel World");
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                Key key = keyEvent.getKey();
                if (key.equals((Object)Key.UP)) {
                    KarelWorld.this.setSpeed(KarelWorld.this.defaultSpeed * 2.0);
                } else if (key.equals((Object)Key.DOWN)) {
                    KarelWorld.this.setSpeed(KarelWorld.this.defaultSpeed * 0.5);
                } else if (key.equals((Object)Key.LEFT)) {
                    KarelWorld.this.camera.move(MoveDirection.BACKWARD, (Number)0.5, (Number)(0.5 / KarelWorld.this.defaultSpeed));
                    KarelWorld.this.track();
                } else if (key.equals((Object)Key.RIGHT)) {
                    KarelWorld.this.camera.move(MoveDirection.FORWARD, (Number)0.5, (Number)(0.5 / KarelWorld.this.defaultSpeed));
                    KarelWorld.this.track();
                }
            }
        });
        currentWorld = this;
    }

    public static KarelWorld currentWorld() {
        return currentWorld;
    }

    public SymmetricPerspectiveCamera getCamera() {
        return this.camera;
    }

    public void setSpeed(double defaultSpeed) {
        if (defaultSpeed < 0.01) {
            defaultSpeed = 0.01;
        } else if (defaultSpeed > 100.0) {
            defaultSpeed = 100.0;
        }
        this.defaultSpeed = defaultSpeed;
        for (Composite match : this.findAllMatches(UrRobot.class)) {
            UrRobot robot = (UrRobot)match;
            robot.setSpeed(defaultSpeed);
        }
    }

    public double defaultSpeed() {
        return this.defaultSpeed;
    }

    void setPermissionToAct(boolean permission) {
        this.permissionToAct = permission;
    }

    boolean permissionToAct() {
        return this.permissionToAct;
    }

    protected void draw(Graphics2D g2) {
        for (Composite match : this.findAllMatches()) {
            if (match instanceof Beeper) {
                ((Beeper)match).draw(g2);
                continue;
            }
            if (match instanceof Wall) {
                ((Wall)match).draw(g2);
                continue;
            }
            if (!(match instanceof UrRobot)) continue;
            ((UrRobot)match).draw(g2);
        }
    }

    public void show2DScene(final int minStreet, final int minAvenue, final int maxStreet, final int maxAvenue) {
        int GRID_SIZE = 50;
        final JFrame frame = new JFrame();
        final JComponent component = new JComponent(){

            public void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.scale(50.0, 50.0);
                g2.translate(-minStreet + 1, -minAvenue + 1);
                g2.setStroke(new BasicStroke(0.02f));
                g2.setColor(Color.WHITE);
                Rectangle rect = this.getBounds();
                g2.fill(rect);
                g2.setColor(Color.LIGHT_GRAY);
                int i = minStreet - 1;
                while (i <= maxStreet) {
                    g2.drawLine(i, minAvenue - 1, i, maxAvenue);
                    ++i;
                }
                i = minAvenue - 1;
                while (i <= maxAvenue) {
                    g2.drawLine(minStreet - 1, i, maxStreet, i);
                    ++i;
                }
                g2.setColor(Color.BLACK);
                KarelWorld.this.draw(g2);
            }

            public Dimension getPreferredSize() {
                return new Dimension((maxStreet - minStreet + 1) * 50, (maxAvenue - minAvenue + 1) * 50);
            }
        };
        frame.add(component);
        JMenuBar menuBar = new JMenuBar();
        frame.setJMenuBar(menuBar);
        JMenu menu = new JMenu("File");
        menu.setMnemonic('F');
        menuBar.add(menu);
        JMenuItem item = new JMenuItem("Save", 83);
        menu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke("ctrl S"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogType(1);
                if (chooser.showSaveDialog(frame) == 0) {
                    try {
                        String file = chooser.getSelectedFile().getCanonicalPath();
                        KarelWorld.saveImage(component, file);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        final Semaphore sem = new Semaphore(0);
        item = new JMenuItem("Exit", 88);
        menu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke("ctrl X"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                frame.setVisible(false);
                sem.release();
            }
        });
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                frame.setVisible(false);
                sem.release();
            }
        });
        frame.pack();
        frame.setVisible(true);
        try {
            sem.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void saveImage(final JComponent componentToPaint, String fileName) throws IOException, PrintException {
        if (fileName.endsWith(".ps")) {
            DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
            String mimeType = "application/postscript";
            StreamPrintServiceFactory[] factories = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(flavor, mimeType);
            FileOutputStream out = new FileOutputStream(fileName);
            if (factories.length > 0) {
                StreamPrintService service = factories[0].getPrintService(out);
                SimpleDoc doc = new SimpleDoc(new Printable(){

                    public int print(Graphics g, PageFormat pf, int page) {
                        if (page >= 1) {
                            return 1;
                        }
                        System.out.println(componentToPaint.getWidth());
                        System.out.println(componentToPaint.getHeight());
                        System.out.println(pf.getImageableWidth());
                        System.out.println(pf.getImageableHeight());
                        System.out.println(pf.getWidth());
                        System.out.println(pf.getHeight());
                        double sf1 = pf.getImageableWidth() / (double)(componentToPaint.getWidth() + 1);
                        double sf2 = pf.getImageableHeight() / (double)(componentToPaint.getHeight() + 1);
                        double s = Math.min(sf1, sf2);
                        Graphics2D g2 = (Graphics2D)g;
                        g2.translate((pf.getWidth() - pf.getImageableWidth()) / 2.0, (pf.getHeight() - pf.getImageableHeight()) / 2.0);
                        g2.scale(s, s);
                        componentToPaint.paint(g);
                        return 0;
                    }
                }, flavor, null);
                DocPrintJob job = service.createPrintJob();
                HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
                job.print(doc, attributes);
            }
        } else {
            Rectangle rect = componentToPaint.getBounds();
            BufferedImage image = new BufferedImage(rect.width, rect.height, 1);
            Graphics g = image.getGraphics();
            componentToPaint.setBackground(Color.WHITE);
            componentToPaint.paint(g);
            String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
            File file = new File(fileName);
            boolean result = ImageIO.write((RenderedImage)image, extension, file);
            System.out.println("Saving as " + fileName + " Success = " + result);
            g.dispose();
        }
    }

    public void cameraStayFocusedOn(int street, int avenue) {
        InvisibleCameraTarget dummy = new InvisibleCameraTarget(street, avenue);
        this.addComponent((Transformable)dummy);
        this.cameraFollow((AbstractCamera)this.getCamera(), (Model)dummy);
    }

    public void cameraStayFocusedOn(int street, int avenue, double height) {
        InvisibleCameraTarget dummy = new InvisibleCameraTarget(street, avenue, height);
        this.addComponent((Transformable)dummy);
        this.cameraFollow((AbstractCamera)this.getCamera(), (Model)dummy);
    }

    public void moveCameraTo(int street, int avenue, double height) {
        InvisibleCameraTarget dummy = new InvisibleCameraTarget(street, avenue, height);
        this.addComponent((Transformable)dummy);
        this.camera.moveToward((Number)this.camera.getDistanceTo((Model)dummy), (Composite)dummy, (Number)0);
        this.removeComponent((Transformable)dummy);
    }

    public void moveCameraTo(int street, int avenue, double height, double duration) {
        InvisibleCameraTarget dummy = new InvisibleCameraTarget(street, avenue, height);
        this.addComponent((Transformable)dummy);
        this.camera.moveToward((Number)this.camera.getDistanceTo((Model)dummy), (Composite)dummy, (Number)duration);
        this.removeComponent((Transformable)dummy);
    }

    public void cameraFollow(AbstractCamera camera, Model model) {
        this.trackingCamera = camera;
        this.trackedModel = model;
        if (this.trackedModel instanceof UrRobot) {
            this.trackedModel = ((UrRobot)this.trackedModel).trackedPart();
        }
    }

    void refocusCamera() {
        if (this.trackedModel != null) {
            this.trackingCamera.pointAt((ReferenceFrame)this.trackedModel, (Number)(0.5 / this.defaultSpeed));
        }
    }

    public void cameraFollow(Model model) {
        this.trackingCamera = this.camera;
        this.trackedModel = model;
        if (this.trackedModel instanceof UrRobot) {
            this.trackedModel = ((UrRobot)this.trackedModel).trackedPart();
        }
    }

    void track() {
        try {
            this.trackingCamera.pointAt((ReferenceFrame)this.trackedModel, (Number)(1.0 / this.defaultSpeed));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public abstract void setTheStage();

    public abstract void run();

    public void say(String message) {
        this.groundImage.say(message);
    }

    public void think(String message) {
        this.groundImage.think(message);
    }

    final void performSceneEditorGeneratedSetUp() {
        this.setName("scene");
        this.setAtmosphereColor(new org.alice.apis.moveandturn.Color((Number)0.5, (Number)0.5, (Number)1.0));
        this.sunLight.setName("sunLight");
        this.sunLight.setLocalPointOfView(new PointOfView((Orientation)new Quaternion((Number)-0.7071067811865475, (Number)0.0, (Number)0.0, (Number)0.7071067811865476), new Position((Number)0.0, (Number)0.0, (Number)0.0)));
        this.addComponent((Transformable)this.sunLight);
        this.groundImage.setName("grassyGround");
        if (!this.customImage) {
            SurfaceTexture groundSurface = new SurfaceTexture();
            BufferedImageTexture texture = new BufferedImageTexture();
            BufferedImage karelImage = null;
            try {
                karelImage = ImageIO.read(new File("north.png"));
            }
            catch (IOException ex) {
                System.out.println("Can't create background.");
            }
            texture.setBufferedImage(karelImage);
            groundSurface.setBufferedImageTexture(texture);
            this.groundImage.setSurfaceTexture(groundSurface);
        }
        this.groundImage.setLocalPointOfView(new PointOfView((Orientation)new Quaternion((Number)0.0, (Number)0.0, (Number)0.0, (Number)1.0), new Position((Number)0.0, (Number)0.0, (Number)-0.0)));
        this.addComponent((Transformable)this.groundImage);
        this.camera.setName("camera");
        OpenQuaternion roundy = QuaternionCalculator.rotationAboutY(236.25);
        OpenQuaternion roundx = QuaternionCalculator.rotationAboutX(-30.0);
        OpenQuaternion qq = QuaternionCalculator.multiply(roundy, roundx);
        this.camera.setLocalPointOfView(new PointOfView((Orientation)qq, new Position((Number)-2, (Number)4, (Number)1)));
        this.camera.setVerticalViewingAngle((Number)0.15);
        this.addComponent((Transformable)this.camera);
        int i = 1;
        while (i <= this.maximumBoundaryWall) {
            this.placeWallEastOf(i, 0, true);
            this.placeWallNorthOf(0, i, true);
            ++i;
        }
        this.addGridLines();
        this.addGridLines();
        this.addGridLines();
    }

    protected void getGroundImage(GalleryModel groundImage, String filename) {
        BufferedImageTexture oldTexture = groundImage.getSurfaceTexture().getBufferedImageTexture();
        BufferedImage oldImage = oldTexture.getBufferedImage();
        try {
            ImageIO.write((RenderedImage)oldImage, "png", new FileImageOutputStream(new File(filename)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("There is no image that could be found.");
            e.printStackTrace();
        }
    }

    private HalfCylinder makeGridLine() {
        HalfCylinder grid = new HalfCylinder();
        grid.setColor(org.alice.apis.moveandturn.Color.BLUE);
        grid.resizeHeight((Number)0.001);
        grid.resizeWidth((Number)0.001);
        grid.setOpacity((Number)0.5);
        grid.move(MoveDirection.DOWN, (Number)0.1);
        return grid;
    }

    void addGridLines() {
        HalfCylinder grid;
        int i = this.lastGridDrawn;
        while (i < this.lastGridDrawn + this.linesToDraw) {
            grid = this.makeGridLine();
            grid.move(MoveDirection.RIGHT, (Number)((double)i + 0.56));
            grid.move(MoveDirection.BACKWARD, (Number)1999.13);
            this.addComponent((Transformable)grid);
            ++i;
        }
        i = this.lastGridDrawn;
        while (i < this.lastGridDrawn + this.linesToDraw) {
            grid = this.makeGridLine();
            grid.turn(TurnDirection.LEFT, (Number)0.25);
            grid.move(MoveDirection.RIGHT, (Number)(0.36 - (double)i));
            grid.move(MoveDirection.BACKWARD, (Number)2000.09);
            this.addComponent((Transformable)grid);
            ++i;
        }
        this.lastGridDrawn += this.linesToDraw;
    }

    int maximumBoundaryWall() {
        return this.maximumBoundaryWall;
    }

    void extendBoundaryWall() {
        int temp = 10;
        int i = 1;
        while (i <= temp) {
            this.placeWallEastOf(this.maximumBoundaryWall + i, 0, true);
            this.placeWallNorthOf(0, this.maximumBoundaryWall + i, true);
            ++i;
        }
        this.maximumBoundaryWall += temp;
        this.addGridLines();
    }

    public final UrRobot addRobot(UrRobot karel) {
        this.addComponent((Transformable)karel);
        return karel;
    }

    public void addComponent(Transformable item) {
        super.addComponent(item);
        if (item instanceof UrRobot) {
            UrRobot robot = (UrRobot)item;
            robot.setSpeed(this.defaultSpeed);
        }
    }

    public void addDecorations() {
        Text dragons = new Text();
        dragons.setValue("Here there be dragons");
        dragons.setLetterHeight((Number)0.5);
        OpenQuaternion qq = QuaternionCalculator.rotationAboutY(180.0);
        dragons.setLocalPointOfView(new PointOfView((Orientation)qq, new Position((Number)6, (Number)0.5, (Number)-2)));
        this.addComponent((Transformable)dragons);
        Dragon dragon = new Dragon();
        dragon.setHeight((Number)2);
        dragon.setLocalPointOfView(new PointOfView((Orientation)qq, new Position((Number)14, (Number)0.5, (Number)-1)));
        this.addComponent((Transformable)dragon);
        Compass compass = new Compass();
        compass.setHeight((Number)1);
        qq = QuaternionCalculator.rotationAboutY(90.0);
        qq = QuaternionCalculator.multiply(qq, QuaternionCalculator.rotationAboutX(45.0));
        compass.setLocalPointOfView(new PointOfView((Orientation)qq, new Position((Number)2, (Number)0.5, (Number)-0.5)));
        this.addComponent((Transformable)compass);
    }

    public final void readWorld(String filename) {
        this.readWorld(null, filename);
    }

    public final void readWorld(String directoryPath, String filename) {
        try {
            FileInputStream f = new FileInputStream(new File(directoryPath, filename));
            InputStreamReader r = new InputStreamReader(f);
            int size = f.available();
            char[] buf = new char[size];
            r.read(buf, 0, size);
            String commands = new String(buf);
            this.getWorld(commands);
            r.close();
        }
        catch (IOException e) {
            System.out.println("Can't read world.");
        }
    }

    public final void saveWorld(String filename) {
        this.saveWorld(null, filename);
    }

    public final void saveWorld(String directoryPath, String filename) {
        try {
            BufferedWriter w = new BufferedWriter(new FileWriter(new File(directoryPath, filename)));
            w.write("KarelWorld");
            w.newLine();
            for (Composite match : this.getScene().findAllMatches()) {
                Point where;
                Beeper p;
                HashMap<Point, Integer> beepers = new HashMap<Point, Integer>();
                if (match instanceof Wall) {
                    Wall wall = (Wall)match;
                    if (wall.getDirection() == 2 && wall.street() > 0) {
                        w.write("eastwestwalls " + wall.street() + " " + wall.avenue() + " " + wall.avenue());
                        w.newLine();
                    } else if (wall.getDirection() == 1 && wall.avenue() > 0) {
                        w.write("northsouthwalls " + wall.avenue() + " " + wall.street() + " " + wall.street());
                        w.newLine();
                    }
                } else if (match instanceof InfiniteBeepers) {
                    p = (InfiniteBeepers)match;
                    where = new Point(p.street(), p.avenue());
                    beepers.put(where, -1);
                } else if (match instanceof Beeper) {
                    p = (Beeper)match;
                    where = new Point(p.street(), p.avenue());
                    Integer howMany = (Integer)beepers.get(where);
                    if (howMany == null) {
                        beepers.put(where, 1);
                    } else if (howMany != -1) {
                        beepers.put(where, howMany + 1);
                    }
                }
                for (Point p2 : beepers.keySet()) {
                    w.write("beepers " + p2.x + " " + p2.y + " " + ((Integer)beepers.get(p2)).toString());
                    w.newLine();
                }
            }
            w.close();
        }
        catch (IOException e) {
            System.out.println("Can't save world.");
        }
    }

    private void getWorld(String commands) {
        if (commands == null) {
            return;
        }
        StringTokenizer t = new StringTokenizer(commands);
        while (t.hasMoreTokens()) {
            try {
                int n;
                int a;
                int s;
                String token = t.nextToken();
                if (token.equalsIgnoreCase("beepers")) {
                    s = Integer.parseInt(t.nextToken());
                    a = Integer.parseInt(t.nextToken());
                    n = Integer.parseInt(t.nextToken());
                    if (n == -1) {
                        InfiniteBeepers beep = new InfiniteBeepers(s, a);
                        this.addComponent((Transformable)beep);
                        continue;
                    }
                    int i = 0;
                    while (i < n) {
                        Beeper beep = new Beeper(s, a);
                        this.addComponent((Transformable)beep);
                        ++i;
                    }
                    continue;
                }
                if (token.equalsIgnoreCase("eastwestwalls")) {
                    s = Integer.parseInt(t.nextToken());
                    a = Integer.parseInt(t.nextToken());
                    n = Integer.parseInt(t.nextToken());
                    int i = 0;
                    while (i < n - a + 1) {
                        Wall hWall = new Wall(s, a + i, 2);
                        this.addComponent((Transformable)hWall);
                        ++i;
                    }
                    continue;
                }
                if (!token.equalsIgnoreCase("northsouthwalls")) continue;
                int a2 = Integer.parseInt(t.nextToken());
                int s2 = Integer.parseInt(t.nextToken());
                n = Integer.parseInt(t.nextToken());
                int i = 0;
                while (i < n - s2 + 1) {
                    Wall vWall = new Wall(s2 + i, a2, 1);
                    this.addComponent((Transformable)vWall);
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void placeBeepers(int street, int avenue, int howMany) {
        if (howMany < 0) {
            InfiniteBeepers beep = new InfiniteBeepers(street, avenue);
            this.addComponent((Transformable)beep);
        } else {
            int i = 0;
            while (i < howMany) {
                Beeper beep = new Beeper(street, avenue);
                this.addComponent((Transformable)beep);
                ++i;
            }
        }
    }

    public void clearBeepers(int street, int avenue) {
        for (Composite match : this.findAllMatches(Beeper.class)) {
            Beeper beeper = (Beeper)match;
            if (beeper.street() != street || beeper.avenue() != avenue) continue;
            this.removeComponent((Transformable)beeper);
        }
    }

    public void placeWallEastOf(int street, int avenue) {
        Wall wall = new Wall(street, avenue, 1);
        this.addComponent((Transformable)wall);
    }

    void placeWallEastOf(int street, int avenue, boolean isBoundary) {
        Wall wall = new Wall(street, avenue, 1, isBoundary);
        this.addComponent((Transformable)wall);
    }

    public void removeWallEastOf(int street, int avenue) {
        for (Composite match : this.getScene().findAllMatches(Wall.class)) {
            Wall w = (Wall)match;
            if (w.xLocation() != (double)street || w.yLocation() != (double)avenue + 0.5 || w.isBoundary()) continue;
            this.removeComponent((Transformable)w);
        }
    }

    public void removeWallNorthOf(int street, int avenue) {
        for (Composite match : this.getScene().findAllMatches(Wall.class)) {
            Wall w = (Wall)match;
            if (w.xLocation() != (double)street + 0.5 || w.yLocation() != (double)avenue || w.isBoundary()) continue;
            this.removeComponent((Transformable)w);
        }
    }

    public void placeWallNorthOf(int street, int avenue) {
        Wall wall = new Wall(street, avenue, 2);
        this.addComponent((Transformable)wall);
    }

    void placeWallNorthOf(int street, int avenue, boolean isBoundary) {
        Wall wall = new Wall(street, avenue, 2, isBoundary);
        this.addComponent((Transformable)wall);
    }

    public void reset() {
        for (Composite match : this.getScene().findAllMatches()) {
            if (match instanceof Wall) {
                Wall wall = (Wall)match;
                if (wall.isBoundary()) continue;
                this.removeComponent((Transformable)wall);
                continue;
            }
            if (!(match instanceof Beeper)) continue;
            Beeper beeper = (Beeper)match;
            this.removeComponent((Transformable)beeper);
        }
    }
}

