/*
 * Decompiled with CFR 0.152.
 */
package alice.kareltherobot;

import alice.kareltherobot.Direction;
import alice.kareltherobot.KarelWorld;
import alice.kareltherobot.UrRobot;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTextField;
import org.alice.apis.moveandturn.Model;
import org.alice.apis.moveandturn.ReferenceFrame;

public class RemoteControl
extends JFrame {
    private int id;
    private static int nextId = 0;
    private static int delta = 10;
    private UrRobot karel = null;
    BlockingQueue<Action> messages = new ArrayBlockingQueue<Action>(10);
    private ActionConsumer consumer = new ActionConsumer();

    public RemoteControl(int street, int avenue, Direction direction, int beepers) {
        this(street, avenue, direction, beepers, null);
    }

    public RemoteControl(int street, int avenue, Direction direction) {
        this(street, avenue, direction, -1, null);
    }

    public RemoteControl() {
        this(1, 1, Direction.NORTH, -1, null);
    }

    public RemoteControl(int street, int avenue, Direction direction, int beepers, org.alice.apis.moveandturn.Color color) {
        super("Robot " + nextId + " Controller");
        Container pane = this.getContentPane();
        if (color != null) {
            pane.setBackground(RemoteControl.transformColor(color));
        }
        this.karel = new UrRobot(street, avenue, direction, beepers, color);
        this.id = nextId;
        RemoteControl.incrementID();
        pane.setLayout(new GridLayout(3, 2));
        JButton move = new JButton("Move");
        move.addActionListener(new Mover());
        pane.add(move);
        JButton turn = new JButton("Turn Left");
        turn.addActionListener(new LeftTurner());
        pane.add(turn);
        JButton pick = new JButton("Pick Beeper");
        pick.addActionListener(new Picker());
        pane.add(pick);
        JButton put = new JButton("Put Beeper");
        put.addActionListener(new Putter());
        pane.add(put);
        JButton stop = new JButton("Turn Off");
        stop.addActionListener(new Stopper());
        pane.add(stop);
        JTextField field = new JTextField("robot" + this.id);
        field.setEditable(false);
        pane.add(field);
        this.addWindowListener(new Hider());
        this.setSize(300, 150);
        this.setLocation(720 + delta * (nextId - 1), 100 + delta * (nextId - 1));
        this.setVisible(true);
        this.karel.setSpeed(100.0);
        try {
            KarelWorld.currentWorld().addRobot(this.karel);
        }
        catch (Exception e) {
            System.out.println("Failure. Create a world before you create a remote control.");
        }
        Thread runner = new Thread(this.consumer);
        runner.start();
    }

    private static Color transformColor(org.alice.apis.moveandturn.Color color) {
        return new Color(new Double(255.0 * color.getRed()).intValue(), new Double(255.0 * color.getGreen()).intValue(), new Double(255.0 * color.getBlue()).intValue());
    }

    private static int incrementID() {
        return nextId++;
    }

    UrRobot robot() {
        return this.karel;
    }

    public void cameraFollow() {
        KarelWorld world = KarelWorld.currentWorld();
        world.getCamera().pointAt((ReferenceFrame)this.karel);
        world.cameraFollow((Model)this.karel);
    }

    static interface Action {
        public void act(UrRobot var1);
    }

    private class ActionConsumer
    implements Runnable {
        private ActionConsumer() {
        }

        public void run() {
            while (true) {
                try {
                    Action action;
                    do {
                        action = RemoteControl.this.messages.take();
                        action.act(RemoteControl.this.karel);
                    } while (!(action instanceof Stopper));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    private class Hider
    extends WindowAdapter {
        private Hider() {
        }

        public void windowClosing(WindowEvent e) {
            RemoteControl.this.setVisible(false);
        }
    }

    private class LeftTurner
    implements ActionListener,
    Action {
        private LeftTurner() {
        }

        public void actionPerformed(ActionEvent e) {
            if (((Boolean)RemoteControl.this.karel.value("r")).booleanValue()) {
                try {
                    RemoteControl.this.messages.put(this);
                    System.out.println("robot" + RemoteControl.this.id + ".turnLeft();");
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }

        public void act(UrRobot karel) {
            karel.turnLeft();
        }
    }

    private class Mover
    implements ActionListener,
    Action {
        private Mover() {
        }

        public void actionPerformed(ActionEvent e) {
            if (((Boolean)RemoteControl.this.karel.value("r")).booleanValue()) {
                RemoteControl.this.karel.setSpeed(10.0);
                try {
                    RemoteControl.this.messages.put(this);
                    System.out.println("robot" + RemoteControl.this.id + ".move();");
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }

        public void act(UrRobot karel) {
            karel.move();
        }
    }

    private class Picker
    implements ActionListener,
    Action {
        private Picker() {
        }

        public void actionPerformed(ActionEvent e) {
            if (((Boolean)RemoteControl.this.karel.value("r")).booleanValue()) {
                try {
                    RemoteControl.this.messages.put(this);
                    System.out.println("robot" + RemoteControl.this.id + ".pickBeeper();");
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }

        public void act(UrRobot karel) {
            karel.pickBeeper();
        }
    }

    private class Putter
    implements ActionListener,
    Action {
        private Putter() {
        }

        public void actionPerformed(ActionEvent e) {
            if (((Boolean)RemoteControl.this.karel.value("r")).booleanValue()) {
                try {
                    RemoteControl.this.messages.put(this);
                    System.out.println("robot" + RemoteControl.this.id + ".putBeeper();");
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }

        public void act(UrRobot karel) {
            karel.putBeeper();
        }
    }

    private class Stopper
    implements ActionListener,
    Action {
        private Stopper() {
        }

        public void actionPerformed(ActionEvent e) {
            if (((Boolean)RemoteControl.this.karel.value("r")).booleanValue()) {
                try {
                    RemoteControl.this.messages.put(this);
                    System.out.println("robot" + RemoteControl.this.id + ".turnOff();");
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }

        public void act(UrRobot karel) {
            karel.turnOff();
        }
    }
}

