/*
 * Decompiled with CFR 0.152.
 */
package alice.kareltherobot;

import alice.kareltherobot.Beeper;
import alice.kareltherobot.Direction;
import alice.kareltherobot.InfiniteBeepers;
import alice.kareltherobot.KarelWorld;
import alice.kareltherobot.Wall;
import edu.cmu.cs.dennisc.texture.BufferedImageTexture;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import org.alice.apis.moveandturn.AbstractCamera;
import org.alice.apis.moveandturn.Color;
import org.alice.apis.moveandturn.Composite;
import org.alice.apis.moveandturn.Model;
import org.alice.apis.moveandturn.MoveDirection;
import org.alice.apis.moveandturn.Orientation;
import org.alice.apis.moveandturn.PointOfView;
import org.alice.apis.moveandturn.Position;
import org.alice.apis.moveandturn.Quaternion;
import org.alice.apis.moveandturn.ReferenceFrame;
import org.alice.apis.moveandturn.SymmetricPerspectiveCamera;
import org.alice.apis.moveandturn.Transformable;
import org.alice.apis.moveandturn.TurnDirection;
import org.alice.apis.moveandturn.event.MouseButtonEvent;
import org.alice.apis.moveandturn.event.MouseButtonListener;
import org.alice.apis.moveandturn.gallery.scifi.KoalaRobot;
import org.alice.virtualmachine.DoTogether;

public class UrRobot
extends KoalaRobot {
    private int street;
    private int avenue;
    private Direction direction = Direction.WEST;
    private int beepers = 0;
    private boolean running = true;
    private Map<String, Object> stateMap = new HashMap<String, Object>();
    private boolean tracing = false;
    private double speed = 1.0;
    private Model colorPart = null;
    private Model trackedPart = null;

    public UrRobot(int street, int avenue, Direction direction) {
        this(street, avenue, direction, 0, null);
    }

    public UrRobot(int street, int avenue, Direction direction, int beepers) {
        this(street, avenue, direction, beepers, null);
    }

    public UrRobot(int street, int avenue, Direction direction, int beepers, Color color) {
        this.setName("UrRobot");
        if (street < 1) {
            throw new IllegalArgumentException("The street must be >= 1");
        }
        if (avenue < 1) {
            throw new IllegalArgumentException("The avenue must be >= 1");
        }
        this.street = street;
        this.avenue = avenue;
        this.setProgrammedByCredit("Cay Horstman and Joe Bergin");
        this.stateMap.put("s", street);
        this.stateMap.put("a", avenue);
        this.direction = direction;
        this.stateMap.put("d", direction);
        this.stateMap.put("r", true);
        this.setLocalPointOfView(new PointOfView((Orientation)new Quaternion((Number)0, (Number)0, (Number)0, (Number)1), new Position((Number)this.street, (Number)-0.1, (Number)this.avenue)));
        if (direction == Direction.NORTH) {
            this.turn(TurnDirection.RIGHT, 0.25);
        } else if (direction == Direction.EAST) {
            this.turn(TurnDirection.LEFT, 0.5);
        } else if (direction == Direction.SOUTH) {
            this.turn(TurnDirection.LEFT, 0.25);
        }
        this.addMouseButtonListener(new MouseButtonListener(){

            public void mouseButtonClicked(MouseButtonEvent arg0) {
                String what = "at (" + UrRobot.this.street + ", " + UrRobot.this.avenue + ") facing " + UrRobot.this.direction.getClass().getSimpleName() + " with " + UrRobot.this.beepers + " beepers";
                UrRobot.this.say(what);
                System.out.println(UrRobot.this.currentState());
            }
        });
        if (beepers < 0) {
            beepers = -1;
        }
        this.beepers = beepers;
        this.stateMap.put("b", beepers);
        try {
            BufferedImage newImage = ImageIO.read(new File("koa2.png"));
            BufferedImageTexture currentTexture = this.getSurfaceTexture().getBufferedImageTexture();
            currentTexture.setBufferedImage(newImage);
        }
        catch (IOException e) {
            System.out.println("Couldn't modify robot image");
            e.printStackTrace();
        }
        this.colorPart = this.getPart(new String[]{"Body"}).getPart(new String[]{"Head"});
        if (color != null) {
            this.colorPart.setColor(color);
            this.colorPart.getPart(new String[]{"LeftEar"}).setColor(Color.WHITE);
            this.colorPart.getPart(new String[]{"RightEar"}).setColor(Color.WHITE);
            this.colorPart.getPart(new String[]{"Nose"}).setColor(Color.BLACK);
        }
        this.trackedPart = this.getPart(new String[]{"Body"}).getPart(new String[]{"Head"});
    }

    public void setSpeed(double newSpeed) {
        if (newSpeed < 0.01) {
            newSpeed = 0.01;
        }
        if (newSpeed > 100.0) {
            newSpeed = 100.0;
        }
        this.speed = newSpeed;
    }

    Model trackedPart() {
        return this.trackedPart;
    }

    public KarelWorld getWorld() {
        try {
            return (KarelWorld)super.getScene();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void turnOff() {
        this.running = false;
        this.colorPart.setColor(Color.BLACK);
        this.stateMap.put("r", false);
        this.trace("turnOff.");
    }

    protected final UrRobot addToWorld(KarelWorld world) {
        world.addComponent((Transformable)this);
        return this;
    }

    public AbstractCamera getCamera() {
        Iterator iterator = this.getScene().findAllMatches(AbstractCamera.class).iterator();
        if (iterator.hasNext()) {
            Composite match = (Composite)iterator.next();
            return (AbstractCamera)match;
        }
        return null;
    }

    public void setTracing(boolean trace) {
        this.tracing = trace;
        if (this.tracing) {
            this.trace("starting trace.");
        }
    }

    private void trace(String action) {
        if (this.tracing) {
            System.out.println(String.valueOf(this.currentState()) + " action: " + action);
        }
    }

    public void move() {
        if (!this.running) {
            return;
        }
        final KarelWorld scene = (KarelWorld)this.getScene();
        int worldSize = scene.maximumBoundaryWall();
        if (this.street > worldSize - 10 || this.avenue > worldSize - 10) {
            scene.extendBoundaryWall();
        }
        if (!this.frontIsClear()) {
            this.think("Eeeks. I can't walk through a wall.", 2);
            this.turnOff();
            throw new IllegalStateException("Can't walk through a wall.");
        }
        this.street += this.direction.deltaStreet();
        this.avenue += this.direction.deltaAvenue();
        this.stateMap.put("s", this.street);
        this.stateMap.put("a", this.avenue);
        DoTogether.invokeAndWait((Runnable[])new Runnable[]{new Runnable(){

            public void run() {
                UrRobot.this.move(MoveDirection.FORWARD, 1.0, 1.0 / UrRobot.this.speed);
            }
        }, new Runnable(){

            public void run() {
                scene.track();
            }
        }});
        this.trace("move.");
    }

    public void turnLeft() {
        if (!this.running) {
            return;
        }
        this.direction = this.direction.next();
        this.stateMap.put("d", this.direction);
        this.turn(TurnDirection.LEFT, 0.25, 0.25 / this.speed);
        this.trace("turnLeft.");
    }

    public void pickBeeper() {
        if (!this.running) {
            return;
        }
        boolean picked = false;
        for (Composite match : this.getScene().findAllMatches(Beeper.class)) {
            Beeper beeper = (Beeper)match;
            if (beeper.street() != this.street || beeper.avenue() != this.avenue) continue;
            if (!(match instanceof InfiniteBeepers)) {
                this.getScene().removeComponent((Transformable)beeper);
            }
            picked = true;
            break;
        }
        if (!picked) {
            this.turnOff();
            this.think("Oh noes. There isn't a beeper here.", 2);
            throw new IllegalStateException("No beeper here to pick.");
        }
        if (this.beepers != -1) {
            ++this.beepers;
            this.stateMap.put("b", this.beepers);
        }
        this.trace("pickBeeper.");
    }

    public void putBeeper() {
        if (!this.running) {
            return;
        }
        if (this.beepers == 0) {
            this.turnOff();
            this.think("Egad, I don't have any beepers.", 2);
            throw new IllegalStateException("No beepers to put.");
        }
        this.getScene().addComponent((Transformable)new Beeper(this.street, this.avenue));
        if (this.beepers != -1) {
            --this.beepers;
            this.stateMap.put("b", this.beepers);
        }
        this.trace("putBeeper.");
    }

    private boolean frontIsClear() {
        for (Composite match : this.getScene().findAllMatches(Wall.class)) {
            Wall w = (Wall)match;
            if (w.xLocation() != (double)this.street + (double)this.direction.deltaStreet() * 0.5 || w.yLocation() != (double)this.avenue + (double)this.direction.deltaAvenue() * 0.5) continue;
            return false;
        }
        return true;
    }

    Object value(String key) {
        return this.stateMap.get(key);
    }

    public String currentState() {
        String directionName = this.direction == null ? "unknown" : this.direction.getClass().getSimpleName();
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "[street= " + this.street + ", avenue= " + this.avenue + ", direction= " + directionName + ", beepers= " + this.beepers + "]";
    }

    protected void draw(Graphics2D g2) {
        int dx = this.direction.deltaStreet();
        int dy = this.direction.deltaAvenue();
        Point2D.Double p1 = new Point2D.Double((double)this.street + 0.3 * (double)dx, (double)this.avenue + 0.3 * (double)dy);
        Point2D.Double p2 = new Point2D.Double((double)this.street - 0.15 * (double)dx, (double)this.avenue - 0.15 * (double)dy);
        Point2D.Double p3 = new Point2D.Double((double)this.street + 0.15 * (double)dy - 0.3 * (double)dx, (double)this.avenue - 0.3 * (double)dy + 0.15 * (double)dx);
        Point2D.Double p4 = new Point2D.Double((double)this.street - 0.15 * (double)dy - 0.3 * (double)dx, (double)this.avenue - 0.3 * (double)dy - 0.15 * (double)dx);
        g2.setStroke(new BasicStroke(0.05f));
        g2.draw(new Line2D.Double(p1, p3));
        g2.draw(new Line2D.Double(p2, p3));
        g2.draw(new Line2D.Double(p1, p4));
        g2.draw(new Line2D.Double(p2, p4));
    }

    public void assertFacingEast() {
        if (this.direction != Direction.EAST) {
            throw new RuntimeException("Robot is not facing East.");
        }
    }

    public void assertFacingNorth() {
        if (this.direction != Direction.NORTH) {
            throw new RuntimeException("Robot is not facing North.");
        }
    }

    public void assertFacingSouth() {
        if (this.direction != Direction.SOUTH) {
            throw new RuntimeException("Robot is not facing South.");
        }
    }

    public void assertFacingWest() {
        if (this.direction != Direction.WEST) {
            throw new RuntimeException("Robot is not facing West.");
        }
    }

    public void assertFrontIsClear() {
        if (!this.frontIsClear()) {
            throw new RuntimeException("Robot is blocked.");
        }
    }

    public void assertFrontIsBlocked() {
        if (this.frontIsClear()) {
            throw new RuntimeException("Robot is clear.");
        }
    }

    public void assertHasBeepers() {
        if (this.beepers == 0) {
            throw new RuntimeException("Robot has no beepers.");
        }
    }

    public void assertHasNoBeepers() {
        if (this.beepers != 0) {
            throw new RuntimeException("Robot has some beepers.");
        }
    }

    public void assertOnAvenue(int avenue) {
        if (this.avenue != avenue) {
            throw new RuntimeException("Robot is not on avenue " + avenue + ".");
        }
    }

    public void assertOnStreet(int street) {
        if (this.street != street) {
            throw new RuntimeException("Robot is not on street " + street + ".");
        }
    }

    public void assertNextToABeeper() {
        for (Composite match : this.getScene().findAllMatches(Beeper.class)) {
            Beeper beeper = (Beeper)match;
            if (beeper.street() != this.street || beeper.avenue() != this.avenue) continue;
            return;
        }
        throw new RuntimeException("Robot is not next to a beepeer.");
    }

    public void assertNextToARobot() {
        for (Composite match : this.getScene().findAllMatches(UrRobot.class)) {
            UrRobot robot = (UrRobot)match;
            if (robot.street != this.street || robot.avenue != this.avenue) continue;
            return;
        }
        throw new RuntimeException("Robot is not next to another robot.");
    }

    public void carryCamera() {
        SymmetricPerspectiveCamera camera = this.getWorld().getCamera();
        this.setSpeed(0.5);
        camera.moveAndOrientTo((ReferenceFrame)this.trackedPart);
        camera.setVehicle((Composite)this);
    }
}

