/*
 * Decompiled with CFR 0.152.
 */
package alice.kareltherobot;

import alice.kareltherobot.KarelWorld;
import alice.kareltherobot.KarelWorldItem;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.alice.apis.moveandturn.Color;
import org.alice.apis.moveandturn.Composite;
import org.alice.apis.moveandturn.Model;
import org.alice.apis.moveandturn.Orientation;
import org.alice.apis.moveandturn.PointOfView;
import org.alice.apis.moveandturn.Position;
import org.alice.apis.moveandturn.Quaternion;
import org.alice.apis.moveandturn.SymmetricPerspectiveCamera;
import org.alice.apis.moveandturn.Transformable;
import org.alice.apis.moveandturn.event.MouseButtonEvent;
import org.alice.apis.moveandturn.event.MouseButtonListener;
import org.alice.apis.moveandturn.gallery.shapes.Square;

public class Wall
extends Square
implements KarelWorldItem {
    static final int NORTH_SOUTH = 1;
    static final int EAST_WEST = 2;
    private final double wallDelta = 0.5;
    private boolean isBoundary;
    private int street;
    private int avenue;
    private int direction;

    Wall(int street, int avenue, int direction, boolean isBoundary) {
        this(street, avenue, direction);
        this.isBoundary = isBoundary;
    }

    public boolean isBoundary() {
        return this.isBoundary;
    }

    Wall(int street, int avenue, int direction) {
        this.direction = direction;
        this.isBoundary = false;
        this.setHeight(2.0);
        this.setWidth(0.9);
        this.setColor(Color.BLACK);
        this.setOpacity(0.55);
        this.setProgrammedByCredit("Joe Bergin");
        if (direction == 1) {
            this.street = street;
            this.avenue = avenue;
            Quaternion q = new Quaternion((Number)0, (Number)0, (Number)0, (Number)1);
            this.setLocalPointOfView(new PointOfView((Orientation)q, new Position((Number)this.street, (Number)0.5, (Number)((double)this.avenue + 0.5))));
        } else {
            this.street = street;
            this.avenue = avenue;
            Quaternion q = new Quaternion((Number)0, (Number)Math.sqrt(0.5), (Number)0, (Number)Math.sqrt(0.5));
            this.setLocalPointOfView(new PointOfView((Orientation)q, new Position((Number)((double)this.street + 0.5), (Number)0.5, (Number)this.avenue)));
        }
        this.addMouseButtonListener(new MouseButtonListener(){

            public void mouseButtonClicked(MouseButtonEvent arg0) {
                KarelWorld world = (KarelWorld)Wall.this.getScene();
                if (world == null || !world.permissionToAct()) {
                    return;
                }
                SymmetricPerspectiveCamera camera = world.getCamera();
                Square dummy = new Square();
                dummy.setHeight((Number)0);
                dummy.setLocalPointOfView(new PointOfView((Orientation)new Quaternion((Number)0, (Number)0, (Number)0, (Number)1), new Position((Number)Wall.this.street, (Number)3, (Number)Wall.this.avenue)));
                world.addComponent((Transformable)dummy);
                camera.moveToward((Number)camera.getDistanceTo((Model)dummy), (Composite)dummy, (Number)0);
                world.removeComponent((Transformable)dummy);
                world.refocusCamera();
            }
        });
    }

    public KarelWorld getWorld() {
        try {
            return (KarelWorld)super.getScene();
        }
        catch (Exception e) {
            return null;
        }
    }

    double xLocation() {
        return this.direction == 1 ? (double)this.street : (double)this.street + 0.5;
    }

    double yLocation() {
        return this.direction == 2 ? (double)this.avenue : (double)this.avenue + 0.5;
    }

    int getDirection() {
        return this.direction;
    }

    public int street() {
        return this.street;
    }

    public int avenue() {
        return this.avenue;
    }

    protected void draw(Graphics2D g2) {
        double THICKNESS = 0.1;
        if (this.direction == 1) {
            g2.fill(new Rectangle2D.Double((double)this.street - 0.5, (double)this.avenue + 0.5 - 0.05, 1.05, 0.1));
        } else {
            g2.fill(new Rectangle2D.Double((double)this.street + 0.5 - 0.05, (double)this.avenue - 0.5, 0.1, 1.05));
        }
    }
}

