/*
 * Decompiled with CFR 0.152.
 */
package com.jbergin.util;

import com.jbergin.util.OpenQuaternion;
import org.alice.apis.moveandturn.Quaternion;

public class QuaternionCalculator {
    public static OpenQuaternion rotationAboutX(double angleDegrees) {
        double radians = Math.toRadians(angleDegrees);
        return new OpenQuaternion(Math.sin(radians / 2.0), 0.0, 0.0, Math.cos(radians / 2.0));
    }

    public static OpenQuaternion rotationAboutY(double angleDegrees) {
        double radians = Math.toRadians(angleDegrees);
        return new OpenQuaternion(0.0, Math.sin(radians / 2.0), 0.0, Math.cos(radians / 2.0));
    }

    public static OpenQuaternion rotationAboutZ(double angleDegrees) {
        double radians = Math.toRadians(angleDegrees);
        return new OpenQuaternion(0.0, 0.0, Math.sin(radians / 2.0), Math.cos(radians / 2.0));
    }

    public static OpenQuaternion multiply(OpenQuaternion left, OpenQuaternion right) {
        double r = left.r() * right.r() - left.x() * right.x() - left.y() * right.y() - left.z() * right.z();
        double x = left.r() * right.x() + left.x() * right.r() + left.y() * right.z() - left.z() * right.y();
        double y = left.r() * right.y() - left.x() * right.z() + left.y() * right.r() + left.z() * right.x();
        double z = left.r() * right.z() + left.x() * right.y() - left.y() * right.x() + left.z() * right.r();
        return new OpenQuaternion(x, y, z, r);
    }

    public static OpenQuaternion add(OpenQuaternion left, OpenQuaternion right) {
        double r = left.r() + right.r();
        double x = left.x() + right.x();
        double y = left.y() + right.y();
        double z = left.z() + right.z();
        return new OpenQuaternion(x, y, z, r);
    }

    public static Quaternion toQuaternion(OpenQuaternion from) {
        return new Quaternion((Number)from.x(), (Number)from.y(), (Number)from.z(), (Number)from.r());
    }
}

