/* Copyright 2010, Joseph Bergin. All rights reserved.
 * License: Creative Commons Attribution-Noncommercial-Share Alike 3.0 United States License
 */

package alice.kareluser;

import org.alice.apis.moveandturn.Color;

import alice.kareltherobot.Direction;
import alice.kareltherobot.UrRobot;

/**
 * The task of a stair climber is to climb three steps and pick up a beeper from the top
 * step.
 * 
 * @author jbergin
 * 
 */
public class StairClimber extends UrRobot
{

	/**
	 * Create a robot on a specific street and avenue, facing a given direction with no
	 * beepers.
	 * 
	 * @param street the street on which to place the robot
	 * @param avenue the avenue on which to place the robot
	 * @param direction the direction the robot will initially face
	 */
	public StairClimber(int street, int avenue, Direction direction)
	{
		super(street, avenue, direction);

	}

	/**
	 * Create a robot on a specific street and avenue, facing a given direction with a
	 * given number of beepers.
	 * 
	 * @param street the street on which to place the robot
	 * @param avenue the avenue on which to place the robot
	 * @param direction the direction the robot will initially face
	 * @param beepers the initial number of beepers in the beeper bag
	 */
	public StairClimber(int street, int avenue, Direction direction, int beepers)
	{
		super(street, avenue, direction, beepers);

	}

	/**
	 * Create a robot on a specific street and avenue, facing a given direction with a
	 * given number of beepers and a given body color.
	 * 
	 * @param street the street on which to place the robot
	 * @param avenue the avenue on which to place the robot
	 * @param direction the direction the robot will initially face
	 * @param beepers the initial number of beepers in the beeper bag
	 * @param color the color of this robot
	 */
	public StairClimber(int street, int avenue, Direction direction, int beepers,
			Color color)
	{
		super(street, avenue, direction, beepers, color);
	}

	/**
	 * Robot turns 90 degrees clockwise (to its right).
	 */
	public void turnRight()
	{
		turnLeft();
		turnLeft();
		turnLeft();
	}

	/**
	 * Climb a stair one "street" high and one "avenue" wide.
	 */
	public void climbOneStair()
	{
		turnLeft();
		move();
		turnRight();
		move();
//		AbstractCamera camera = getCamera();
//		camera.moveToward(Math.max(.5, camera.getDistanceTo(this) - 3), this);

	}

	/**
	 * Climb three stairs
	 */
	public void climbStairs()
	{
		climbOneStair();
		climbOneStair();
		climbOneStair();
	}

	/**
	 * Climb the three stairs and pick the beeper.
	 */
	public void getBeeper()
	{
		climbStairs();
		pickBeeper();
	}

	/**
	 * Perform the task and announce its completion.
	 */
	public void task()
	{
		getBeeper();
		think("Found a beeper here.", 2);
		turnOff();
	}

}
