/* Copyright 2010, Joseph Bergin. All rights reserved.
 * License: Creative Commons Attribution-Noncommercial-Share Alike 3.0 United States License
 */

package alice.kareluser;

import org.alice.apis.moveandturn.AbstractCamera;
import org.alice.apis.moveandturn.Model;
import org.alice.apis.moveandturn.MoveDirection;
import org.alice.apis.moveandturn.RollDirection;
import org.alice.apis.moveandturn.SymmetricPerspectiveCamera;
import org.alice.apis.moveandturn.TurnDirection;

import alice.kareltherobot.Direction;
import alice.kareltherobot.KarelWorld;

/**
 * A simple world in which a stair climber will pick a beeper from the top (of three)
 * steps.
 * 
 * @author jbergin
 * 
 */
public class StairWorld extends KarelWorld
{

	private StairClimber karel;

	/**
	 * Execute the stair climbing task
	 * 
	 */
	@Override
	public void run()
	{
		karel.task();
	}

	/**
	 * Set up the stair climbing situation. This also illustrates how you can 
	 * move the camera about. 
	 * 
	 */
	@Override
	public void setTheStage()
	{
		addDecorations();
		karel = new StairClimber(1, 2, Direction.EAST, 0);
		karel.setTracing(true);
		AbstractCamera camera = getCamera();
		camera.move(MoveDirection.LEFT, 2);
		addRobot(karel);
		camera.pointAt(karel);
		cameraFollow(camera, karel);
		readWorld("worlds", "stairworld.kwld");
//		camera.moveToward(-3, karel);
	}

}
