/*
 * Decompiled with CFR 0.152.
 */
package org.alice.apis.moveandturn;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.math.AngleUtilities;
import edu.cmu.cs.dennisc.math.InterpolationUtilities;
import org.alice.apis.moveandturn.Angle;

public class AngleInRadians
extends Angle {
    private double m_radians;

    public AngleInRadians(Number other) {
        if (other instanceof edu.cmu.cs.dennisc.math.Angle) {
            this.setAsRadians(((edu.cmu.cs.dennisc.math.Angle)other).getAsRadians());
        } else {
            this.setAsRadians(other.doubleValue());
        }
    }

    public void decode(BinaryDecoder binaryDecoder) {
        this.m_radians = binaryDecoder.decodeDouble();
    }

    public void encode(BinaryEncoder binaryEncoder) {
        binaryEncoder.encode(this.m_radians);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Angle) {
            Angle a = (Angle)obj;
            return this.m_radians == a.getAsRadians();
        }
        return false;
    }

    public boolean isNaN() {
        return Double.isNaN(this.m_radians);
    }

    public void setNaN() {
        this.m_radians = Double.NaN;
    }

    public double getAsRadians() {
        return this.m_radians;
    }

    public double getAsDegrees() {
        return AngleUtilities.radiansToDegrees((double)this.m_radians);
    }

    public double getAsRevolutions() {
        return AngleUtilities.radiansToRevolutions((double)this.m_radians);
    }

    public void setAsRadians(double radians) {
        this.m_radians = radians;
    }

    public void setAsDegrees(double degrees) {
        this.m_radians = AngleUtilities.degreesToRadians((double)degrees);
    }

    public void setAsRevolutions(double revolutions) {
        this.m_radians = AngleUtilities.revolutionsToRadians((double)revolutions);
    }

    public Angle createCopy() {
        return new AngleInRadians(this);
    }

    public void set(edu.cmu.cs.dennisc.math.Angle other) {
        this.setAsRadians(other.getAsRadians());
    }

    public void setToInterpolation(edu.cmu.cs.dennisc.math.Angle a0, edu.cmu.cs.dennisc.math.Angle a1, double portion) {
        this.setAsRadians(InterpolationUtilities.interpolate((double)a0.getAsRadians(), (double)a1.getAsRadians(), (double)portion));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[");
        sb.append(this.m_radians);
        sb.append("]");
        return sb.toString();
    }
}

