/*
 * Decompiled with CFR 0.152.
 */
package org.alice.apis.moveandturn;

import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.scenegraph.Composite;
import edu.cmu.cs.dennisc.scenegraph.Element;
import edu.cmu.cs.dennisc.scenegraph.Geometry;
import edu.cmu.cs.dennisc.scenegraph.QuadArray;
import edu.cmu.cs.dennisc.scenegraph.SingleAppearance;
import edu.cmu.cs.dennisc.scenegraph.Transformable;
import edu.cmu.cs.dennisc.scenegraph.Vertex;
import edu.cmu.cs.dennisc.scenegraph.Visual;
import edu.cmu.cs.dennisc.scenegraph.bound.CumulativeBound;
import edu.cmu.cs.dennisc.texture.Texture;
import edu.cmu.cs.dennisc.texture.TextureFactory;
import org.alice.apis.moveandturn.AbstractModel;
import org.alice.apis.moveandturn.ImageSource;
import org.alice.virtualmachine.resources.ImageResource;

public class Billboard
extends AbstractModel {
    private Face sgFrontFace = new Face(true);
    private Face sgBackFace = new Face(false);
    private ImageSource frontImageSource;
    private ImageSource backImageSource;

    public Billboard() {
        Transformable sgTransformable = this.getSGTransformable();
        this.sgFrontFace.setParent((Composite)sgTransformable);
        this.sgBackFace.setParent((Composite)sgTransformable);
    }

    protected Visual getSGVisual() {
        return this.sgFrontFace;
    }

    private void updateAspectRatio() {
        int height;
        int width;
        Texture frontTexture = this.sgFrontFace.getTexture();
        Texture backTexture = this.sgBackFace.getTexture();
        if (frontTexture != null) {
            width = frontTexture.getWidth();
            height = frontTexture.getHeight();
        } else {
            width = -1;
            height = -1;
        }
        if ((width <= 0 || height <= 0) && backTexture != null) {
            width = backTexture.getWidth();
            height = backTexture.getHeight();
        }
        double widthToHeightAspectRatio = width > 0 && height > 0 ? (double)width / (double)height : 1.0;
        this.sgFrontFace.updateAspectRatio(widthToHeightAspectRatio);
        this.sgBackFace.updateAspectRatio(widthToHeightAspectRatio);
    }

    public ImageSource getFrontImageSource() {
        return this.frontImageSource;
    }

    public void setFrontImageSource(ImageSource frontImageSource) {
        this.frontImageSource = frontImageSource;
        Texture texture = this.frontImageSource != null ? TextureFactory.getTexture((ImageResource)frontImageSource.getImageResource(), (boolean)true) : null;
        this.updateAspectRatio();
        this.sgFrontFace.setTexture(texture);
    }

    public ImageSource getBackImageSource() {
        return this.backImageSource;
    }

    public void setBackImageSource(ImageSource backImageSource) {
        this.backImageSource = backImageSource;
        Texture texture = this.backImageSource != null ? TextureFactory.getTexture((ImageResource)backImageSource.getImageResource(), (boolean)true) : null;
        this.updateAspectRatio();
        this.sgBackFace.setTexture(texture);
    }

    protected CumulativeBound updateCumulativeBound(CumulativeBound rv, AffineMatrix4x4 trans, boolean isOriginIncluded) {
        super.updateCumulativeBound(rv, trans, isOriginIncluded);
        rv.add((Visual)this.sgFrontFace, trans);
        rv.add((Visual)this.sgBackFace, trans);
        return rv;
    }

    class Face
    extends Visual {
        private SingleAppearance sgAppearance = new SingleAppearance();
        private QuadArray sgGeometry = new QuadArray();
        private Vertex[] sgVertices = new Vertex[]{new Vertex(), new Vertex(), new Vertex(), new Vertex()};
        private boolean isFront;

        public Face(boolean isFront) {
            Billboard.this.putElement((Element)this);
            Billboard.this.putElement((Element)this.sgAppearance);
            Billboard.this.putElement((Element)this.sgGeometry);
            this.isFront = isFront;
            float k = this.getK();
            for (Vertex vertex : this.sgVertices) {
                vertex.normal.set(0.0f, 0.0f, k);
            }
            this.updateAspectRatio(1.0);
            this.sgAppearance.setDiffuseColorTextureClamped(true);
            this.sgGeometry.vertices.setValue((Object)this.sgVertices);
            this.frontFacingAppearance.setValue((Object)this.sgAppearance);
            this.geometries.setValue((Object)new Geometry[]{this.sgGeometry});
        }

        public void updateAspectRatio(double widthToHeightAspectRatio) {
            double x = widthToHeightAspectRatio * 0.5;
            float MIN_U = 0.0f;
            float MAX_U = 1.0f;
            float MIN_V = 1.0f;
            float MAX_V = 0.0f;
            Vertex v0 = this.sgVertices[this.getIndex(0)];
            v0.position.x = -x;
            v0.position.y = 1.0;
            v0.position.z = 0.0;
            v0.textureCoordinate0.u = 1.0f;
            v0.textureCoordinate0.v = 0.0f;
            Vertex v1 = this.sgVertices[this.getIndex(1)];
            v1.position.x = -x;
            v1.position.y = 0.0;
            v1.position.z = 0.0;
            v1.textureCoordinate0.u = 1.0f;
            v1.textureCoordinate0.v = 1.0f;
            Vertex v2 = this.sgVertices[this.getIndex(2)];
            v2.position.x = x;
            v2.position.y = 0.0;
            v2.position.z = 0.0;
            v2.textureCoordinate0.u = 0.0f;
            v2.textureCoordinate0.v = 1.0f;
            Vertex v3 = this.sgVertices[this.getIndex(3)];
            v3.position.x = x;
            v3.position.y = 1.0;
            v3.position.z = 0.0;
            v3.textureCoordinate0.u = 0.0f;
            v3.textureCoordinate0.v = 0.0f;
        }

        private int getIndex(int i) {
            if (this.isFront) {
                return this.sgVertices.length - 1 - i;
            }
            return i;
        }

        private float getK() {
            if (this.isFront) {
                return -1.0f;
            }
            return 1.0f;
        }

        public Texture getTexture() {
            return (Texture)this.sgAppearance.diffuseColorTexture.getValue();
        }

        public void setTexture(Texture texture) {
            this.sgAppearance.diffuseColorTexture.setValue((Object)texture);
            boolean isDiffuseColorTextureAlphaBlended = texture != null ? texture.isPotentiallyAlphaBlended() : false;
            this.sgAppearance.isDiffuseColorTextureAlphaBlended.setValue((Object)isDiffuseColorTextureAlphaBlended);
        }
    }
}

