/*
 * Decompiled with CFR 0.152.
 */
package org.alice.apis.moveandturn;

import edu.cmu.cs.dennisc.alice.ProgramClosedException;
import edu.cmu.cs.dennisc.alice.annotations.ClassTemplate;
import edu.cmu.cs.dennisc.alice.annotations.MethodTemplate;
import edu.cmu.cs.dennisc.alice.annotations.PropertyGetterTemplate;
import edu.cmu.cs.dennisc.alice.annotations.Visibility;
import edu.cmu.cs.dennisc.animation.Animation;
import edu.cmu.cs.dennisc.animation.AnimationObserver;
import edu.cmu.cs.dennisc.animation.DurationBasedAnimation;
import edu.cmu.cs.dennisc.equivalence.EquivalenceUtilities;
import edu.cmu.cs.dennisc.lookingglass.LookingGlass;
import edu.cmu.cs.dennisc.lookingglass.OnscreenLookingGlass;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.Orientation;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.math.Vector4;
import edu.cmu.cs.dennisc.media.Player;
import edu.cmu.cs.dennisc.media.animation.MediaPlayerAnimation;
import edu.cmu.cs.dennisc.media.jmf.MediaFactory;
import edu.cmu.cs.dennisc.pattern.Criterion;
import edu.cmu.cs.dennisc.pattern.DefaultPool;
import edu.cmu.cs.dennisc.pattern.NameEqualsCriterion;
import edu.cmu.cs.dennisc.pattern.Reusable;
import edu.cmu.cs.dennisc.print.PrintUtilities;
import edu.cmu.cs.dennisc.property.GetterSetterProperty;
import edu.cmu.cs.dennisc.scenegraph.AsSeenBy;
import java.awt.Component;
import java.awt.Point;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import javax.swing.SwingUtilities;
import org.alice.apis.moveandturn.AbstractCamera;
import org.alice.apis.moveandturn.AudioSource;
import org.alice.apis.moveandturn.Element;
import org.alice.apis.moveandturn.HowMuch;
import org.alice.apis.moveandturn.MoveDirection;
import org.alice.apis.moveandturn.PointOfView;
import org.alice.apis.moveandturn.Program;
import org.alice.apis.moveandturn.ReferenceFrame;
import org.alice.apis.moveandturn.Scene;
import org.alice.apis.moveandturn.SceneOwner;
import org.alice.apis.moveandturn.StandIn;
import org.alice.apis.moveandturn.Style;
import org.alice.apis.moveandturn.TraditionalStyle;
import org.alice.apis.moveandturn.Transformable;
import org.alice.apis.moveandturn.inputpanes.BooleanInputPane;
import org.alice.apis.moveandturn.inputpanes.DoubleInputPane;
import org.alice.apis.moveandturn.inputpanes.IntegerInputPane;
import org.alice.apis.moveandturn.inputpanes.StringInputPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ClassTemplate(isFollowToSuperClassDesired=true, isConsumptionBySubClassDesired=true)
public abstract class Composite
extends Element
implements ReferenceFrame {
    public static final Double DEFAULT_DURATION = 1.0;
    public static final Double RIGHT_NOW = 0.0;
    public static final Style DEFAULT_STYLE = TraditionalStyle.BEGIN_AND_END_GENTLY;
    public static final Style DEFAULT_SPEED_STYLE = TraditionalStyle.BEGIN_AND_END_ABRUPTLY;
    public static final HowMuch DEFAULT_HOW_MUCH = HowMuch.THIS_AND_DESCENDANT_PARTS;
    public static final GetterSetterProperty<Transformable[]> COMPONENTS_PROPERTY = new GetterSetterProperty(Composite.class, "Components");
    private List<Transformable> m_components = new LinkedList<Transformable>();
    private static DefaultPool<StandIn> s_standInPool = new DefaultPool(StandIn.class);
    private String m_name = "<unnamed>";

    protected void alreadyAdjustedDelay(Number duration) {
        if (duration != RIGHT_NOW) {
            this.perform((Animation)new DurationBasedAnimation(duration){

                protected void prologue() {
                }

                protected void setPortion(double portion) {
                }

                protected void epilogue() {
                }
            });
        }
    }

    @MethodTemplate(visibility=Visibility.TUCKED_AWAY)
    public PointOfView getPointOfView(ReferenceFrame asSeenBy) {
        return new PointOfView(this.getTransformation(asSeenBy));
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void delay(Number duration) {
        this.alreadyAdjustedDelay(this.adjustDurationIfNecessary(duration));
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public void print(Object ... values) {
        PrintUtilities.println((Object[])values);
    }

    protected static StandIn acquireStandIn(Composite composite) {
        StandIn rv = (StandIn)s_standInPool.acquire();
        rv.setVehicle(composite);
        rv.setLocalTransformation(AffineMatrix4x4.accessIdentity());
        return rv;
    }

    protected static void releaseStandIn(StandIn standIn) {
        s_standInPool.release((Reusable)standIn);
    }

    @Override
    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public Composite getActualReferenceFrame(Composite ths) {
        return this;
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public StandIn createOffsetStandIn(double x, double y, double z) {
        assert (!Double.isNaN(x));
        assert (!Double.isNaN(y));
        assert (!Double.isNaN(z));
        return this.createOffsetStandIn(MoveDirection.RIGHT, x, MoveDirection.UP, y, MoveDirection.BACKWARD, z);
    }

    @Deprecated
    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public Composite createOffsetStandInIfNecessary(Tuple3 offset) {
        if (offset != null) {
            return this.createOffsetStandIn(offset.x, offset.y, offset.z);
        }
        return this;
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public StandIn createOffsetStandIn(Tuple3 offset) {
        assert (offset != null);
        return this.createOffsetStandIn(offset.x, offset.y, offset.z);
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public StandIn createOffsetStandIn(Orientation offset) {
        StandIn standIn = new StandIn();
        standIn.setVehicle(this);
        standIn.getSGAbstractTransformable().setAxesOnly(offset, (edu.cmu.cs.dennisc.scenegraph.ReferenceFrame)AsSeenBy.PARENT);
        return standIn;
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public StandIn createOffsetStandIn(AffineMatrix4x4 offset) {
        StandIn standIn = new StandIn();
        standIn.setVehicle(this);
        standIn.getSGAbstractTransformable().setLocalTransformation(offset);
        return standIn;
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public StandIn createOffsetStandIn(MoveDirection direction, Number amount) {
        StandIn standIn = new StandIn();
        standIn.setVehicle(this);
        standIn.move(direction, amount, RIGHT_NOW);
        return standIn;
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public StandIn createOffsetStandIn(MoveDirection directionA, Number amountA, MoveDirection directionB, Number amountB) {
        StandIn standIn = new StandIn();
        standIn.setVehicle(this);
        standIn.move(directionA, amountA, RIGHT_NOW);
        standIn.move(directionB, amountB, RIGHT_NOW);
        return standIn;
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public StandIn createOffsetStandIn(MoveDirection directionA, Number amountA, MoveDirection directionB, Number amountB, MoveDirection directionC, Number amountC) {
        StandIn standIn = new StandIn();
        standIn.setVehicle(this);
        standIn.move(directionA, amountA, RIGHT_NOW);
        standIn.move(directionB, amountB, RIGHT_NOW);
        standIn.move(directionC, amountC, RIGHT_NOW);
        return standIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public void addComponent(Transformable component) {
        List<Transformable> list = this.m_components;
        synchronized (list) {
            if (component.getVehicle() != this) {
                assert (component.getVehicle() == null);
                this.m_components.add(component);
                component.handleVehicleChange(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public void removeComponent(Transformable component) {
        List<Transformable> list = this.m_components;
        synchronized (list) {
            assert (component.getVehicle() == this);
            assert (this.m_components.contains(component));
            this.m_components.remove(component);
            component.handleVehicleChange(null);
        }
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public Iterable<Transformable> getComponentIterable() {
        return this.m_components;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public void clearComponents() {
        List<Transformable> list = this.m_components;
        synchronized (list) {
            ListIterator<Transformable> listIterator = this.m_components.listIterator();
            while (listIterator.hasNext()) {
                Transformable component = listIterator.next();
                assert (component.getVehicle() == this);
                assert (this.m_components.contains(component));
                component.handleVehicleChange(null);
            }
            this.m_components.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transformable[] getComponents(Transformable[] rv) {
        List<Transformable> list = this.m_components;
        synchronized (list) {
            return this.m_components.toArray(rv);
        }
    }

    @PropertyGetterTemplate(visibility=Visibility.TUCKED_AWAY)
    public Transformable[] getComponents() {
        return this.getComponents(new Transformable[this.m_components.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComponents(Transformable ... components) {
        List<Transformable> list = this.m_components;
        synchronized (list) {
            this.clearComponents();
            for (Transformable component : components) {
                this.addComponent(component);
            }
        }
    }

    protected void handleOwnerChange(SceneOwner owner) {
        for (Transformable component : this.getComponents()) {
            component.handleOwnerChange(owner);
        }
    }

    @Override
    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public final edu.cmu.cs.dennisc.scenegraph.ReferenceFrame getSGReferenceFrame() {
        return this.getSGComposite();
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public abstract edu.cmu.cs.dennisc.scenegraph.Composite getSGComposite();

    @PropertyGetterTemplate(visibility=Visibility.PRIME_TIME)
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public abstract Scene getScene();

    @MethodTemplate(visibility=Visibility.TUCKED_AWAY)
    public final AbstractCamera findFirstCamera() {
        Scene scene = this.getScene();
        if (scene != null) {
            return scene.findFirstMatch(AbstractCamera.class);
        }
        return null;
    }

    @MethodTemplate(visibility=Visibility.TUCKED_AWAY)
    public abstract SceneOwner getOwner();

    @MethodTemplate(visibility=Visibility.TUCKED_AWAY)
    public LookingGlass getLookingGlass() {
        SceneOwner owner = this.getOwner();
        if (owner != null) {
            return owner.getOnscreenLookingGlass();
        }
        return null;
    }

    protected double adjustDurationIfNecessary(Number duration) {
        if (duration != RIGHT_NOW) {
            double simulationSpeedFactor = this.getGlobalSimulationSpeedFactor();
            duration = Double.isNaN(simulationSpeedFactor) ? RIGHT_NOW : Double.valueOf(duration.doubleValue() / simulationSpeedFactor);
        }
        return duration.doubleValue();
    }

    @PropertyGetterTemplate(visibility=Visibility.TUCKED_AWAY)
    public Double getGlobalSimulationSpeedFactor() {
        SceneOwner owner = this.getOwner();
        if (owner != null) {
            return owner.getSimulationSpeedFactor();
        }
        return Double.NaN;
    }

    public void setGlobalSimulationSpeedFactor(Number simulationSpeedFactor) {
        SceneOwner owner = this.getOwner();
        if (owner == null) {
            throw new RuntimeException();
        }
        owner.setSimulationSpeedFactor(simulationSpeedFactor.doubleValue());
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    protected void perform(Animation animation, AnimationObserver animationObserver) {
        SceneOwner owner = this.getOwner();
        if (owner != null) {
            owner.perform(animation, animationObserver);
        } else {
            animation.complete(animationObserver);
        }
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    protected final void perform(Animation animation) {
        this.perform(animation, null);
    }

    private <E extends Transformable> E getFirstChildNamed(Class<E> cls, String name) {
        for (Transformable child : this.getComponents()) {
            if (!cls.isAssignableFrom(child.getClass()) || !EquivalenceUtilities.areEquivalent((Object)child.getName(), (Object)name)) continue;
            return (E)child;
        }
        return null;
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public <E extends Transformable> E getDescendant(Class<E> cls, String ... pathOfNames) {
        Composite rv = this;
        for (String name : pathOfNames) {
            rv = rv.getFirstChildNamed(cls, name);
            assert (rv != null);
        }
        if (cls.isAssignableFrom(rv.getClass())) {
            return (E)((Transformable)rv);
        }
        return null;
    }

    protected List<String[]> update(List<String[]> rv, Stack<String> path, Class<? extends Transformable> cls) {
        for (Transformable child : this.getComponents()) {
            String name = child.getName();
            path.push(name);
            child.update(rv, path, cls);
            if (cls.isAssignableFrom(child.getClass())) {
                String[] array;
                for (String s : array = path.toArray(new String[path.size()])) {
                    assert (s != null);
                }
                rv.add(array);
            }
            path.pop();
        }
        return rv;
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public List<String[]> findPathsToAllDescendants(Class<? extends Transformable> cls) {
        LinkedList<String[]> rv = new LinkedList<String[]>();
        Stack<String> path = new Stack<String>();
        return this.update(rv, path, cls);
    }

    private static <E extends Composite> E getFirstToAccept(boolean isComponentACandidate, boolean isChildACandidate, boolean isGrandchildAndBeyondACandidate, Composite component, Class<E> cls, Criterion<?> ... criterions) {
        Composite rv;
        block10: {
            Transformable componentI;
            block9: {
                boolean isAcceptedByAll;
                assert (component != null);
                rv = null;
                if (isComponentACandidate) {
                    if (cls == null || cls.isAssignableFrom(component.getClass())) {
                        isAcceptedByAll = true;
                        if (criterions != null) {
                            for (Criterion<?> criterion : criterions) {
                                if (criterion.accept((Object)component)) continue;
                                isAcceptedByAll = false;
                                break;
                            }
                        }
                    } else {
                        isAcceptedByAll = false;
                    }
                } else {
                    isAcceptedByAll = false;
                }
                if (!isAcceptedByAll) break block9;
                rv = component;
                break block10;
            }
            if (!isChildACandidate) break block10;
            Iterator<Transformable> i$ = component.getComponentIterable().iterator();
            while (i$.hasNext() && (rv = Composite.getFirstToAccept(isChildACandidate, isGrandchildAndBeyondACandidate, isGrandchildAndBeyondACandidate, componentI = i$.next(), cls, criterions)) == null) {
            }
        }
        return (E)rv;
    }

    private static <E extends Composite> void updateAllToAccept(boolean isComponentACandidate, boolean isChildACandidate, boolean isGrandchildAndBeyondACandidate, List<E> list, Composite component, Class<E> cls, Criterion<?> ... criterions) {
        assert (component != null);
        if (isComponentACandidate && (cls == null || cls.isAssignableFrom(component.getClass()))) {
            boolean isAcceptedByAll = true;
            if (criterions != null) {
                for (Criterion<?> criterion : criterions) {
                    if (criterion.accept((Object)component)) continue;
                    isAcceptedByAll = false;
                    break;
                }
            }
            if (isAcceptedByAll) {
                list.add(component);
            }
        }
        if (isChildACandidate) {
            for (Transformable componentI : component.getComponentIterable()) {
                Composite.updateAllToAccept(isChildACandidate, isGrandchildAndBeyondACandidate, isGrandchildAndBeyondACandidate, list, componentI, cls, criterions);
            }
        }
    }

    private static <E extends Composite> E getFirstToAccept(HowMuch candidateMask, Composite component, Class<E> cls, Criterion<?> ... criterions) {
        return Composite.getFirstToAccept(candidateMask.isThisACandidate(), candidateMask.isChildACandidate(), candidateMask.isGrandchildAndBeyondACandidate(), component, cls, criterions);
    }

    private static <E extends Composite> void updateAllToAccept(HowMuch candidateMask, List<E> list, Composite component, Class<E> cls, Criterion<?> ... criterions) {
        Composite.updateAllToAccept(candidateMask.isThisACandidate(), candidateMask.isChildACandidate(), candidateMask.isGrandchildAndBeyondACandidate(), list, component, cls, criterions);
    }

    @MethodTemplate(visibility=Visibility.TUCKED_AWAY)
    public <E extends Composite> E findFirstMatch(HowMuch howMuch, Class<E> cls, Criterion<?> ... criterions) {
        return Composite.getFirstToAccept(howMuch, this, cls, criterions);
    }

    @MethodTemplate(visibility=Visibility.TUCKED_AWAY)
    public <E extends Composite> E findFirstMatch(Class<E> cls, Criterion<?> ... criterions) {
        return this.findFirstMatch(DEFAULT_HOW_MUCH, cls, criterions);
    }

    @MethodTemplate(visibility=Visibility.TUCKED_AWAY)
    public <E extends Composite> E findFirstMatch(Class<E> cls) {
        return this.findFirstMatch(cls, (Criterion[])null);
    }

    @MethodTemplate(visibility=Visibility.TUCKED_AWAY)
    public Element findFirstMatch(Criterion<?> ... criterions) {
        return this.findFirstMatch((Class<E>)null, criterions);
    }

    @MethodTemplate(visibility=Visibility.TUCKED_AWAY)
    public <E extends Transformable> E findFirstDescendantNamed(Class<E> cls, String name) {
        return (E)((Transformable)this.findFirstMatch(HowMuch.DESCENDANT_PARTS_ONLY, cls, new Criterion[]{new NameEqualsCriterion(name, false)}));
    }

    @MethodTemplate(visibility=Visibility.TUCKED_AWAY)
    public <E extends Composite> List<E> findAllMatches(HowMuch howMuch, Class<E> cls, Criterion<?> ... criterions) {
        LinkedList list = new LinkedList();
        Composite.updateAllToAccept(howMuch, list, this, cls, criterions);
        return list;
    }

    @MethodTemplate(visibility=Visibility.TUCKED_AWAY)
    public <E extends Composite> List<E> findAllMatches(Class<E> cls, Criterion<?> ... criterions) {
        return this.findAllMatches(DEFAULT_HOW_MUCH, cls, criterions);
    }

    @MethodTemplate(visibility=Visibility.TUCKED_AWAY)
    public <E extends Composite> List<E> findAllMatches(Class<E> cls) {
        return this.findAllMatches(cls, (Criterion[])null);
    }

    @MethodTemplate(visibility=Visibility.TUCKED_AWAY)
    public List<Composite> findAllMatches(Criterion<?> ... criterions) {
        return this.findAllMatches((Class<E>)null, criterions);
    }

    @MethodTemplate(visibility=Visibility.TUCKED_AWAY)
    public List<Composite> findAllMatches() {
        return this.findAllMatches((Class<E>)null, (Criterion<?>[])((Criterion[])null));
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public Point transformToAWT(Point rv, Point3 p, AbstractCamera camera) {
        Vector4 xyzw = new Vector4(p.x, p.y, p.z, 1.0);
        this.getSGComposite().transformToAWT(rv, xyzw, camera.getLookingGlass(), camera.getSGCamera());
        return rv;
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public Point transformToAWT(Point3 p, AbstractCamera camera) {
        return this.transformToAWT(new Point(), p, camera);
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public Point3 transformFromAWT(Point3 rv, Point p, double z, AbstractCamera camera) {
        Vector4 xyzw = new Vector4((double)p.x, (double)p.y, z, 1.0);
        this.getSGComposite().transformFromAWT(xyzw, p, z, camera.getLookingGlass(), camera.getSGCamera());
        rv.set(xyzw.x / xyzw.w, xyzw.y / xyzw.w, xyzw.z / xyzw.w);
        return rv;
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public Point3 transformFromAWT(Point p, double z, AbstractCamera camera) {
        return this.transformFromAWT(new Point3(), p, z, camera);
    }

    private Component getOwnerComponent() {
        OnscreenLookingGlass lg;
        SceneOwner owner = this.getOwner();
        if (owner != null && (lg = owner.getOnscreenLookingGlass()) != null) {
            return lg.getAWTComponent();
        }
        return null;
    }

    private void closeProgramInCaseOfNull(Object o) {
        if (o == null) {
            OnscreenLookingGlass lg;
            SceneOwner owner = this.getOwner();
            if (owner instanceof Program && (lg = owner.getOnscreenLookingGlass()) != null) {
                Component component = lg.getAWTComponent();
                Component root = SwingUtilities.getRoot(component);
                root.setVisible(false);
            }
            throw new ProgramClosedException();
        }
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Boolean getBooleanFromUser(String message) {
        BooleanInputPane inputPane = new BooleanInputPane(message);
        Boolean rv = (Boolean)inputPane.showInJDialog(this.getOwnerComponent());
        this.closeProgramInCaseOfNull(rv);
        return rv;
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public String getStringFromUser(String message) {
        StringInputPane inputPane = new StringInputPane(message);
        String rv = (String)inputPane.showInJDialog(this.getOwnerComponent());
        this.closeProgramInCaseOfNull(rv);
        return rv;
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Integer getIntegerFromUser(String message) {
        IntegerInputPane inputPane = new IntegerInputPane(message);
        Integer rv = (Integer)inputPane.showInJDialog(this.getOwnerComponent());
        this.closeProgramInCaseOfNull(rv);
        return rv;
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public Double getDoubleFromUser(String message) {
        DoubleInputPane inputPane = new DoubleInputPane(message);
        Double rv = (Double)inputPane.showInJDialog(this.getOwnerComponent());
        this.closeProgramInCaseOfNull(rv);
        return rv;
    }

    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void playAudio(AudioSource audioSource) {
        MediaFactory mediaFactory = MediaFactory.getSingleton();
        Player player = mediaFactory.createPlayer(audioSource.getAudioResource(), audioSource.getVolume().doubleValue(), audioSource.getStartTime().doubleValue(), audioSource.getStopTime().doubleValue());
        this.perform((Animation)new MediaPlayerAnimation(player));
    }
}

