/*
 * Decompiled with CFR 0.152.
 */
package org.alice.apis.moveandturn;

import edu.cmu.cs.dennisc.animation.Animation;
import edu.cmu.cs.dennisc.animation.interpolation.DoubleAnimation;
import edu.cmu.cs.dennisc.scenegraph.Cylinder;
import edu.cmu.cs.dennisc.scenegraph.Geometry;
import java.util.HashMap;
import java.util.Map;
import org.alice.apis.moveandturn.Model;
import org.alice.apis.moveandturn.Style;

public class Cone
extends Model {
    private static Map<Cylinder.BottomToTopAxis, BaseToTip> s_map = new HashMap<Cylinder.BottomToTopAxis, BaseToTip>();
    private Cylinder m_sgCylinder = new Cylinder();

    public Cone() {
        this.m_sgCylinder.topRadius.setValue((Object)0.0);
        this.m_sgCylinder.hasTopCap.setValue((Object)false);
    }

    protected void createSGGeometryIfNecessary() {
    }

    protected Geometry getSGGeometry() {
        return this.m_sgCylinder;
    }

    public Double getLength() {
        this.createSGGeometryIfNecessary();
        return (Double)this.m_sgCylinder.length.getValue();
    }

    public void setLength(Number length, Number duration, Style style) {
        this.createSGGeometryIfNecessary();
        this.perform((Animation)new DoubleAnimation(this.adjustDurationIfNecessary(duration), style, this.getLength(), length.doubleValue()){

            protected void updateValue(Double d) {
                ((Cone)Cone.this).m_sgCylinder.length.setValue((Object)d);
            }
        });
    }

    public final void setLength(Number radius, Number duration) {
        this.setLength(radius, duration, DEFAULT_STYLE);
    }

    public final void setLength(Number height) {
        this.setLength(height, DEFAULT_DURATION);
    }

    public Double getBaseRadius() {
        this.createSGGeometryIfNecessary();
        return (Double)this.m_sgCylinder.bottomRadius.getValue();
    }

    public void setBaseRadius(Number baseRadius, Number duration, Style style) {
        this.createSGGeometryIfNecessary();
        this.perform((Animation)new DoubleAnimation(this.adjustDurationIfNecessary(duration), style, this.getBaseRadius(), baseRadius.doubleValue()){

            protected void updateValue(Double d) {
                ((Cone)Cone.this).m_sgCylinder.bottomRadius.setValue((Object)d);
            }
        });
    }

    public final void setBaseRadius(Number baseRadius, Number duration) {
        this.setBaseRadius(baseRadius, duration, DEFAULT_STYLE);
    }

    public final void setBaseRadius(Number baseRadius) {
        this.setBaseRadius(baseRadius, DEFAULT_DURATION);
    }

    public BaseToTip getBaseToTip() {
        this.createSGGeometryIfNecessary();
        return s_map.get(this.m_sgCylinder.bottomToTopAxis.getValue());
    }

    public void setBaseToTip(BaseToTip baseToTip) {
        this.createSGGeometryIfNecessary();
        this.m_sgCylinder.bottomToTopAxis.setValue((Object)baseToTip.getBottomToTopAxis());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BaseToTip {
        LEFT_TO_RIGHT(Cylinder.BottomToTopAxis.POSITIVE_X),
        RIGHT_TO_LEFT(Cylinder.BottomToTopAxis.NEGATIVE_X),
        BOTTOM_TO_TOP(Cylinder.BottomToTopAxis.POSITIVE_Y),
        TOP_TO_BOTTOM(Cylinder.BottomToTopAxis.NEGATIVE_Y),
        FRONT_TO_BACK(Cylinder.BottomToTopAxis.POSITIVE_Z),
        BACK_TO_FRONT(Cylinder.BottomToTopAxis.NEGATIVE_Z);

        private Cylinder.BottomToTopAxis m_bottomToTopAxis;

        private BaseToTip(Cylinder.BottomToTopAxis bottomToTopAxis) {
            this.m_bottomToTopAxis = bottomToTopAxis;
            s_map.put(this.m_bottomToTopAxis, this);
        }

        private Cylinder.BottomToTopAxis getBottomToTopAxis() {
            return this.m_bottomToTopAxis;
        }
    }
}

