/*
 * Decompiled with CFR 0.152.
 */
package org.alice.apis.moveandturn;

import edu.cmu.cs.dennisc.alice.annotations.MethodTemplate;
import edu.cmu.cs.dennisc.alice.annotations.ParameterTemplate;
import edu.cmu.cs.dennisc.alice.annotations.PropertyGetterTemplate;
import edu.cmu.cs.dennisc.alice.annotations.Visibility;
import edu.cmu.cs.dennisc.animation.Animation;
import edu.cmu.cs.dennisc.animation.interpolation.FloatAnimation;
import edu.cmu.cs.dennisc.color.Color4f;
import edu.cmu.cs.dennisc.color.animation.Color4fAnimation;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.EpsilonUtilities;
import edu.cmu.cs.dennisc.math.Matrix3x3;
import edu.cmu.cs.dennisc.math.ScaleUtilities;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.pattern.Criterion;
import edu.cmu.cs.dennisc.print.PrintUtilities;
import edu.cmu.cs.dennisc.property.GetterSetterProperty;
import edu.cmu.cs.dennisc.scenegraph.Element;
import edu.cmu.cs.dennisc.scenegraph.Geometry;
import edu.cmu.cs.dennisc.scenegraph.SingleAppearance;
import edu.cmu.cs.dennisc.scenegraph.Visual;
import edu.cmu.cs.dennisc.scenegraph.bound.CumulativeBound;
import edu.cmu.cs.dennisc.texture.Texture;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.alice.apis.moveandturn.AbstractModel;
import org.alice.apis.moveandturn.Color;
import org.alice.apis.moveandturn.Composite;
import org.alice.apis.moveandturn.FillingStyle;
import org.alice.apis.moveandturn.HowMuch;
import org.alice.apis.moveandturn.Portion;
import org.alice.apis.moveandturn.Scale;
import org.alice.apis.moveandturn.ShadingStyle;
import org.alice.apis.moveandturn.Style;
import org.alice.apis.moveandturn.SurfaceTexture;
import org.alice.apis.moveandturn.Transformable;
import org.alice.apis.moveandturn.event.MouseButtonListener;
import org.alice.virtualmachine.DoTogether;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Model
extends AbstractModel {
    public static final GetterSetterProperty<Scale> VISUAL_SCALE_PROPERTY = new GetterSetterProperty(Model.class, "VisualScale");
    public static final GetterSetterProperty<Color> COLOR_PROPERTY = new GetterSetterProperty(Model.class, "Color");
    public static final GetterSetterProperty<Double> OPACITY_PROPERTY = new GetterSetterProperty(Model.class, "Opacity");
    public static final GetterSetterProperty<FillingStyle> FILLING_STYLE_PROPERTY = new GetterSetterProperty(Model.class, "FillingStyle");
    public static final GetterSetterProperty<ShadingStyle> SHADING_STYLE_PROPERTY = new GetterSetterProperty(Model.class, "ShadingStyle");
    public static final GetterSetterProperty<Boolean> IS_SHOWING_PROPERTY = new GetterSetterProperty(Model.class, "IsShowing");
    public static final GetterSetterProperty<Boolean> IS_BOUNDING_BOX_SHOWING_PROPERTY = new GetterSetterProperty(Model.class, "IsBoundingBoxShowing");
    public static final GetterSetterProperty<Boolean> IS_BOUNDING_SPHERE_SHOWING_PROPERTY = new GetterSetterProperty(Model.class, "IsBoundingSphereShowing");
    public static final GetterSetterProperty<SurfaceTexture> SURFACE_TEXTURE_PROPERTY = new GetterSetterProperty(Model.class, "SurfaceTexture");
    public static final GetterSetterProperty<SurfaceTexture[]> POTENTIAL_SURFACE_TEXTURES_PROPERTY = new GetterSetterProperty(Model.class, "PotentialSurfaceTextures");
    private Visual m_sgVisual = new Visual();
    private SingleAppearance m_sgAppearance = new SingleAppearance();
    private List<SurfaceTexture> m_potentialSurfaceTextures = new LinkedList<SurfaceTexture>();
    private List<MouseButtonListener> mouseButtonListeners = new LinkedList<MouseButtonListener>();
    private SurfaceTexture m_surfaceTexture;

    public Model() {
        this.putElement((Element)this.m_sgVisual);
        this.putElement((Element)this.m_sgAppearance);
        this.m_sgVisual.frontFacingAppearance.setValue((Object)this.m_sgAppearance);
        this.m_sgVisual.setParent((edu.cmu.cs.dennisc.scenegraph.Composite)this.getSGTransformable());
    }

    protected abstract void createSGGeometryIfNecessary();

    protected abstract Geometry getSGGeometry();

    @Override
    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public Visual getSGVisual() {
        return this.m_sgVisual;
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public SingleAppearance getSGSingleAppearance() {
        return this.m_sgAppearance;
    }

    @Override
    protected void realize() {
        this.createSGGeometryIfNecessary();
        Geometry sgGeometry = this.getSGGeometry();
        if (sgGeometry != null) {
            this.putElement((Element)sgGeometry);
            this.m_sgVisual.geometries.setValue((Object)new Geometry[]{sgGeometry});
        } else {
            PrintUtilities.println((Object[])new Object[]{"WARNING: no geometry: ", this});
        }
        super.realize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodTemplate(visibility=Visibility.PRIME_TIME)
    public void addMouseButtonListener(MouseButtonListener mouseButtonListener) {
        List<MouseButtonListener> list = this.mouseButtonListeners;
        synchronized (list) {
            this.mouseButtonListeners.add(mouseButtonListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodTemplate(visibility=Visibility.TUCKED_AWAY)
    public void removeMouseButtonListener(MouseButtonListener mouseButtonListener) {
        List<MouseButtonListener> list = this.mouseButtonListeners;
        synchronized (list) {
            this.mouseButtonListeners.remove(mouseButtonListener);
        }
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public List<MouseButtonListener> getMouseButtonListeners() {
        return this.mouseButtonListeners;
    }

    private Model getPartNamed(String name) {
        assert (name != null);
        for (Transformable component : this.getComponentIterable()) {
            if (!(component instanceof Model) || !name.equalsIgnoreCase(component.getName())) continue;
            return (Model)component;
        }
        return null;
    }

    private Model getPart(String[] path, int index) {
        Model part = this.getPartNamed(path[index]);
        if (index == path.length - 1) {
            return part;
        }
        return part.getPart(path, index + 1);
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public Model getPart(String ... path) {
        return this.getPart(path, 0);
    }

    @PropertyGetterTemplate(visibility=Visibility.TUCKED_AWAY)
    public Scale getVisualScale() {
        return new Scale((Matrix3x3)this.m_sgVisual.scale.getValue());
    }

    public void setVisualScale(Scale scale) {
        this.m_sgVisual.scale.setValue((Object)scale.getInternal());
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.m_sgVisual.setName(name + ".m_sgVisual");
        this.m_sgAppearance.setName(name + ".m_sgAppearance");
    }

    @PropertyGetterTemplate(visibility=Visibility.PRIME_TIME)
    public Color getColor() {
        return new Color((Color4f)this.m_sgAppearance.diffuseColor.getValue());
    }

    private HowMuch adjustHowMuchIfNecessary(HowMuch howMuch) {
        return howMuch;
    }

    public void setColor(final Color color, Number duration, final Style style, HowMuch howMuch) {
        final double actualDuration = this.adjustDurationIfNecessary(duration);
        HowMuch actualHowMuch = this.adjustHowMuchIfNecessary(howMuch);
        List<Model> models = this.findAllMatches(actualHowMuch, Model.class, new Criterion[0]);
        Runnable[] runnables = new Runnable[models.size()];
        int i = 0;
        for (final Model model : models) {
            runnables[i++] = new Runnable(){

                public void run() {
                    if (EpsilonUtilities.isWithinReasonableEpsilon((Number)actualDuration, (double)Composite.RIGHT_NOW)) {
                        model.m_sgAppearance.setDiffuseColor(color.getInternal());
                    } else {
                        Model.this.perform((Animation)new Color4fAnimation(actualDuration, style, Model.this.getColor().getInternal(), color.getInternal()){

                            protected void updateValue(Color4f color) {
                                model.m_sgAppearance.setDiffuseColor(color);
                            }
                        });
                    }
                }
            };
        }
        DoTogether.invokeAndWait((Runnable[])runnables);
    }

    public void setColor(Color color, Number duration, Style style) {
        this.setColor(color, duration, style, DEFAULT_HOW_MUCH);
    }

    public void setColor(Color color, Number duration) {
        this.setColor(color, duration, DEFAULT_STYLE);
    }

    public void setColor(Color color) {
        this.setColor(color, DEFAULT_DURATION);
    }

    @PropertyGetterTemplate(visibility=Visibility.PRIME_TIME)
    public Double getOpacity() {
        return ((Float)this.m_sgAppearance.opacity.getValue()).floatValue();
    }

    public void setOpacity(final @ParameterTemplate(preferredArgumentClass=Portion.class) Number opacity, Number duration, final Style style, HowMuch howMuch) {
        final double actualDuration = this.adjustDurationIfNecessary(duration);
        HowMuch actualHowMuch = this.adjustHowMuchIfNecessary(howMuch);
        List<Model> models = this.findAllMatches(actualHowMuch, Model.class, new Criterion[0]);
        Runnable[] runnables = new Runnable[models.size()];
        int i = 0;
        for (final Model model : models) {
            runnables[i++] = new Runnable(){

                public void run() {
                    if (EpsilonUtilities.isWithinReasonableEpsilon((Number)actualDuration, (double)Composite.RIGHT_NOW)) {
                        model.m_sgAppearance.setOpacity(opacity.floatValue());
                    } else {
                        Model.this.perform((Animation)new FloatAnimation(actualDuration, style, Float.valueOf(Model.this.getOpacity().floatValue()), Float.valueOf(opacity.floatValue())){

                            protected void updateValue(Float opacity) {
                                model.m_sgAppearance.setOpacity(opacity.floatValue());
                            }
                        });
                    }
                }
            };
        }
        DoTogether.invokeAndWait((Runnable[])runnables);
    }

    public void setOpacity(@ParameterTemplate(preferredArgumentClass=Portion.class) Number opacity, Number duration, Style style) {
        this.setOpacity(opacity, duration, style, DEFAULT_HOW_MUCH);
    }

    public void setOpacity(@ParameterTemplate(preferredArgumentClass=Portion.class) Number opacity, Number duration) {
        this.setOpacity(opacity, duration, DEFAULT_STYLE);
    }

    public void setOpacity(@ParameterTemplate(preferredArgumentClass=Portion.class) Number opacity) {
        this.setOpacity(opacity, DEFAULT_DURATION);
    }

    @PropertyGetterTemplate(visibility=Visibility.TUCKED_AWAY)
    public SurfaceTexture getSurfaceTexture() {
        return this.m_surfaceTexture;
    }

    public void setSurfaceTexture(SurfaceTexture surfaceTexture) {
        this.m_surfaceTexture = surfaceTexture;
        if (surfaceTexture != null) {
            this.m_sgAppearance.setDiffuseColorTexture((Texture)this.m_surfaceTexture.getBufferedImageTexture());
        } else {
            this.m_sgAppearance.setDiffuseColorTexture(null);
        }
    }

    @PropertyGetterTemplate(visibility=Visibility.TUCKED_AWAY)
    public FillingStyle getFillingStyle() {
        return FillingStyle.valueOf((edu.cmu.cs.dennisc.scenegraph.FillingStyle)this.m_sgAppearance.fillingStyle.getValue());
    }

    public void setFillingStyle(FillingStyle fillingStyle) {
        this.m_sgAppearance.setFillingStyle(fillingStyle.getSGFillingStyle());
    }

    @PropertyGetterTemplate(visibility=Visibility.TUCKED_AWAY)
    public ShadingStyle getShadingStyle() {
        return ShadingStyle.valueOf((edu.cmu.cs.dennisc.scenegraph.ShadingStyle)this.m_sgAppearance.shadingStyle.getValue());
    }

    public void setShadingStyle(ShadingStyle shadingStyle) {
        this.m_sgAppearance.setShadingStyle(shadingStyle.getSGShadingStyle());
    }

    @PropertyGetterTemplate(visibility=Visibility.TUCKED_AWAY)
    public Boolean isShowing() {
        return (Boolean)this.m_sgVisual.isShowing.getValue();
    }

    public void setShowing(Boolean isShowing) {
        this.m_sgVisual.isShowing.setValue((Object)isShowing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public void addPotentialSurfaceTexture(SurfaceTexture surfaceTexture) {
        assert (surfaceTexture != null);
        List<SurfaceTexture> list = this.m_potentialSurfaceTextures;
        synchronized (list) {
            this.m_potentialSurfaceTextures.add(surfaceTexture);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public void removePotentialSurfaceTexture(SurfaceTexture surfaceTexture) {
        assert (surfaceTexture != null);
        List<SurfaceTexture> list = this.m_potentialSurfaceTextures;
        synchronized (list) {
            assert (this.m_potentialSurfaceTextures.contains((Object)surfaceTexture));
            this.m_potentialSurfaceTextures.remove((Object)surfaceTexture);
        }
    }

    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public Iterable<SurfaceTexture> getPotentialSurfaceTextureIterable() {
        return this.m_potentialSurfaceTextures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodTemplate(visibility=Visibility.COMPLETELY_HIDDEN)
    public void clearPotentialSurfaceTextures() {
        List<SurfaceTexture> list = this.m_potentialSurfaceTextures;
        synchronized (list) {
            ListIterator<SurfaceTexture> listIterator = this.m_potentialSurfaceTextures.listIterator();
            while (listIterator.hasNext()) {
                this.removePotentialSurfaceTexture(listIterator.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SurfaceTexture[] getPotentialSurfaceTextures(SurfaceTexture[] rv) {
        List<SurfaceTexture> list = this.m_potentialSurfaceTextures;
        synchronized (list) {
            return this.m_potentialSurfaceTextures.toArray(rv);
        }
    }

    @PropertyGetterTemplate(visibility=Visibility.TUCKED_AWAY)
    public SurfaceTexture[] getPotentialSurfaceTextures() {
        return this.getPotentialSurfaceTextures(new SurfaceTexture[this.m_potentialSurfaceTextures.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPotentialSurfaceTextures(SurfaceTexture ... surfaceTextures) {
        List<SurfaceTexture> list = this.m_potentialSurfaceTextures;
        synchronized (list) {
            this.clearPotentialSurfaceTextures();
            for (SurfaceTexture surfaceTexture : surfaceTextures) {
                this.addPotentialSurfaceTexture(surfaceTexture);
            }
        }
    }

    @Override
    protected void applyScale(Vector3 axis, boolean isScootDesired) {
        super.applyScale(axis, isScootDesired);
        Matrix3x3 scale = (Matrix3x3)this.m_sgVisual.scale.getValue();
        ScaleUtilities.applyScale((Matrix3x3)scale, (Tuple3)axis);
        this.m_sgVisual.scale.setValue((Object)scale);
    }

    @Override
    protected CumulativeBound updateCumulativeBound(CumulativeBound rv, AffineMatrix4x4 trans, boolean isOriginIncluded) {
        super.updateCumulativeBound(rv, trans, isOriginIncluded);
        if (((Boolean)this.m_sgVisual.isShowing.getValue()).booleanValue()) {
            rv.add(this.m_sgVisual, trans);
        }
        return rv;
    }
}

