/*
 * Decompiled with CFR 0.152.
 */
package org.alice.apis.moveandturn;

import edu.cmu.cs.dennisc.lang.ClassUtilities;
import edu.cmu.cs.dennisc.math.AbstractMatrix3x3;
import edu.cmu.cs.dennisc.math.AxisAlignedBox;
import edu.cmu.cs.dennisc.math.Matrix3x3;
import edu.cmu.cs.dennisc.print.PrintUtilities;
import java.util.HashSet;
import java.util.Set;
import org.alice.apis.moveandturn.AbstractCamera;
import org.alice.apis.moveandturn.AbstractModel;
import org.alice.apis.moveandturn.Light;
import org.alice.apis.moveandturn.Transformable;
import org.alice.interact.PickHint;

public class PickHintUtilities {
    private static Set<Class<?>> groundClses;

    private PickHintUtilities() {
        throw new AssertionError();
    }

    private static boolean isGround(AbstractModel model) {
        for (Class<?> cls : groundClses) {
            if (!cls.isAssignableFrom(model.getClass())) continue;
            return true;
        }
        return false;
    }

    public static Transformable setPickHint(Transformable rv) {
        edu.cmu.cs.dennisc.scenegraph.Transformable sgTransformable = rv.getSGTransformable();
        if (rv instanceof AbstractModel) {
            AbstractModel model = (AbstractModel)rv;
            if (PickHintUtilities.isGround(model)) {
                sgTransformable.putBonusDataFor((Object)"PICK_HINT_KEY", (Object)PickHint.GROUND);
            } else {
                sgTransformable.putBonusDataFor((Object)"PICK_HINT_KEY", (Object)PickHint.MOVEABLE_OBJECTS);
                AxisAlignedBox box = model.getAxisAlignedMinimumBoundingBox();
                Matrix3x3 scale = model.getOriginalScale();
                if (scale != null && !scale.isNaN() && !scale.isIdentity()) {
                    Matrix3x3 scaleInv = new Matrix3x3((AbstractMatrix3x3)scale);
                    scaleInv.invert();
                    box.scale(scaleInv);
                }
                sgTransformable.putBonusDataFor((Object)"BOUNDING_BOX_KEY", (Object)box);
            }
        } else if (rv instanceof Light) {
            sgTransformable.putBonusDataFor((Object)"PICK_HINT_KEY", (Object)PickHint.LIGHT);
        } else if (rv instanceof AbstractCamera) {
            sgTransformable.putBonusDataFor((Object)"PICK_HINT_KEY", (Object)PickHint.CAMERA);
        }
        return rv;
    }

    static {
        String[] clsNames;
        groundClses = new HashSet();
        for (String clsName : clsNames = new String[]{"org.alice.apis.moveandturn.gallery.environments.Ground", "org.alice.apis.moveandturn.gallery.environments.grounds.DirtGround", "org.alice.apis.moveandturn.gallery.environments.grounds.GrassyGround", "org.alice.apis.moveandturn.gallery.environments.grounds.MoonSurface", "org.alice.apis.moveandturn.gallery.environments.grounds.SandyGround", "org.alice.apis.moveandturn.gallery.environments.grounds.SeaSurface", "org.alice.apis.moveandturn.gallery.environments.grounds.SnowyGround"}) {
            try {
                Class cls = ClassUtilities.forName((String)clsName);
                groundClses.add(cls);
            }
            catch (ClassNotFoundException cnfe) {
                PrintUtilities.println((Object[])new Object[]{"WARNING: could not find class:", clsName});
            }
        }
    }
}

