/*
 * Decompiled with CFR 0.152.
 */
package org.alice.apis.moveandturn;

import edu.cmu.cs.dennisc.alice.annotations.ParameterTemplate;
import edu.cmu.cs.dennisc.alice.annotations.PropertyGetterTemplate;
import edu.cmu.cs.dennisc.alice.annotations.Visibility;
import edu.cmu.cs.dennisc.animation.Animation;
import edu.cmu.cs.dennisc.animation.interpolation.DoubleAnimation;
import edu.cmu.cs.dennisc.math.Angle;
import edu.cmu.cs.dennisc.math.EpsilonUtilities;
import edu.cmu.cs.dennisc.property.GetterSetterProperty;
import edu.cmu.cs.dennisc.scenegraph.Light;
import org.alice.apis.moveandturn.AngleInRevolutions;
import org.alice.apis.moveandturn.PointLight;
import org.alice.apis.moveandturn.Style;

public class SpotLight
extends PointLight {
    public static final GetterSetterProperty<Double> OUTER_BEAM_ANGLE_PROPERTY = new GetterSetterProperty(SpotLight.class, "OuterBeamAngle");
    public static final GetterSetterProperty<Double> FALLOFF_PROPERTY = new GetterSetterProperty(SpotLight.class, "Falloff");
    private edu.cmu.cs.dennisc.scenegraph.SpotLight m_sgSpotLight;

    protected Light getSGLight() {
        if (this.m_sgSpotLight == null) {
            this.m_sgSpotLight = new edu.cmu.cs.dennisc.scenegraph.SpotLight();
        }
        return this.m_sgSpotLight;
    }

    @PropertyGetterTemplate(visibility=Visibility.PRIME_TIME)
    public Double getOuterBeamAngle() {
        return ((Angle)this.m_sgSpotLight.outerBeamAngle.getValue()).getAsRevolutions();
    }

    public void setOuterBeamAngle(@ParameterTemplate(preferredArgumentClass=AngleInRevolutions.class) Number outerBeamAngle, Number duration, Style style) {
        if (EpsilonUtilities.isWithinReasonableEpsilon((Number)(duration = Double.valueOf(this.adjustDurationIfNecessary(duration))), (double)RIGHT_NOW)) {
            this.m_sgSpotLight.outerBeamAngle.setValue((Object)new edu.cmu.cs.dennisc.math.AngleInRevolutions(outerBeamAngle.doubleValue()));
        } else {
            this.perform((Animation)new DoubleAnimation(duration, style, (double)this.getOuterBeamAngle(), outerBeamAngle.doubleValue()){

                protected void updateValue(Double a) {
                    ((SpotLight)SpotLight.this).m_sgSpotLight.outerBeamAngle.setValue((Object)new edu.cmu.cs.dennisc.math.AngleInRevolutions(a.doubleValue()));
                }
            });
        }
    }

    public void setOuterBeamAngle(@ParameterTemplate(preferredArgumentClass=AngleInRevolutions.class) Number outerBeamAngle, Number duration) {
        this.setOuterBeamAngle(outerBeamAngle, duration, DEFAULT_STYLE);
    }

    public void setOuterBeamAngle(@ParameterTemplate(preferredArgumentClass=AngleInRevolutions.class) Number outerBeamAngle) {
        this.setOuterBeamAngle(outerBeamAngle, DEFAULT_DURATION);
    }

    @PropertyGetterTemplate(visibility=Visibility.PRIME_TIME)
    public Double getFalloff() {
        return (Double)this.m_sgSpotLight.falloff.getValue();
    }

    public void setFalloff(Number falloff, Number duration, Style style) {
        if (EpsilonUtilities.isWithinReasonableEpsilon((Number)(duration = Double.valueOf(this.adjustDurationIfNecessary(duration))), (double)RIGHT_NOW)) {
            this.m_sgSpotLight.falloff.setValue((Object)falloff.doubleValue());
        } else {
            this.perform((Animation)new DoubleAnimation(duration, style, this.getFalloff(), falloff.doubleValue()){

                protected void updateValue(Double v) {
                    ((SpotLight)SpotLight.this).m_sgSpotLight.falloff.setValue((Object)v);
                }
            });
        }
    }

    public void setFalloff(Number falloff, Number duration) {
        this.setFalloff(falloff, duration, DEFAULT_STYLE);
    }

    public void setFalloff(Number falloff) {
        this.setFalloff(falloff, DEFAULT_DURATION);
    }
}

