/*
 * Decompiled with CFR 0.152.
 */
package org.alice.apis.moveandturn.event;

import edu.cmu.cs.dennisc.lookingglass.OnscreenLookingGlass;
import edu.cmu.cs.dennisc.lookingglass.PickResult;
import edu.cmu.cs.dennisc.pattern.event.Event;
import edu.cmu.cs.dennisc.scenegraph.Composite;
import edu.cmu.cs.dennisc.scenegraph.Visual;
import java.awt.Component;
import java.awt.event.MouseEvent;
import org.alice.apis.moveandturn.Element;
import org.alice.apis.moveandturn.Model;
import org.alice.apis.moveandturn.Scene;
import org.alice.apis.moveandturn.SceneOwner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MouseButtonEvent
extends Event<Component> {
    private MouseEvent e;
    private Scene scene;
    private boolean isPickPerformed;
    private Model partAtMouseLocation;
    private Model modelAtMouseLocation;

    public MouseButtonEvent(MouseEvent e, Scene scene) {
        super((Object)e.getComponent());
        this.e = e;
        this.scene = scene;
        this.isPickPerformed = false;
    }

    private synchronized void pickIfNecessary() {
        if (!this.isPickPerformed) {
            Visual sgVisual;
            PickResult pickResult;
            OnscreenLookingGlass lg;
            SceneOwner owner;
            if (this.scene != null && (owner = this.scene.getOwner()) != null && (lg = owner.getOnscreenLookingGlass()) != null && (pickResult = lg.pickFrontMost(this.e.getX(), this.e.getY(), false)) != null && (sgVisual = pickResult.getVisual()) != null) {
                Composite sgParent;
                Element element = Element.getElement((edu.cmu.cs.dennisc.scenegraph.Element)sgVisual);
                if (element instanceof Model) {
                    this.partAtMouseLocation = (Model)element;
                }
                Visual sgComponent = sgVisual;
                while ((sgParent = sgComponent.getParent()) != null) {
                    if (sgParent == this.scene.getSGComposite()) {
                        Element e = Element.getElement((edu.cmu.cs.dennisc.scenegraph.Element)sgComponent);
                        if (!(e instanceof Model)) break;
                        this.modelAtMouseLocation = (Model)e;
                        break;
                    }
                    sgComponent = sgParent;
                }
            }
            this.isPickPerformed = true;
        }
    }

    public Model getPartAtMouseLocation() {
        this.pickIfNecessary();
        return this.partAtMouseLocation;
    }

    public Model getModelAtMouseLocation() {
        this.pickIfNecessary();
        return this.modelAtMouseLocation;
    }
}

